/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.commons.io;

import java.util.Date;
import java.util.EventObject;

public class LogEvent
extends EventObject {
    private Date timestamp;
    private String stream;
    private Object category;
    private String message;
    private int type;
    private static final int MSG_LOGGED = 1;
    private static final int STREAM_STARTED = 2;
    private static final int STREAM_STOPPED = 3;

    public LogEvent(Date timestamp, String source, Object category, String message) {
        super(source);
        this.type = 1;
        this.timestamp = timestamp;
        this.category = category;
        this.message = message;
    }

    public LogEvent(String stream, Date timestamp, String source) {
        super(source);
        this.type = 2;
        this.stream = stream;
        this.timestamp = timestamp;
    }

    public LogEvent(String stream) {
        super(stream);
        this.type = 3;
        this.stream = stream;
    }

    public Object getCategory() {
        return this.category;
    }

    public String getMessage() {
        return this.message;
    }

    public String getStream() {
        return this.stream;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String toString() {
        switch (this.type) {
            case 1: {
                return "Log Event (message logged)";
            }
            case 2: {
                return "Log Event (stream started)";
            }
            case 3: {
                return "Log Event (stream stopped)";
            }
        }
        return "Unknown Log Event Type";
    }
}

