/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.commons.io;

import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import org.apache.oodt.commons.io.LogEvent;
import org.apache.oodt.commons.io.LogListener;

public class LogFilter
implements LogListener {
    protected boolean passThrough;
    protected HashMap categories = new HashMap();
    protected static final Object DUMMY = new Object();
    protected LogListener listener;

    public LogFilter(LogListener listener, boolean passThrough, Object[] categories) {
        if (listener == null) {
            throw new IllegalArgumentException("Can't filter messages to a null listener");
        }
        this.listener = listener;
        this.passThrough = passThrough;
        if (categories == null) {
            return;
        }
        for (Object category : categories) {
            this.categories.put(category, DUMMY);
        }
    }

    public LogFilter(LogListener listener, boolean passThrough) {
        this(listener, passThrough, null);
    }

    public void addCategory(Object category) {
        this.categories.put(category, DUMMY);
    }

    public void removeCategory(Object category) {
        this.categories.remove(category);
    }

    @Override
    public void streamStarted(LogEvent event) {
        this.listener.streamStarted(event);
    }

    @Override
    public void streamStopped(LogEvent event) {
        this.listener.streamStopped(event);
    }

    @Override
    public void messageLogged(LogEvent event) {
        boolean found = this.categories.containsKey(event.getCategory());
        if (this.passThrough && !found || !this.passThrough && found) {
            this.listener.messageLogged(event);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent ignore) {
    }
}

