/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.commons.io;

import java.io.Writer;
import java.util.Date;
import org.apache.oodt.commons.io.Log;

public class LogWriter
extends Writer {
    public static final int CAPACITY = 80;
    private StringBuffer buf = new StringBuffer(80);
    private Date timestamp;
    private String source;
    private Object category;
    private boolean flushed;

    LogWriter(Date timestamp, String source, Object category) {
        this.lock = this.buf;
        this.timestamp = timestamp;
        this.source = source;
        this.category = category;
        this.flushed = false;
    }

    @Override
    public void write(int c) {
        if (this.buf == null) {
            return;
        }
        this.buf.append((char)c);
    }

    @Override
    public void write(char[] array, int offset, int length) {
        if (this.buf == null || length == 0) {
            return;
        }
        if (offset < 0 || offset > array.length || length < 0 || offset + length > array.length || offset + length < 0) {
            throw new IndexOutOfBoundsException("Can't write " + length + " characters at " + offset + " from array whose length is " + array.length);
        }
        this.buf.append(array, offset, length);
    }

    @Override
    public void write(char[] array) {
        this.write(array, 0, array.length);
    }

    @Override
    public void write(String string, int offset, int length) {
        if (this.buf == null || length == 0) {
            return;
        }
        this.buf.append(string.substring(offset, offset + length));
    }

    @Override
    public void write(String string) {
        this.write(string, 0, string.length());
    }

    @Override
    public void flush() {
        if (this.buf == null) {
            return;
        }
        Log.logMessage(this.timestamp, this.source, this.category, this.buf.toString());
        this.buf.setLength(0);
        this.flushed = true;
    }

    @Override
    public void close() {
        this.flush();
        this.buf = null;
    }

    public void print(boolean b) {
        this.write(b ? "true" : "false");
    }

    public void print(char c) {
        this.write(String.valueOf(c));
    }

    public void print(int i) {
        this.write(String.valueOf(i));
    }

    public void print(long l) {
        this.write(String.valueOf(l));
    }

    public void print(float f) {
        this.write(String.valueOf(f));
    }

    public void print(double d) {
        this.write(String.valueOf(d));
    }

    public void print(char[] a) {
        this.write(a);
    }

    public void print(String s) {
        if (s == null) {
            s = "null";
        }
        this.write(s);
    }

    public void print(Object obj) {
        this.write(String.valueOf(obj));
    }

    public void println(boolean b) {
        this.print(b);
        this.println();
    }

    public void println(char c) {
        this.print(c);
        this.println();
    }

    public void println(int i) {
        this.print(i);
        this.println();
    }

    public void println(long l) {
        this.print(l);
        this.println();
    }

    public void println(float f) {
        this.print(f);
        this.println();
    }

    public void println(double d) {
        this.print(d);
        this.println();
    }

    public void println(char[] a) {
        this.print(a);
        this.println();
    }

    public void println(String s) {
        this.print(s);
        this.println();
    }

    public void println(Throwable t) {
        if (t == null) {
            this.println("Null throwable");
        } else {
            StackTraceElement[] frames = t.getStackTrace();
            this.println(t.getClass().getName() + ":");
            for (StackTraceElement frame : frames) {
                this.println(frame);
            }
        }
    }

    public void println(Object obj) {
        this.print(obj);
        this.println();
    }

    public void println() {
        this.flush();
    }

    public boolean isFlushed() {
        return this.flushed;
    }
}

