/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.commons.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.CharBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggerOutputStream
extends OutputStream {
    public static final String NUM_BYTES_PER_WRITE_PROPERTY = "org.apache.oodt.commons.io.logger.os.bytes.per.write";
    public static final int VAL = 512;
    private static final int NUM_BYTES_PER_WRITE = Integer.getInteger("org.apache.oodt.commons.io.logger.os.bytes.per.write", 512);
    private Logger logger;
    private CharBuffer buffer;
    private Level logLevel;

    public LoggerOutputStream(Logger logger) throws InstantiationException {
        this(logger, Level.INFO);
    }

    public LoggerOutputStream(Logger logger, Level logLevel) {
        this(logger, NUM_BYTES_PER_WRITE, logLevel);
    }

    public LoggerOutputStream(Logger logger, int numOfBytesPerWrite) {
        this(logger, numOfBytesPerWrite, Level.INFO);
    }

    public LoggerOutputStream(Logger logger, int numOfBytesPerWrite, Level logLevel) {
        this.logger = logger;
        this.buffer = CharBuffer.wrap(new char[numOfBytesPerWrite]);
        this.logLevel = logLevel;
    }

    @Override
    public void write(int b) throws IOException {
        if (!this.buffer.hasRemaining()) {
            this.flush();
        }
        this.buffer.put((char)b);
    }

    @Override
    public void flush() {
        if (this.buffer.position() > 0) {
            char[] flushContext = new char[this.buffer.position()];
            System.arraycopy(this.buffer.array(), 0, flushContext, 0, this.buffer.position());
            this.logger.log(this.logLevel, new String(flushContext));
            this.buffer.clear();
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        super.close();
    }
}

