/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.commons.io;

import java.io.IOException;
import java.io.OutputStream;

public class NullOutputStream
extends OutputStream {
    private boolean open = true;

    @Override
    public void write(int b) throws IOException {
        this.checkOpen();
    }

    @Override
    public void write(byte[] a, int offset, int length) throws IOException {
        if (a == null) {
            throw new NullPointerException("Can't write a null array");
        }
        if (offset < 0 || offset > a.length || length < 0 || offset + length > a.length || offset + length < 0) {
            throw new IndexOutOfBoundsException("Offset " + offset + " and length " + length + " not in array of length " + a.length);
        }
        this.checkOpen();
    }

    @Override
    public void flush() throws IOException {
        this.checkOpen();
    }

    @Override
    public void close() throws IOException {
        this.checkOpen();
        this.open = false;
    }

    private void checkOpen() throws IOException {
        if (!this.open) {
            throw new IOException("Stream closed");
        }
    }
}

