/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.commons.io;

import java.beans.PropertyChangeEvent;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Date;
import org.apache.oodt.commons.io.LogEvent;
import org.apache.oodt.commons.io.LogListener;
import org.apache.oodt.commons.util.DateConvert;

public class WriterLogger
implements LogListener {
    protected Writer writer;
    protected boolean autoFlush;
    protected String lineSep;

    public WriterLogger(OutputStream outputStream) {
        this(new BufferedWriter(new OutputStreamWriter(outputStream)), true);
    }

    public WriterLogger(Writer writer) {
        this(writer, true);
    }

    public WriterLogger(Writer writer, boolean autoFlush) {
        if (writer == null) {
            throw new IllegalArgumentException("Can't write to a null writer");
        }
        this.writer = writer;
        this.autoFlush = autoFlush;
        this.lineSep = System.getProperty("line.separator", "\n");
    }

    public final void close() {
        if (this.writer == null) {
            return;
        }
        try {
            this.writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.writer = null;
    }

    @Override
    public final void messageLogged(LogEvent event) {
        if (this.writer == null) {
            return;
        }
        try {
            this.writer.write(this.formatMessage(event.getTimestamp(), (String)event.getSource(), event.getCategory(), event.getMessage()) + this.lineSep);
            if (this.autoFlush) {
                this.writer.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected String formatMessage(Date timestamp, String source, Object category, String message) {
        return "\n" + DateConvert.isoFormat(timestamp) + " " + source + " " + category + ": " + message;
    }

    @Override
    public void streamStarted(LogEvent event) {
    }

    @Override
    public void streamStopped(LogEvent event) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent ignore) {
    }
}

