/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.commons.object.jndi;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import org.apache.oodt.commons.object.jndi.ObjectNameParser;

public class HTTPContext
implements Context {
    private Hashtable environment;
    private static final NameParser nameParser = new ObjectNameParser();

    public HTTPContext(Hashtable environment) {
        if (environment == null) {
            throw new IllegalArgumentException("Nonnull environment required; don't know why, but it is");
        }
        this.environment = (Hashtable)environment.clone();
    }

    @Override
    public Object lookup(String name) throws NamingException {
        this.checkName(name);
        try {
            return new URL(name);
        }
        catch (MalformedURLException ex) {
            throw new NamingException(ex.getMessage());
        }
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.checkName(name);
        throw new OperationNotSupportedException("Not possible");
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.checkName(name);
        throw new OperationNotSupportedException("Not possible");
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        this.rebind(name.toString(), obj);
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.checkName(name);
        throw new OperationNotSupportedException("Not possible");
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        this.checkName(newName);
        throw new OperationNotSupportedException("Not possible");
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        this.rename(oldName.toString(), newName.toString());
    }

    public NamingEnumeration list(String name) throws NamingException {
        if (name.length() > 0) {
            throw new NotContextException("Subcontexts not supported");
        }
        return new NamingEnumeration(){

            @Override
            public void close() {
            }

            @Override
            public boolean hasMore() {
                return false;
            }

            public Object next() {
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasMoreElements() {
                return this.hasMore();
            }

            @Override
            public Object nextElement() {
                return this.next();
            }
        };
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        if (name.length() > 0) {
            throw new NotContextException("Subcontexts not supported");
        }
        return new NamingEnumeration(){

            @Override
            public void close() {
            }

            @Override
            public boolean hasMore() {
                return false;
            }

            public Object next() {
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasMoreElements() {
                return this.hasMore();
            }

            @Override
            public Object nextElement() {
                return this.next();
            }
        };
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException("Not yet implemented");
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException("Subcontexts not supported");
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return nameParser;
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.toString());
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        Name result = this.composeName(new CompositeName(name), new CompositeName(prefix));
        return result.toString();
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        if (this.environment == null) {
            this.environment = new Hashtable();
        }
        return this.environment.put(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        if (this.environment == null) {
            return null;
        }
        return this.environment.remove(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.environment == null) {
            return new Hashtable();
        }
        return (Hashtable)this.environment.clone();
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return "";
    }

    @Override
    public void close() throws NamingException {
        this.environment = null;
    }

    protected void checkName(String name) throws InvalidNameException {
        if (name == null) {
            throw new IllegalArgumentException("Can't check a null name");
        }
        if (name.length() == 0) {
            throw new InvalidNameException("Name's length is zero");
        }
        if (name.startsWith("http:") || name.startsWith("https:")) {
            return;
        }
        throw new InvalidNameException("Not an HTTP name; try http://some.host/some-context/...");
    }
}

