/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.commons.object.jndi;

import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import org.apache.oodt.commons.object.jndi.HTTPContext;
import org.apache.oodt.commons.object.jndi.ObjectNameParser;
import org.apache.oodt.commons.object.jndi.RMIContext;
import org.apache.oodt.commons.util.Utility;

class ObjectContext
implements Context {
    private Hashtable environment;
    private static final NameParser nameParser = new ObjectNameParser();
    private List contexts = new ArrayList();
    private Properties aliases = new Properties();

    ObjectContext(Hashtable environment) {
        this.environment = environment != null ? (Hashtable)environment.clone() : new Hashtable();
        try {
            Class<?> clazz = Class.forName("org.apache.oodt.commons.object.jndi.CORBAContext");
            Constructor<?> ctor = clazz.getConstructor(Hashtable.class);
            Object corbaContext = ctor.newInstance(this.environment);
            this.contexts.add(corbaContext);
        }
        catch (Throwable clazz) {
            // empty catch block
        }
        String registryList = environment != null ? environment.get("rmiregistries") : null;
        if (registryList != null) {
            Iterator i = Utility.parseCommaList(registryList);
            while (i.hasNext()) {
                Hashtable rmiEnv = (Hashtable)this.environment.clone();
                URI uri = URI.create((String)i.next());
                rmiEnv.put("host", uri.getHost());
                rmiEnv.put("port", uri.getPort());
                this.contexts.add(new RMIContext(rmiEnv));
            }
        }
        Hashtable httpEnv = (Hashtable)this.environment.clone();
        this.contexts.add(new HTTPContext(httpEnv));
        String className = null;
        Iterator i = Utility.parseCommaList(System.getProperty("org.apache.oodt.commons.object.contexts", ""));
        while (i.hasNext()) {
            try {
                className = (String)i.next();
                Class<?> clazz = Class.forName(className);
                this.contexts.add(clazz.newInstance());
            }
            catch (ClassNotFoundException ex) {
                System.err.println("Ignoring not-found context class `" + className + "': " + ex.getMessage());
            }
            catch (InstantiationException ex) {
                System.err.println("Ignoring non-instantiable context class `" + className + "': " + ex.getMessage());
            }
            catch (IllegalAccessException ex) {
                System.err.println("Ignoring context class `" + className + "' with non-accessible no-args c'tor: " + ex.getMessage());
            }
        }
        this.installAliases();
        System.err.println("Object context ready; delegating to: " + this.contexts);
    }

    ObjectContext(List contexts) {
        this.contexts = contexts;
        this.installAliases();
    }

    @Override
    public Object lookup(String name) throws NamingException {
        if (name == null) {
            throw new IllegalArgumentException("Name required");
        }
        if (name.length() == 0) {
            return this;
        }
        String alias = this.aliases.getProperty(name);
        if (alias != null) {
            name = alias;
        }
        for (Object context : this.contexts) {
            Context c = (Context)context;
            try {
                return c.lookup(name);
            }
            catch (InvalidNameException invalidNameException) {
            }
            catch (NameNotFoundException nameNotFoundException) {
            }
            catch (NamingException namingException) {
            }
        }
        throw new NameNotFoundException(name + " not found in any managed subcontext");
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    @Override
    public synchronized void bind(String name, Object obj) throws NamingException {
        if (name == null) {
            throw new IllegalArgumentException("Name required");
        }
        if (name.length() == 0) {
            throw new InvalidNameException("Cannot bind object named after context");
        }
        if (this.aliases.containsKey(name)) {
            throw new NameAlreadyBoundException("Name \"" + name + "\" already bound as an aliased name");
        }
        NamingEnumeration e = this.list("");
        while (e.hasMore()) {
            NameClassPair nameClassPair = (NameClassPair)e.next();
            if (!name.equals(nameClassPair.getName())) continue;
            throw new NameAlreadyBoundException("Name \"" + name + "\" already bound by a managed subcontext");
        }
        this.doRebind(name, obj);
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    @Override
    public synchronized void rebind(String name, Object obj) throws NamingException {
        if (name == null) {
            throw new IllegalArgumentException("Name required");
        }
        if (name.length() == 0) {
            throw new InvalidNameException("Cannot rebind object named after context");
        }
        if (this.aliases.containsKey(name)) {
            this.aliases.remove(name);
        }
        this.doRebind(name, obj);
    }

    private void doRebind(String name, Object obj) throws NamingException {
        boolean bound = false;
        for (Object context : this.contexts) {
            Context c = (Context)context;
            try {
                c.rebind(name, obj);
                bound = true;
            }
            catch (NamingException namingException) {}
        }
        if (!bound) {
            throw new InvalidNameException("Name \"" + name + "\" not compatible with any managed subcontext");
        }
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        this.rebind(name.toString(), obj);
    }

    @Override
    public void unbind(String name) throws NamingException {
        if (name == null) {
            throw new IllegalArgumentException("Name required");
        }
        if (name.length() == 0) {
            throw new InvalidNameException("Cannot unbind object named after context");
        }
        if (this.aliases.containsKey(name)) {
            this.aliases.remove(name);
            return;
        }
        boolean unbound = false;
        for (Object context : this.contexts) {
            Context c = (Context)context;
            try {
                c.unbind(name);
                unbound = true;
            }
            catch (NamingException namingException) {}
        }
        if (!unbound) {
            throw new InvalidNameException("Name \"" + name + "\" not compatible with any managed subcontext");
        }
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        if (oldName == null || newName == null) {
            throw new IllegalArgumentException("Name required");
        }
        if (oldName.length() == 0 || newName.length() == 0) {
            throw new InvalidNameException("Cannot rename object named after context");
        }
        String oldValue = (String)this.aliases.remove(oldName);
        if (oldValue != null) {
            this.aliases.setProperty(newName, oldName);
            return;
        }
        boolean renamed = false;
        for (Object context : this.contexts) {
            Context c = (Context)context;
            try {
                c.rename(oldName, newName);
                renamed = true;
            }
            catch (NamingException namingException) {}
        }
        if (!renamed) {
            throw new InvalidNameException("Names not compatible with any managed subcontext");
        }
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        this.rename(oldName.toString(), newName.toString());
    }

    public NamingEnumeration list(final String name) throws NamingException {
        final Iterator eachContext = this.contexts.iterator();
        return new NamingEnumeration(){
            private NamingEnumeration enumeration;
            private boolean open;
            {
                this.enumeration = eachContext.hasNext() ? ((Context)eachContext.next()).list(name) : null;
                this.open = true;
            }

            public Object next() throws NamingException {
                if (!this.open) {
                    throw new NamingException("closed");
                }
                if (this.enumeration != null && this.enumeration.hasMore()) {
                    return this.enumeration.next();
                }
                if (eachContext.hasNext()) {
                    this.enumeration = ((Context)eachContext.next()).list(name);
                    if (this.enumeration.hasMore()) {
                        return this.enumeration.next();
                    }
                }
                throw new NoSuchElementException("No more objects in context");
            }

            @Override
            public Object nextElement() {
                Object rc = null;
                try {
                    rc = this.next();
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
                return rc;
            }

            @Override
            public boolean hasMore() throws NamingException {
                if (!this.open) {
                    return false;
                }
                if (this.enumeration == null) {
                    return false;
                }
                if (this.enumeration.hasMore()) {
                    return true;
                }
                if (eachContext.hasNext()) {
                    this.enumeration = ((Context)eachContext.next()).list(name);
                    return this.hasMore();
                }
                return false;
            }

            @Override
            public boolean hasMoreElements() {
                boolean h = false;
                try {
                    h = this.hasMore();
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
                return h;
            }

            @Override
            public void close() throws NamingException {
                this.open = false;
                if (this.enumeration != null) {
                    this.enumeration.close();
                }
            }
        };
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public NamingEnumeration listBindings(final String name) throws NamingException {
        final Iterator eachContext = this.contexts.iterator();
        return new NamingEnumeration(){
            private NamingEnumeration enumeration;
            private boolean open;
            {
                this.enumeration = eachContext.hasNext() ? ((Context)eachContext.next()).listBindings(name) : null;
                this.open = true;
            }

            public Object next() throws NamingException {
                if (!this.open) {
                    throw new NamingException("closed");
                }
                if (this.enumeration != null && this.enumeration.hasMore()) {
                    return this.enumeration.next();
                }
                if (eachContext.hasNext()) {
                    this.enumeration = ((Context)eachContext.next()).listBindings(name);
                    if (this.enumeration.hasMore()) {
                        return this.enumeration.next();
                    }
                }
                throw new NoSuchElementException("No more objects in context");
            }

            @Override
            public Object nextElement() {
                Object rc = null;
                try {
                    rc = this.next();
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
                return rc;
            }

            @Override
            public boolean hasMore() throws NamingException {
                if (!this.open) {
                    return false;
                }
                if (this.enumeration == null) {
                    return false;
                }
                if (this.enumeration.hasMore()) {
                    return true;
                }
                if (eachContext.hasNext()) {
                    this.enumeration = ((Context)eachContext.next()).listBindings(name);
                    return this.hasMore();
                }
                return false;
            }

            @Override
            public boolean hasMoreElements() {
                boolean h = false;
                try {
                    h = this.hasMore();
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
                return h;
            }

            @Override
            public void close() throws NamingException {
                this.open = false;
                if (this.enumeration != null) {
                    this.enumeration.close();
                }
            }
        };
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException("Subcontexts not supported by ObjectContext");
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException("Subcontexts not supported by ObjectContext");
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return nameParser;
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.toString());
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        Name result = this.composeName(new CompositeName(name), new CompositeName(prefix));
        return result.toString();
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        if (this.environment == null) {
            this.environment = new Hashtable();
        }
        return this.environment.put(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        if (this.environment == null) {
            return null;
        }
        return this.environment.remove(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.environment == null) {
            return new Hashtable();
        }
        return (Hashtable)this.environment.clone();
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return "";
    }

    @Override
    public void close() throws NamingException {
        this.environment = null;
    }

    private void installAliases() {
        String aliasFileName = System.getProperty("org.apache.oodt.commons.object.jndi.aliases", System.getProperty("aliases"));
        if (aliasFileName != null && aliasFileName.length() > 0) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(aliasFileName);
                this.aliases.load(in);
            }
            catch (IOException ex) {
                throw new IllegalStateException("Cannot handle I/O exception reading alias file " + aliasFileName + ": " + ex.getMessage());
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

