/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.commons.object.jndi;

import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.naming.Binding;
import javax.naming.CommunicationException;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import org.apache.oodt.commons.Service;
import org.apache.oodt.commons.object.jndi.ObjectNameParser;

public class RMIContext
implements Context {
    private Hashtable environment;
    private Registry registry;
    private static final NameParser nameParser = new ObjectNameParser();

    public RMIContext(String host, int port) {
        Hashtable<String, Object> environment = new Hashtable<String, Object>();
        environment.put("host", host);
        environment.put("port", port);
        this.initEnv(environment);
    }

    public RMIContext(Hashtable environment) {
        this.initEnv(environment);
    }

    private void initEnv(Hashtable environment) {
        if (environment == null) {
            throw new IllegalArgumentException("Nonnull environment required");
        }
        this.environment = (Hashtable)environment.clone();
    }

    @Override
    public Object lookup(String name) throws NamingException {
        this.checkName(name);
        name = this.toRMIName(name);
        if (name.length() == 0) {
            return new RMIContext(this.environment);
        }
        Registry registry = this.getRegistry();
        try {
            return registry.lookup(name);
        }
        catch (NotBoundException ex) {
            throw new NameNotFoundException(name + " not found in RMI registry " + registry);
        }
        catch (RemoteException ex) {
            throw new NamingException("Remote exception: " + ex.getMessage());
        }
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.checkName(name);
        Registry registry = this.getRegistry();
        try {
            registry.bind(this.toRMIName(name), (Remote)obj);
        }
        catch (AlreadyBoundException ex) {
            throw new NameAlreadyBoundException(name + " already bound in RMI registry " + registry);
        }
        catch (RemoteException ex) {
            throw new NamingException("Remote exception: " + ex.getMessage());
        }
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.checkName(name);
        try {
            Registry registry = this.getRegistry();
            registry.rebind(this.toRMIName(name), (Remote)obj);
        }
        catch (RemoteException ex) {
            ex.printStackTrace();
            throw new NamingException("Remote exception: " + ex.getMessage());
        }
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        this.rebind(name.toString(), obj);
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.checkName(name);
        Registry registry = this.getRegistry();
        try {
            registry.unbind(this.toRMIName(name));
        }
        catch (NotBoundException ex) {
            throw new NameNotFoundException(name + " not found in RMI registry " + registry);
        }
        catch (RemoteException ex) {
            throw new NamingException("Remote exception: " + ex.getMessage());
        }
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        this.checkName(newName);
        throw new OperationNotSupportedException("Not yet implemented");
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        this.rename(oldName.toString(), newName.toString());
    }

    public NamingEnumeration list(String name) throws NamingException {
        if (name.length() > 0) {
            throw new NotContextException("Subcontexts not supported");
        }
        final Iterator i = this.getCurrentBindings().iterator();
        return new NamingEnumeration(){

            @Override
            public void close() {
            }

            @Override
            public boolean hasMore() {
                return i.hasNext();
            }

            public Object next() throws NamingException {
                String n = "urn:eda:rmi:" + (String)i.next();
                Service server = (Service)RMIContext.this.lookup(n);
                try {
                    return new NameClassPair(n, server.getServerInterfaceName());
                }
                catch (RemoteException ex) {
                    throw new CommunicationException(ex.getMessage());
                }
            }

            @Override
            public boolean hasMoreElements() {
                return this.hasMore();
            }

            @Override
            public Object nextElement() {
                Object next = null;
                try {
                    next = this.next();
                }
                catch (RuntimeException ex) {
                    throw ex;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return next;
            }
        };
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        if (name.length() > 0) {
            throw new NotContextException("Subcontexts not supported");
        }
        final Iterator i = this.getCurrentBindings().iterator();
        return new NamingEnumeration(){

            @Override
            public void close() {
            }

            @Override
            public boolean hasMore() {
                return i.hasNext();
            }

            public Object next() throws NamingException {
                String n = "urn:eda:rmi:" + (String)i.next();
                return new Binding(n, RMIContext.this.lookup(n));
            }

            @Override
            public boolean hasMoreElements() {
                return this.hasMore();
            }

            @Override
            public Object nextElement() {
                Object next = null;
                try {
                    next = this.next();
                }
                catch (RuntimeException ex) {
                    throw ex;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return next;
            }
        };
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException("Not yet implemented");
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException("Subcontexts not supported");
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return nameParser;
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this.getNameParser(name.toString());
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        Name result = this.composeName(new CompositeName(name), new CompositeName(prefix));
        return result.toString();
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        Name result = (Name)prefix.clone();
        result.addAll(name);
        return result;
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        if (this.environment == null) {
            this.environment = new Hashtable();
        }
        return this.environment.put(propName, propVal);
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        if (this.environment == null) {
            return null;
        }
        return this.environment.remove(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.environment == null) {
            return new Hashtable();
        }
        return (Hashtable)this.environment.clone();
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return "";
    }

    @Override
    public void close() throws NamingException {
        this.environment = null;
    }

    private List getCurrentBindings() throws NamingException {
        List<String> names;
        try {
            Registry registry = this.getRegistry();
            names = Arrays.asList(registry.list());
        }
        catch (RemoteException ex) {
            names = Collections.EMPTY_LIST;
        }
        return names;
    }

    private String toRMIName(String name) {
        if (name == null) {
            return "";
        }
        if (name.startsWith("urn:eda:rmi:")) {
            return name.substring(12);
        }
        if (name.startsWith("rmi:")) {
            return name.substring(4);
        }
        return name;
    }

    private Registry getRegistry() throws NamingException {
        if (this.registry != null) {
            return this.registry;
        }
        try {
            String host = this.environment.containsKey("host") ? (String)this.environment.get("host") : "localhost";
            int port = this.environment.containsKey("port") ? (Integer)this.environment.get("port") : 1099;
            this.registry = LocateRegistry.getRegistry(host, port);
        }
        catch (RemoteException ex) {
            throw new NamingException("Remote exception locating registry: " + ex.getMessage());
        }
        return this.registry;
    }

    private void checkName(String name) throws InvalidNameException {
        if (name == null) {
            throw new IllegalArgumentException("Can't check a null name");
        }
        if (name.length() == 0) {
            throw new InvalidNameException("Name's length is zero");
        }
        if (!name.startsWith("urn:eda:rmi:")) {
            throw new InvalidNameException("Not an RMI name; try urn:eda:rmi:yadda-yadda");
        }
    }
}

