/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.commons.pagination;

import java.util.List;

public final class PaginationUtils {
    private PaginationUtils() throws InstantiationException {
        throw new InstantiationException("Don't construct utility classes!");
    }

    public static int hasRemainder(int divisor, int quotient) {
        if (divisor % quotient != 0) {
            return 1;
        }
        return 0;
    }

    public static int computeCurrentPage(int startIdx, int productsPerPage) {
        return (startIdx + 1) / productsPerPage + PaginationUtils.hasRemainder(startIdx + 1, productsPerPage);
    }

    public static int computeCurrentWindow(int currPage, int pagesPerPage) {
        return currPage / pagesPerPage + PaginationUtils.hasRemainder(currPage, pagesPerPage);
    }

    public static int computeMinPage(int pagesPerPage, int currWindow) {
        return pagesPerPage * (currWindow - 1) + 1;
    }

    public static int computeMaxPage(int minPage, int pagesPerPage, int lastIdx, int productsPerPage) {
        return Math.min(minPage + (pagesPerPage - 1), PaginationUtils.computeCurrentPage(lastIdx, productsPerPage));
    }

    public static int computeEndIdx(int currPage, int productsPerPage, int totalProducts) {
        return Math.min(currPage * productsPerPage - 1, totalProducts - 1);
    }

    public static int computePrevStartIdx(int minPage, int productsPerPage) {
        int prevPage = Math.max(minPage - 2, 1);
        return prevPage * productsPerPage;
    }

    public static int computeNextStartIdx(int maxPage, int productsPerPage) {
        return maxPage * productsPerPage;
    }

    public static List iterateFrom(int startIndex, List originalList, int pageSize) {
        int endIndex = startIndex + pageSize;
        int totalSize = originalList.size();
        if (endIndex > totalSize) {
            endIndex = totalSize;
        }
        return originalList.subList(startIndex, endIndex);
    }

    public static int getTotalPage(List originalList, int pageSize) {
        if (originalList == null || originalList.size() <= 0) {
            return 0;
        }
        int totalSize = originalList.size();
        return (totalSize - 1) / pageSize + 1;
    }

    public static int getTotalPage(int numTotal, int pageSize) {
        if (numTotal <= 0) {
            return 0;
        }
        return (numTotal - 1) / pageSize + 1;
    }
}

