/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.commons.util;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.oodt.commons.io.Base64DecodingInputStream;
import org.apache.oodt.commons.io.Base64EncodingOutputStream;

public class Base64 {
    public static byte[] encode(byte[] data) {
        return Base64.encode(data, 0, data.length);
    }

    public static byte[] encode(byte[] data, int offset, int length) {
        int i;
        if (data == null) {
            return null;
        }
        if (offset < 0 || offset > data.length) {
            throw new IndexOutOfBoundsException("Can't encode at index " + offset + " which is beyond array bounds 0.." + data.length);
        }
        if (length < 0) {
            throw new IllegalArgumentException("Can't encode a negative amount of data");
        }
        if (offset + length > data.length) {
            throw new IndexOutOfBoundsException("Can't encode beyond right edge of array");
        }
        byte[] dest = new byte[(length + 2) / 3 * 4];
        int j = 0;
        for (i = offset; i < offset + length - 2; i += 3) {
            dest[j++] = (byte)(data[i] >>> 2 & 0x3F);
            dest[j++] = (byte)(data[i + 1] >>> 4 & 0xF | data[i] << 4 & 0x3F);
            dest[j++] = (byte)(data[i + 2] >>> 6 & 3 | data[i + 1] << 2 & 0x3F);
            dest[j++] = (byte)(data[i + 2] & 0x3F);
        }
        if (i < offset + length) {
            dest[j++] = (byte)(data[i] >>> 2 & 0x3F);
            if (i < offset + length - 1) {
                dest[j++] = (byte)(data[i + 1] >>> 4 & 0xF | data[i] << 4 & 0x3F);
                dest[j++] = (byte)(data[i + 1] << 2 & 0x3F);
            } else {
                dest[j++] = (byte)(data[i] << 4 & 0x3F);
            }
        }
        for (i = 0; i < j; ++i) {
            dest[i] = dest[i] < 26 ? (int)(dest[i] + 65) : (dest[i] < 52 ? (int)(dest[i] + 97 - 26) : (dest[i] < 62 ? (int)(dest[i] + 48 - 52) : (dest[i] < 63 ? 43 : 47)));
        }
        while (i < dest.length) {
            dest[i] = 61;
            ++i;
        }
        return dest;
    }

    public static byte[] decode(byte[] data) {
        return Base64.decode(data, 0, data.length);
    }

    public static byte[] decode(byte[] data, int offset, int length) {
        int j;
        int i;
        int tail;
        if (data == null) {
            return null;
        }
        if (offset < 0 || offset >= data.length) {
            throw new IndexOutOfBoundsException("Can't decode at index " + offset + " which is beyond array bounds 0.." + (data.length - 1));
        }
        if (length < 0) {
            throw new IllegalArgumentException("Can't decode a negative amount of data");
        }
        if (offset + length > data.length) {
            throw new IndexOutOfBoundsException("Can't decode beyond right edge of array");
        }
        for (tail = offset + length - 1; tail >= offset && data[tail] == 61; --tail) {
        }
        byte[] dest = new byte[tail + offset + 1 - length / 4];
        for (i = offset; i < offset + length; ++i) {
            if (data[i] == 61) {
                data[i] = 0;
                continue;
            }
            if (data[i] == 47) {
                data[i] = 63;
                continue;
            }
            if (data[i] == 43) {
                data[i] = 62;
                continue;
            }
            if (data[i] >= 48 && data[i] <= 57) {
                data[i] = (byte)(data[i] - -4);
                continue;
            }
            if (data[i] >= 97 && data[i] <= 122) {
                data[i] = (byte)(data[i] - 71);
                continue;
            }
            if (data[i] < 65 || data[i] > 90) continue;
            data[i] = (byte)(data[i] - 65);
        }
        i = 0 + offset;
        for (j = 0; j < dest.length - 2; j += 3) {
            dest[j] = (byte)(data[i] << 2 & 0xFF | data[i + 1] >>> 4 & 3);
            dest[j + 1] = (byte)(data[i + 1] << 4 & 0xFF | data[i + 2] >>> 2 & 0xF);
            dest[j + 2] = (byte)(data[i + 2] << 6 & 0xFF | data[i + 3] & 0x3F);
            i += 4;
        }
        if (j < dest.length) {
            dest[j] = (byte)(data[i] << 2 & 0xFF | data[i + 1] >>> 4 & 3);
        }
        if (++j < dest.length) {
            dest[j] = (byte)(data[i + 1] << 4 & 0xFF | data[i + 2] >>> 2 & 0xF);
        }
        return dest;
    }

    private Base64() {
        throw new IllegalStateException(this.getClass().getName() + " should not be instantiated");
    }

    public static void main(String[] argv) throws IOException {
        int numRead;
        FilterOutputStream out;
        InputStream in;
        InputStream source;
        if (argv.length < 1 || argv.length > 2) {
            System.err.println("Usage: encode|decode [file]");
            System.exit(1);
        }
        boolean encode = true;
        if ("encode".equals(argv[0])) {
            encode = true;
        } else if ("decode".equals(argv[0])) {
            encode = false;
        } else {
            System.err.println("Specify either \"encode\" or \"decode\"");
            System.exit(1);
        }
        InputStream inputStream = source = argv.length == 2 ? new BufferedInputStream(new FileInputStream(argv[1])) : System.in;
        if (encode) {
            in = source;
            out = new Base64EncodingOutputStream(System.out);
        } else {
            in = new Base64DecodingInputStream(source);
            out = System.out;
        }
        byte[] buf = new byte[512];
        while ((numRead = in.read(buf)) != -1) {
            ((OutputStream)out).write(buf, 0, numRead);
        }
        in.close();
        ((OutputStream)out).close();
        System.exit(0);
    }
}

