/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.commons.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class CacheMap
implements Map {
    private static final int DEFAULT_CAPACITY = 5;
    private LinkedList cache = new LinkedList();
    private Map map = new ConcurrentHashMap();
    private int capacity;

    public CacheMap() {
        this(5);
    }

    public CacheMap(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Can't have a negative size " + capacity + " cache map");
        }
        this.capacity = capacity;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public CacheMap(Map map) {
        this.capacity = map.size();
        this.putAll(map);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public Object get(Object key) {
        this.advance(key);
        return this.map.get(key);
    }

    public Object put(Object key, Object value) {
        Object old = this.map.put(key, value);
        if (old != null) {
            this.advance(key);
            return old;
        }
        this.cache.addFirst(key);
        if (this.cache.size() > this.capacity) {
            this.map.remove(this.cache.removeLast());
        }
        return null;
    }

    public Object remove(Object key) {
        if (!this.map.containsKey(key)) {
            return null;
        }
        this.cache.remove(key);
        return this.map.remove(key);
    }

    public void putAll(Map t) {
        Iterator iterator = t.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry entry = o = iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.cache.clear();
        this.map.clear();
    }

    public Set keySet() {
        throw new UnsupportedOperationException("Not implemented for CacheMap");
    }

    public Collection values() {
        throw new UnsupportedOperationException("Not implemented for CacheMap");
    }

    public Set entrySet() {
        throw new UnsupportedOperationException("Not implemented for CacheMap");
    }

    @Override
    public boolean equals(Object rhs) {
        if (rhs == this) {
            return true;
        }
        if (rhs == null || !(rhs instanceof CacheMap)) {
            return false;
        }
        CacheMap obj = (CacheMap)rhs;
        return obj.cache.equals(this.cache);
    }

    @Override
    public int hashCode() {
        return this.cache.hashCode();
    }

    private void advance(Object key) {
        boolean present = this.cache.remove(key);
        if (!present) {
            return;
        }
        this.cache.addFirst(key);
    }
}

