/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.commons.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class DateConvert {
    private static final long MS_IN_MINUTE = 60000L;
    private static final long MS_IN_HOUR = 3600000L;
    private static final long MS_IN_DAY = 86400000L;
    private static final String ISO_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private static final String DOY_FORMAT = "yyyy-DDD'T'HH:mm:ss.SSS";
    private static final String TS_FORMAT = "yyyyMMddHHmmssSSS";
    private static final String DBMS_FORMAT = "dd-MMM-yyyy HH:mm:ss";
    private static final String YMD_FORMAT = "yyyy-MM-dd";
    public static final int INT = 24;
    public static final int BEGIN_INDEX = 23;
    public static final int ERROR_OFFSET = 24;
    public static final int ERROR_OFFSET1 = 25;

    public DateConvert() throws IllegalStateException {
        throw new IllegalStateException("Instantiation of this class is not allowed.");
    }

    public static String isoFormat(Date inputDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(ISO_FORMAT);
        String dateString = dateFormat.format(inputDate);
        TimeZone tz = dateFormat.getTimeZone();
        String tzName = tz.getDisplayName();
        if (tzName.equals("Greenwich Mean Time")) {
            dateString = dateString.concat("Z");
        } else {
            String minuteString;
            String hourString;
            long tzOffsetMS = tz.getRawOffset();
            long tzOffsetHH = tzOffsetMS / 3600000L;
            if (tz.inDaylightTime(inputDate)) {
                ++tzOffsetHH;
            }
            if ((hourString = String.valueOf(Math.abs(tzOffsetHH))).length() == 1) {
                hourString = "0" + hourString;
            }
            long tzOffsetMMMS = tzOffsetMS % 3600000L;
            long tzOffsetMM = 0L;
            if (tzOffsetMMMS != 0L) {
                tzOffsetMM = tzOffsetMMMS / 60000L;
            }
            if ((minuteString = String.valueOf(tzOffsetMM)).length() == 1) {
                minuteString = "0" + minuteString;
            }
            String sign = "+";
            if (String.valueOf(tzOffsetMS).contains("-")) {
                sign = "-";
            }
            dateString = dateString.concat(sign + hourString + ":" + minuteString);
        }
        return dateString;
    }

    public static Date isoParse(String inputString) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(ISO_FORMAT);
        dateFormat.setLenient(false);
        if (inputString == null || inputString.length() < 24) {
            throw new ParseException("An exception occurred because the input date/time string was null or under 24 characters in length.", inputString.length());
        }
        String offsetString = inputString.substring(23);
        if (offsetString.equals("Z")) {
            dateFormat.setTimeZone(TimeZone.getTimeZone("Greenwich Mean Time"));
        } else if (offsetString.startsWith("-") || offsetString.startsWith("+")) {
            SimpleDateFormat offsetFormat = new SimpleDateFormat();
            if (offsetString.length() == 3) {
                offsetFormat.applyPattern("HH");
            } else if (offsetString.length() == 6) {
                offsetFormat.applyPattern("HH:mm");
            } else {
                throw new ParseException("An exception occurred because the offset portion was not the valid length of 3 or 6 characters.", 25);
            }
            offsetFormat.setLenient(false);
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT" + offsetString));
        } else {
            throw new ParseException("An exception occurred because the offset portion of the input date/time string was not 'Z' or did not start with '+' or '-'.", 24);
        }
        return dateFormat.parse(inputString);
    }

    public static String doyFormat(Date inputDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DOY_FORMAT);
        return dateFormat.format(inputDate);
    }

    public static Date doyParse(String inputString) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DOY_FORMAT);
        dateFormat.setLenient(false);
        return dateFormat.parse(inputString);
    }

    public static String tsFormat(Date inputDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(TS_FORMAT);
        return dateFormat.format(inputDate);
    }

    public static Date tsParse(String inputString) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(TS_FORMAT);
        dateFormat.setLenient(false);
        return dateFormat.parse(inputString);
    }

    public static String dbmsFormat(Date inputDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DBMS_FORMAT);
        return dateFormat.format(inputDate);
    }

    public static Date dbmsParse(String inputString) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(DBMS_FORMAT);
        dateFormat.setLenient(false);
        return dateFormat.parse(inputString);
    }

    public static String ymdFormat(Date inputDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(YMD_FORMAT);
        return dateFormat.format(inputDate);
    }

    public static Date ymdParse(String inputString) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(YMD_FORMAT);
        dateFormat.setLenient(false);
        return dateFormat.parse(inputString);
    }

    public static long getMsecsInMinute() {
        return 60000L;
    }

    public static long getMsecsInHour() {
        return 3600000L;
    }

    public static long getMsecsInDay() {
        return 86400000L;
    }
}

