/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.commons.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class EnterpriseEntityResolver
implements EntityResolver {
    static Map entities = new HashMap();

    @Override
    public InputSource resolveEntity(String publicID, String systemID) throws SAXException, IOException {
        String filename = EnterpriseEntityResolver.computeFilename(publicID, systemID);
        if (filename == null) {
            return null;
        }
        InputStream in = this.getClass().getResourceAsStream("/" + filename);
        if (in != null) {
            return new InputSource(new BufferedReader(new InputStreamReader(in)));
        }
        File file = EnterpriseEntityResolver.findFile(EnterpriseEntityResolver.getEntityRefDirs(System.getProperty("entity.dirs", "")), filename);
        if (file != null) {
            try {
                return new InputSource(new BufferedReader(new FileReader(file)));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    static String computeFilename(String publicID, String systemID) {
        String name = (String)entities.get(publicID);
        if (name == null) {
            try {
                URL url = new URL(systemID);
                File file = new File(url.getFile());
                name = file.getName();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return name;
    }

    static List getEntityRefDirs(String spec) {
        ArrayList<String> dirs = new ArrayList<String>();
        StringTokenizer t = new StringTokenizer(spec, ",;|");
        while (t.hasMoreTokens()) {
            dirs.add(t.nextToken());
        }
        return dirs;
    }

    static File findFile(List dirs, String filename) {
        for (Object dir : dirs) {
            File potentialFile = new File((String)dir, filename);
            if (!potentialFile.isFile()) continue;
            return potentialFile;
        }
        return null;
    }

    static {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(false);
            factory.setValidating(true);
            SAXParser p = factory.newSAXParser();
            p.parse(new InputSource(EnterpriseEntityResolver.class.getResourceAsStream("entities.xml")), new DefaultHandler(){
                private StringBuffer token = new StringBuffer();
                private String pi;

                @Override
                public void characters(char[] ch, int start, int length) {
                    this.token.append(ch, start, length);
                }

                @Override
                public void endElement(String ns, String name, String qual) {
                    if ("pi".equals(qual)) {
                        this.pi = this.token.toString().trim();
                    } else if ("filename".equals(qual)) {
                        entities.put(this.pi, this.token.toString().trim());
                    }
                    this.token.delete(0, this.token.length());
                }
            });
        }
        catch (ParserConfigurationException ex) {
            throw new IllegalStateException("Unexpected ParserConfigurationException: " + ex.getMessage());
        }
        catch (SAXParseException ex) {
            System.err.println("Error parsing entities.xml at line " + ex.getLineNumber() + ", column " + ex.getColumnNumber() + "; ignoring entity lookup");
        }
        catch (SAXException ex) {
            System.err.println("Exception parsing entities.xml: " + ex.getMessage() + "; ignoring entity lookup");
        }
        catch (IOException ex) {
            System.err.println("I/O error reading entities.xml: " + ex.getMessage() + "; ignoring entity lookup");
        }
    }
}

