/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.commons.util;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JDBC_DB {
    private static Logger LOG = Logger.getLogger(JDBC_DB.class.getName());
    Properties serverProps;
    Connection connect;
    String sql_command;
    Statement stmt;
    ResultSet rs;
    ResultSetMetaData rs_meta;
    int affected;
    boolean keep_connect_open;
    private boolean autoCommitMode = false;

    public JDBC_DB(Properties sys_props) {
        this.serverProps = sys_props;
        this.keep_connect_open = true;
    }

    public JDBC_DB(Properties sys_props, Connection srv_connect) {
        this.serverProps = sys_props;
        this.connect = srv_connect;
        this.keep_connect_open = srv_connect != null;
    }

    public void setAutoCommitMode(boolean autoCommitMode) {
        this.autoCommitMode = autoCommitMode;
    }

    public void openConnection() throws SQLException {
        this.openConnection(this.serverProps.getProperty("org.apache.oodt.commons.util.JDBC_DB.user", "unknown"), this.serverProps.getProperty("org.apache.oodt.commons.util.JDBC_DB.password"), this.serverProps.getProperty("org.apache.oodt.commons.util.JDBC_DB.database"));
    }

    public void openConnection(String username, String password, String database) throws SQLException {
        if (this.stmt != null) {
            this.stmt.close();
        }
        if (this.rs != null) {
            this.rs.close();
        }
        if (this.keep_connect_open) {
            return;
        }
        if (this.connect != null) {
            this.connect.close();
        }
        this.rs_meta = null;
        this.connect = null;
        this.stmt = null;
        this.rs = null;
        Properties props = new Properties();
        props.put("user", username);
        if (password != null) {
            props.put("password", password);
        }
        String classname = this.serverProps.getProperty("org.apache.oodt.commons.util.JDBC_DB.driver", "oracle.jdbc.driver.OracleDriver");
        try {
            System.err.println("Attempting to load class " + classname);
            Class.forName(classname);
            System.err.println("Loaded " + classname);
        }
        catch (ClassNotFoundException e) {
            System.err.println("Can't load JDBC driver \"" + classname + "\": " + e.getMessage());
            LOG.log(Level.SEVERE, e.getMessage());
        }
        String url = this.serverProps.getProperty("org.apache.oodt.commons.util.JDBC_DB.url", "jdbc:oracle:@");
        try {
            if (database != null) {
                System.err.println("Connecting to url+database combo: " + url + database);
                this.connect = DriverManager.getConnection(url + database, props);
            } else {
                System.err.println("Connecting to full url: " + url);
                this.connect = DriverManager.getConnection(url, props);
            }
        }
        catch (SQLException e) {
            System.err.println("SQL Exception during connection creation: " + e.getMessage());
            LOG.log(Level.SEVERE, e.getMessage());
            while (e != null) {
                System.err.println(e.getMessage());
                e = e.getNextException();
            }
        }
        this.connect.setAutoCommit(this.autoCommitMode);
    }

    public void closeConnection() {
        try {
            if (this.rs != null) {
                this.rs.close();
            }
            if (this.stmt != null) {
                this.stmt.close();
            }
            if (this.keep_connect_open) {
                return;
            }
            if (this.connect != null) {
                this.connect.close();
            }
            this.connect = null;
            this.rs = null;
            this.stmt = null;
        }
        catch (SQLException e) {
            System.err.println("Ignoring database close connection exception");
        }
    }

    public void executeSQLCommand(String cmd) throws SQLException {
        this.sql_command = cmd;
        if (this.stmt != null) {
            this.stmt.close();
        }
        if (this.connect == null) {
            this.openConnection();
        }
        if (this.connect == null) {
            this.keep_connect_open = false;
            this.openConnection();
        }
        if (this.connect == null) {
            throw new IllegalStateException("Connection is null!!!");
        }
        if (this.connect.isClosed()) {
            this.connect = null;
            this.keep_connect_open = false;
            this.openConnection();
        }
        if (this.connect == null) {
            throw new IllegalStateException("Connection is still null!!!");
        }
        if (this.connect.isClosed()) {
            throw new IllegalStateException("Connection got closed!");
        }
        this.stmt = this.connect.createStatement();
        this.affected = this.stmt.executeUpdate(this.sql_command);
    }

    public ResultSet executeQuery(String cmd) throws SQLException {
        this.sql_command = cmd;
        if (this.stmt != null) {
            this.stmt.close();
        }
        if (this.connect == null) {
            this.openConnection();
        }
        if (this.connect == null) {
            this.keep_connect_open = false;
            this.openConnection();
        }
        if (this.connect == null) {
            throw new IllegalStateException("Connection is null!!!");
        }
        if (this.connect.isClosed()) {
            this.connect = null;
            this.keep_connect_open = false;
            this.openConnection();
        }
        if (this.connect == null) {
            throw new IllegalStateException("Connection is still null!!!");
        }
        if (this.connect.isClosed()) {
            throw new IllegalStateException("Connection got closed!");
        }
        this.stmt = this.connect.createStatement();
        if (this.rs != null) {
            this.rs.close();
        }
        this.rs = this.stmt.executeQuery(this.sql_command);
        return this.rs;
    }

    public int getCount(String cmd) throws SQLException {
        this.sql_command = cmd;
        if (this.stmt != null) {
            this.stmt.close();
        }
        this.stmt = this.connect.createStatement();
        if (this.rs != null) {
            this.rs.close();
        }
        this.rs = this.stmt.executeQuery(this.sql_command);
        int count = 0;
        while (this.rs.next()) {
            count = this.rs.getInt(1);
        }
        this.stmt.close();
        this.rs.close();
        return count;
    }

    public void commit() throws SQLException {
        this.connect.commit();
    }

    public void rollback() {
        try {
            if (this.connect != null) {
                this.connect.rollback();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.connect != null && !this.keep_connect_open) {
                this.connect.close();
            }
            if (this.rs != null) {
                this.rs.close();
            }
            if (this.stmt != null) {
                this.stmt.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public String toDateStr(Date inDate) {
        SimpleDateFormat fmt = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        return fmt.format(inDate);
    }

    public Connection getConnection() throws SQLException {
        if (this.connect == null) {
            this.openConnection();
        }
        if (this.connect == null) {
            this.keep_connect_open = false;
            this.openConnection();
        }
        if (this.connect == null) {
            throw new IllegalStateException("getConnection can't get a connection pointer");
        }
        return this.connect;
    }
}

