/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.commons.util;

import java.beans.PropertyChangeEvent;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.oodt.commons.io.Log;
import org.apache.oodt.commons.io.LogFilter;
import org.apache.oodt.commons.io.LogListener;
import org.apache.oodt.commons.util.LogEventMultiplexer;
import org.apache.oodt.commons.util.MemoryLogger;
import org.apache.oodt.commons.util.PropertyMgr;

public class LogInit {
    public static final MemoryLogger MEMORY_LOGGER = new MemoryLogger();

    public LogInit() throws IllegalStateException {
        throw new IllegalStateException("LogInit(): Instantiation of this class is not allowed.");
    }

    public static void init(Properties props, String source) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        LogEventMultiplexer mux = new LogEventMultiplexer();
        mux.addListener(MEMORY_LOGGER);
        String userSpecifiedListener = props.getProperty("org.apache.oodt.commons.util.LogInit.listener");
        if (userSpecifiedListener != null) {
            mux.addListener((LogListener)Class.forName(userSpecifiedListener).newInstance());
        }
        String categoryList = props.getProperty("org.apache.oodt.commons.util.LogInit.categories", "");
        StringTokenizer tokens = new StringTokenizer(categoryList);
        Object[] categories = new Object[tokens.countTokens()];
        for (int i = 0; i < categories.length; ++i) {
            categories[i] = tokens.nextToken();
        }
        EnterpriseLogFilter filter = new EnterpriseLogFilter(mux, true, categories);
        Log.addLogListener(filter);
        Log.setDefaultSource(source);
    }

    public static class EnterpriseLogFilter
    extends LogFilter {
        public EnterpriseLogFilter(LogListener listener, boolean passThrough, Object[] categories) {
            super(listener, passThrough, categories);
            PropertyMgr.addPropertyChangeListener(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            String key = event.getPropertyName();
            if ("org.apache.oodt.commons.util.LogInit.categories".equals(key)) {
                String categoriesList = (String)event.getNewValue();
                this.categories.clear();
                if (categoriesList != null) {
                    StringTokenizer tokens = new StringTokenizer(categoriesList);
                    this.categories.put(tokens.nextToken(), DUMMY);
                }
                Log.get("Info").println("Enterprise log now filtering out " + (categoriesList == null ? "all categories of messages" : "messages in categories " + categoriesList));
            }
        }
    }
}

