/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.commons.util;

import java.beans.PropertyChangeEvent;
import java.util.LinkedList;
import java.util.List;
import org.apache.oodt.commons.io.LogEvent;
import org.apache.oodt.commons.io.LogListener;
import org.apache.oodt.commons.util.DateConvert;

public class MemoryLogger
implements LogListener {
    private LinkedList messages = new LinkedList();
    private int size;
    public static final int DEF_SIZE = 32;

    public MemoryLogger() {
        this(Integer.getInteger("org.apache.oodt.commons.util.MemoryLogger.size", 32));
    }

    public MemoryLogger(int size) {
        this.size = size;
    }

    public List getMessages() {
        return (List)this.messages.clone();
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Log cache size can't be negative");
        }
        int delta = this.size - size;
        this.size = size;
        if (delta <= 0) {
            return;
        }
        if (this.messages.size() < size) {
            return;
        }
        while (delta-- > 0) {
            this.messages.removeFirst();
        }
    }

    @Override
    public void streamStarted(LogEvent ignore) {
    }

    @Override
    public void streamStopped(LogEvent ignore) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent ignore) {
    }

    @Override
    public void messageLogged(LogEvent event) {
        this.messages.add(DateConvert.isoFormat(event.getTimestamp()) + " " + event.getSource() + " " + event.getCategory() + ": " + event.getMessage());
        if (this.messages.size() > this.size) {
            this.messages.removeFirst();
        }
    }
}

