/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.commons.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;

public class Utility {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadProperties(Properties props, Class clazz, String resourceName) {
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(clazz.getResourceAsStream(resourceName));
            props.load(in);
        }
        catch (IOException ex) {
            System.err.println("I/O exception while loading \"" + resourceName + "\": " + ex.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static Iterator parseCommaList(String list) {
        if (list == null) {
            return new Iterator(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                public Object next() {
                    throw new NoSuchElementException("There weren't ANY elements in this iterator, ever");
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Can't remove elements from this iterator");
                }
            };
        }
        HashSet<String> set = new HashSet<String>();
        StringTokenizer tokens = new StringTokenizer(list, ",");
        while (tokens.hasMoreTokens()) {
            set.add(tokens.nextToken().trim());
        }
        return set.iterator();
    }

    public static void redirect(final InputStream in, final OutputStream out) {
        new Thread(){

            @Override
            public void run() {
                try {
                    byte[] buf = new byte[1024];
                    while (true) {
                        int numRead;
                        if ((numRead = in.read(buf)) == -1) {
                            in.close();
                            break;
                        }
                        out.write(buf, 0, numRead);
                    }
                }
                catch (IOException ex) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }.start();
    }

    public static void logMemoryStats(String msg) {
        Runtime rt = Runtime.getRuntime();
        System.err.println(msg + ": total=" + rt.totalMemory() / 1024L + "KB, free=" + rt.freeMemory() / 1024L + "KB");
    }

    public static boolean isNumeric(String s) {
        try {
            Double.parseDouble(s);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    public static boolean delete(File file) {
        File[] entries;
        if (file.isDirectory() && (entries = file.listFiles()) != null) {
            for (File entry : entries) {
                if (Utility.delete(entry)) continue;
                return false;
            }
        }
        return file.delete();
    }

    public static String escapeSingleQuote(String inputString) {
        int index = inputString.indexOf(39);
        if (index == -1) {
            return inputString;
        }
        String outputString = inputString;
        while (index != -1) {
            if (index == outputString.length() - 1 || outputString.charAt(index + 1) != '\'') {
                outputString = outputString.substring(0, index) + "'" + outputString.substring(index);
            }
            if (index + 2 <= outputString.length() - 1) {
                index = outputString.indexOf(39, index + 2);
                continue;
            }
            index = -1;
        }
        return outputString;
    }
}

