/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.commons.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.oodt.commons.util.DOMParser;
import org.apache.oodt.commons.util.EnterpriseEntityResolver;
import org.apache.oodt.commons.util.SAXParser;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XML {
    private static Logger LOG = Logger.getLogger(XML.class.getName());
    public static final EntityResolver ENTERPRISE_ENTITY_RESOLVER = new EnterpriseEntityResolver();
    public static final Document EMPTY_DOCUMENT = XML.createDocument();
    private static int LAST_PRINTABLE = 126;

    private static DocumentBuilder getStandardDocumentBuilder() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setCoalescing(false);
            factory.setExpandEntityReferences(false);
            factory.setIgnoringComments(false);
            factory.setIgnoringElementContentWhitespace(true);
            factory.setNamespaceAware(true);
            factory.setValidating(true);
            return factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new IllegalStateException("Unexpected ParserConfigurationException: " + ex.getMessage());
        }
    }

    public static DOMImplementation getDOMImplementation() {
        return XML.getStandardDocumentBuilder().getDOMImplementation();
    }

    public static Document createDocument() {
        return XML.getStandardDocumentBuilder().newDocument();
    }

    public static DOMParser createDOMParser() {
        DocumentBuilder builder = XML.getStandardDocumentBuilder();
        builder.setEntityResolver(ENTERPRISE_ENTITY_RESOLVER);
        builder.setErrorHandler(new ErrorHandler(){

            @Override
            public void error(SAXParseException ex) {
                System.err.println("Parse error: " + ex.getMessage());
                ex.printStackTrace();
            }

            @Override
            public void warning(SAXParseException ex) {
                System.err.println("Parse warning: " + ex.getMessage());
            }

            @Override
            public void fatalError(SAXParseException ex) {
                System.err.println("Fatal parse error: " + ex.getMessage());
                ex.printStackTrace();
            }
        });
        return new DOMParser(builder);
    }

    public static SAXParser createSAXParser() {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(false);
            factory.setValidating(false);
            javax.xml.parsers.SAXParser saxParser = factory.newSAXParser();
            saxParser.getXMLReader().setEntityResolver(ENTERPRISE_ENTITY_RESOLVER);
            saxParser.getXMLReader().setErrorHandler(new ErrorHandler(){

                @Override
                public void error(SAXParseException ex) {
                    System.err.println("Parse error: " + ex.getMessage());
                }

                @Override
                public void warning(SAXParseException ex) {
                    System.err.println("Parse warning: " + ex.getMessage());
                }

                @Override
                public void fatalError(SAXParseException ex) {
                    System.err.println("Fatal parse error: " + ex.getMessage());
                }
            });
            return new SAXParser(saxParser);
        }
        catch (ParserConfigurationException ex) {
            throw new IllegalStateException("Unexpected ParserConfigurationException: " + ex.getMessage());
        }
        catch (SAXException ex) {
            throw new IllegalStateException("Unexpected SAXException: " + ex.getMessage());
        }
    }

    public static String serialize(Document doc, boolean omitXMLDeclaration) {
        StringWriter writer = new StringWriter();
        XML.serialize(doc, writer, omitXMLDeclaration);
        return writer.getBuffer().toString();
    }

    public static String serialize(Document doc) {
        return XML.serialize(doc, false);
    }

    public static void serialize(Document doc, Writer writer, boolean omitXMLDeclaration) {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            if (doc.getDoctype().getPublicId() != null) {
                transformer.setOutputProperty("doctype-public", doc.getDoctype().getPublicId());
            }
            if (doc.getDoctype().getSystemId() != null) {
                transformer.setOutputProperty("doctype-system", doc.getDoctype().getSystemId());
            }
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(writer);
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException ex) {
            throw new IllegalStateException("Unexpected TransformerConfigurationException: " + ex.getMessage());
        }
        catch (TransformerException ex) {
            throw new IllegalStateException("Unexpected TransformerException: " + ex.getMessage());
        }
    }

    public static void serialize(Document doc, Writer writer) {
        XML.serialize(doc, writer, false);
    }

    public static Document parse(InputSource inputSource) throws SAXException, IOException {
        DOMParser parser = XML.createDOMParser();
        parser.parse(inputSource);
        return parser.getDocument();
    }

    public static Document parse(String string) throws SAXException {
        Document doc;
        try {
            DOMParser parser = XML.createDOMParser();
            StringReader reader = new StringReader(string);
            InputSource inputSource = new InputSource(reader);
            doc = XML.parse(inputSource);
            reader.close();
        }
        catch (IOException cantHappen) {
            cantHappen.printStackTrace();
            throw new RuntimeException("I/O exception " + cantHappen.getClass().getName() + " can NOT have happened, yet it did!  Message: " + cantHappen.getMessage());
        }
        return doc;
    }

    public static Document parse(Reader reader) throws SAXException, IOException {
        return XML.parse(new InputSource(reader));
    }

    public static Document parse(InputStream inputStream) throws SAXException, IOException {
        return XML.parse(new InputStreamReader(inputStream));
    }

    public static void add(Node node, String name, Collection values) throws DOMException {
        for (Object value : values) {
            XML.add(node, name, value);
        }
    }

    public static void addNonNull(Node node, String name, String text) throws DOMException {
        if (text == null) {
            return;
        }
        XML.add(node, name, text);
    }

    public static void add(Node node, String name, String text) throws DOMException {
        if (name == null) {
            return;
        }
        if (node == null) {
            throw new IllegalArgumentException("Can't add to a null node");
        }
        Document doc = node.getOwnerDocument();
        Element element = doc.createElement(name);
        if (text != null) {
            element.appendChild(doc.createTextNode(text));
        }
        node.appendChild(element);
    }

    public static void add(Node node, String name, Object object) throws DOMException {
        XML.add(node, name, object == null ? null : object.toString());
    }

    public static String unwrappedText(Node node) {
        if (node == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        StringBuilder wrapped = new StringBuilder(XML.text1(node, buffer));
        boolean newline = false;
        for (int i = 0; i < wrapped.length(); ++i) {
            if (!newline) {
                if (wrapped.charAt(i) != '\n') continue;
                newline = true;
                wrapped.setCharAt(i, ' ');
                continue;
            }
            if (Character.isWhitespace(wrapped.charAt(i))) {
                wrapped.deleteCharAt(i);
                --i;
                continue;
            }
            newline = false;
        }
        return wrapped.toString().trim();
    }

    public static String text(Node node) {
        StringBuffer buffer = new StringBuffer();
        return XML.text1(node, buffer);
    }

    public static void dump(PrintWriter writer, Node node) {
        XML.dump(writer, node, 0);
    }

    public static void removeComments(Node node) {
        ArrayList commentNodes = new ArrayList();
        XML.findCommentNodes(commentNodes, node);
        for (Object commentNode1 : commentNodes) {
            Node commentNode = (Node)commentNode1;
            commentNode.getParentNode().removeChild(commentNode);
        }
    }

    public static String escape(String source) {
        StringBuffer result = new StringBuffer(source.length());
        for (int i = 0; i < source.length(); ++i) {
            char ch = source.charAt(i);
            if (ch < ' ' && ch != '\t' && ch != '\n' && ch != '\r' || ch > LAST_PRINTABLE || ch == '\u00f7') {
                result.append("&#").append(Integer.toString(ch)).append(';');
                continue;
            }
            String charRef = XML.getEntityRef(ch);
            if (charRef == null) {
                result.append(ch);
                continue;
            }
            result.append('&').append(charRef).append(';');
        }
        return result.toString();
    }

    private static void findCommentNodes(List list, Node node) {
        if (node.getNodeType() == 8) {
            list.add(node);
        } else {
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                XML.findCommentNodes(list, children.item(i));
            }
        }
    }

    private static String getEntityRef(char ch) {
        switch (ch) {
            case '<': {
                return "lt";
            }
            case '>': {
                return "gt";
            }
            case '\"': {
                return "quot";
            }
            case '\'': {
                return "apos";
            }
            case '&': {
                return "amp";
            }
        }
        return null;
    }

    private static String text1(Node node, StringBuffer buffer) {
        for (Node ch = node.getFirstChild(); ch != null; ch = ch.getNextSibling()) {
            if (ch.getNodeType() == 1 || ch.getNodeType() == 5) {
                buffer.append(XML.text(ch));
                continue;
            }
            if (ch.getNodeType() != 3) continue;
            buffer.append(ch.getNodeValue());
        }
        return buffer.toString();
    }

    private static void dump(PrintWriter writer, Node node, int indentAmt) {
        for (int i = 0; i < indentAmt; ++i) {
            writer.print(' ');
        }
        writer.println(XML.typeOf(node) + "(" + node.getNodeName() + ", " + node.getNodeValue() + ")");
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            XML.dump(writer, children.item(i), indentAmt + 2);
        }
    }

    private static String typeOf(Node node) {
        switch (node.getNodeType()) {
            case 2: {
                return "Attribute";
            }
            case 4: {
                return "CDATA-Section";
            }
            case 8: {
                return "Comment";
            }
            case 11: {
                return "Document-Fragment";
            }
            case 9: {
                return "Document";
            }
            case 10: {
                return "Document-Type";
            }
            case 1: {
                return "Element";
            }
            case 6: {
                return "Entity";
            }
            case 5: {
                return "Entity-Ref";
            }
            case 12: {
                return "Notation";
            }
            case 7: {
                return "Proc-Instr";
            }
            case 3: {
                return "Text";
            }
        }
        return "Unknown!";
    }
}

