/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.commons.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.oodt.commons.util.Base64;
import org.apache.oodt.commons.util.DOMParser;
import org.apache.oodt.commons.util.XML;
import org.apache.oodt.commons.util.XMLRPCFault;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLRPC {
    private static DateFormat ISO8601_FORMAT = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");

    public static byte[] createMethodCall(String name, Collection params) throws DOMException {
        Document doc = XML.createDocument();
        Element methodCallElement = doc.createElement("methodCall");
        doc.appendChild(methodCallElement);
        XML.add((Node)methodCallElement, "methodName", name);
        if (params != null && !params.isEmpty()) {
            Element paramsElement = doc.createElement("params");
            methodCallElement.appendChild(paramsElement);
            for (Object param : params) {
                paramsElement.appendChild(XMLRPC.createValueElement(doc, param));
            }
        }
        return XML.serialize(doc).getBytes();
    }

    private static Element createValueElement(Document doc, Object value) throws DOMException {
        if (value == null) {
            throw new IllegalArgumentException("Nulls not supported in XML-RPC");
        }
        Element valueElement = doc.createElement("value");
        if (value instanceof Integer || value instanceof Short) {
            XML.add((Node)valueElement, "int", value.toString());
        } else if (value instanceof Boolean) {
            XML.add((Node)valueElement, "boolean", (Boolean)value != false ? "1" : "0");
        } else if (value instanceof String) {
            Element stringElement = doc.createElement("string");
            valueElement.appendChild(stringElement);
            stringElement.appendChild(doc.createCDATASection(value.toString()));
        } else if (value instanceof Float || value instanceof Double) {
            XML.add((Node)valueElement, "double", value.toString());
        } else if (value instanceof Date) {
            XML.add((Node)valueElement, "dateTime.iso8601", ISO8601_FORMAT.format((Date)value));
        } else if (value instanceof byte[]) {
            Element base64Element = doc.createElement("base64");
            valueElement.appendChild(base64Element);
            base64Element.appendChild(doc.createCDATASection(new String(Base64.encode((byte[])value))));
        } else if (value instanceof Map) {
            Element structElement = doc.createElement("struct");
            valueElement.appendChild(structElement);
            Map map = (Map)value;
            for (Map.Entry o : map.entrySet()) {
                Element memberElement = doc.createElement("member");
                valueElement.appendChild(memberElement);
                Map.Entry entry = o;
                if (!(entry.getKey() instanceof String)) {
                    throw new IllegalArgumentException("Keys in maps for XML-RPC structs must be Strings");
                }
                XML.add((Node)memberElement, "name", entry.getKey().toString());
                memberElement.appendChild(XMLRPC.createValueElement(doc, entry.getValue()));
            }
        } else if (value instanceof Collection) {
            Element arrayElement = doc.createElement("array");
            valueElement.appendChild(arrayElement);
            Element dataElement = doc.createElement("data");
            arrayElement.appendChild(dataElement);
            Collection collection = (Collection)value;
            for (Object aCollection : collection) {
                dataElement.appendChild(XMLRPC.createValueElement(doc, aCollection));
            }
        } else {
            throw new IllegalArgumentException(value.getClass().getName() + " not supported in XML-RPC");
        }
        return valueElement;
    }

    public static Object parseResponse(byte[] response) throws XMLRPCFault {
        try {
            DOMParser parser = XML.createDOMParser();
            parser.setFeature("http://xml.org/sax/features/validation", false);
            parser.parse(new InputSource(new ByteArrayInputStream(response)));
            Document doc = parser.getDocument();
            doc.normalize();
            XML.removeComments(doc);
            Element methodResponseElement = doc.getDocumentElement();
            if (!"methodResponse".equals(methodResponseElement.getNodeName())) {
                throw new SAXException("Not a <methodResponse> document");
            }
            Node child = methodResponseElement.getFirstChild();
            if ("params".equals(child.getNodeName())) {
                return XMLRPC.parseValue(child.getFirstChild().getFirstChild());
            }
            if ("fault".equals(child.getNodeName())) {
                try {
                    Map map = (Map)XMLRPC.parseValue(child.getFirstChild());
                    throw new XMLRPCFault((Integer)map.get("faultCode"), (String)map.get("faultString"));
                }
                catch (ClassCastException ex) {
                    throw new SAXException("XML-RPC <fault> invalid");
                }
            }
            throw new SAXException("XML-RPC response does not contain <params> or <fault>");
        }
        catch (SAXException ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
        catch (IOException ex) {
            throw new RuntimeException("Unexpected I/O exception that shouldn't happen, but did: " + ex.getMessage());
        }
    }

    private static Object parseValue(Node node) {
        String n = node.getNodeName();
        if (!"value".equals(n)) {
            throw new IllegalArgumentException("Expecting a <value>, not a <" + n + ">");
        }
        Node t = node.getFirstChild();
        n = t.getNodeName();
        if (t.getNodeType() == 3 || t.getNodeType() == 4) {
            return t.getNodeValue();
        }
        String txt = XML.unwrappedText(t);
        if ("i4".equals(n) || "int".equals(n)) {
            return Integer.valueOf(txt);
        }
        if ("boolean".equals(n)) {
            if ("1".equals(txt)) {
                return true;
            }
            if ("0".equals(txt)) {
                return false;
            }
            throw new IllegalArgumentException(n + " does not contain a 0 or 1");
        }
        if ("string".equals(n)) {
            return txt;
        }
        if ("double".equals(n)) {
            return new Double(txt);
        }
        if ("dateTime.iso8601".equals(n)) {
            try {
                return ISO8601_FORMAT.parse(txt);
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException(n + " does not contain an ISO8601 format date/time");
            }
        }
        if ("base64".equals(n)) {
            return Base64.decode(txt.getBytes());
        }
        if ("struct".equals(n)) {
            ConcurrentHashMap<String, Object> m = new ConcurrentHashMap<String, Object>();
            NodeList memberNodes = t.getChildNodes();
            for (int i = 0; i < memberNodes.getLength(); ++i) {
                Node memberNode = memberNodes.item(i);
                if (!"member".equals(memberNode.getNodeName())) {
                    throw new IllegalArgumentException(n + " contains <" + memberNode.getNodeName() + ">, not <member>");
                }
                Node nameNode = memberNode.getFirstChild();
                if (nameNode == null || !"name".equals(nameNode.getNodeName())) {
                    throw new IllegalArgumentException("<member> missing <name> element");
                }
                Node valueNode = nameNode.getNextSibling();
                if (valueNode == null || !"value".equals(valueNode.getNodeName())) {
                    throw new IllegalArgumentException("<member> missing <value> element");
                }
                m.put(XML.unwrappedText(nameNode), XMLRPC.parseValue(valueNode));
            }
            return m;
        }
        if ("array".equals(n)) {
            Node dataNode = t.getFirstChild();
            if (dataNode == null || !"data".equals(dataNode.getNodeName())) {
                throw new IllegalArgumentException("<array> missing <data> element");
            }
            NodeList children = dataNode.getChildNodes();
            ArrayList<Object> x = new ArrayList<Object>(children.getLength());
            for (int i = 0; i < children.getLength(); ++i) {
                x.add(XMLRPC.parseValue(children.item(i)));
            }
            return x;
        }
        throw new IllegalArgumentException("Illegal type " + n + " in <value>");
    }

    private XMLRPC() {
        throw new IllegalStateException("Do not construct XMLRPC objects");
    }
}

