/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.commons.xml;

import org.apache.oodt.commons.exceptions.CommonsException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DOMUtil {
    public static Element getFirstElement(Element element, String name) throws CommonsException {
        NodeList n1 = element.getElementsByTagName(name);
        if (n1.getLength() < 1) {
            throw new CommonsException("Element: " + element + " does not contain: " + name);
        }
        return (Element)n1.item(0);
    }

    public static String getSimpleElementText(Element node, String name) throws CommonsException {
        Element namedElement = DOMUtil.getFirstElement(node, name);
        return DOMUtil.getSimpleElementText(namedElement);
    }

    public static String getSimpleElementText(Element node) {
        StringBuilder sb = new StringBuilder();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Text)) continue;
            sb.append(child.getNodeValue());
        }
        return sb.toString();
    }
}

