/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oodt.commons.xml;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.oodt.commons.xml.DOMUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class XMLUtils {
    private static final Logger LOG = Logger.getLogger(XMLUtils.class.getName());

    public static void writeXmlFile(Document doc, String filename) {
        StreamResult result = new StreamResult(filename);
        XMLUtils.transform(doc, result);
    }

    public static void writeXmlToStream(Document doc, OutputStream stream) {
        StreamResult result = new StreamResult(stream);
        XMLUtils.transform(doc, result);
    }

    private static void transform(Document doc, Result result) {
        try {
            DOMSource source = new DOMSource(doc);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.setOutputProperty("indent", "yes");
            xformer.transform(source, result);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, e.getMessage());
        }
    }

    public static List readMany(Element root, String elt) {
        return XMLUtils.readMany(root, elt, "UTF-8");
    }

    public static List readMany(Element root, String elt, String encoding) {
        NodeList valueNodes = root.getElementsByTagName(elt);
        Vector<String> values = new Vector<String>();
        for (int i = 0; i < valueNodes.getLength(); ++i) {
            Element valElem = (Element)valueNodes.item(i);
            try {
                String value = URLDecoder.decode(DOMUtil.getSimpleElementText(valElem), encoding);
                values.add(value);
                continue;
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, e.getMessage());
                LOG.log(Level.WARNING, "Error decoding tag: [" + elt + "]: val: [" + DOMUtil.getSimpleElementText(valElem) + "] from metadata. Message: " + e.getMessage());
            }
        }
        return values;
    }

    public static String read(Element root, String elt) {
        return XMLUtils.read(root, elt, "UTF-8");
    }

    public static String read(Element root, String elt, String encoding) {
        String value = null;
        try {
            value = URLDecoder.decode(DOMUtil.getSimpleElementText(root, elt), encoding);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Error decoding " + elt + "from metadata. Message: " + e.getMessage());
        }
        return value;
    }

    public static Element getFirstElement(String name, Element root) {
        NodeList list = root.getElementsByTagName(name);
        if (list.getLength() > 0) {
            return (Element)list.item(0);
        }
        return null;
    }

    public static String getSimpleElementText(Element node, boolean trim) {
        if (node.getChildNodes().item(0) instanceof Text) {
            String elemTxt = trim ? node.getChildNodes().item(0).getNodeValue().trim() : node.getChildNodes().item(0).getNodeValue();
            return elemTxt;
        }
        return null;
    }

    public static String getSimpleElementText(Element node) {
        return XMLUtils.getSimpleElementText(node, false);
    }

    public static String getElementText(String elemName, Element root, boolean trim) {
        Element elem = XMLUtils.getFirstElement(elemName, root);
        if (elem != null) {
            return XMLUtils.getSimpleElementText(elem, trim);
        }
        return null;
    }

    public static String getElementText(String elemName, Element root) {
        return XMLUtils.getElementText(elemName, root, false);
    }

    public static Document getDocumentRoot(InputStream is) {
        Document document;
        InputSource inputSource = new InputSource(is);
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            document = parser.parse(inputSource);
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Unable to parse xml stream: Reason is [" + e + "]");
            return null;
        }
        return document;
    }

    public static Element addNode(Document doc, Node parent, String name) {
        Element child = doc.createElement(name);
        parent.appendChild(child);
        return child;
    }

    public static void addNode(Document doc, Node parent, String name, String text) {
        Element child = doc.createElement(name);
        child.appendChild(doc.createTextNode(text));
        parent.appendChild(child);
    }

    public static void addNode(Document doc, Node parent, String ns, String name, String text, Map NS_MAP) {
        Element child = doc.createElementNS((String)NS_MAP.get(ns), ns + ":" + name);
        child.appendChild(doc.createTextNode(text));
        parent.appendChild(child);
    }

    public static void addAttribute(Document doc, Element node, String name, String value) {
        Attr attribute = doc.createAttribute(name);
        attribute.setValue(value);
        node.getAttributes().setNamedItem(attribute);
    }
}

