/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.ejbd;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.openejb.client.KeepAliveStyle;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.ServerService;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.server.ServicePool;
import org.apache.openejb.server.ejbd.EjbServer;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class KeepAliveServer
implements ServerService {
    private static final Logger logger = Logger.getInstance((LogCategory)LogCategory.OPENEJB_SERVER.createChild("keepalive"), KeepAliveServer.class);
    private final ServerService service;
    private final long timeout = 3000L;
    private final AtomicBoolean stop = new AtomicBoolean();
    private final KeepAliveTimer keepAliveTimer;
    private Timer timer;

    public KeepAliveServer() {
        this(new EjbServer());
    }

    public KeepAliveServer(ServerService service) {
        this.service = service;
        this.keepAliveTimer = new KeepAliveTimer();
        this.timer = new Timer("KeepAliveTimer", true);
        this.timer.scheduleAtFixedRate((TimerTask)this.keepAliveTimer, 3000L, 1500L);
    }

    public void service(Socket socket) throws ServiceException, IOException {
        Session session = new Session(socket);
        session.service(socket);
    }

    public void service(InputStream in, OutputStream out) throws ServiceException, IOException {
    }

    public String getIP() {
        return this.service.getIP();
    }

    public String getName() {
        return this.service.getName();
    }

    public int getPort() {
        return this.service.getPort();
    }

    public void start() throws ServiceException {
        this.stop.set(false);
    }

    public void stop() throws ServiceException {
        this.stop.set(true);
        this.keepAliveTimer.closeSessions();
    }

    public void init(Properties props) throws Exception {
        this.service.init(props);
    }

    public class Output
    extends FilterOutputStream {
        public Output(OutputStream out) {
            super(out);
        }

        public void close() throws IOException {
            this.flush();
        }
    }

    public class Input
    extends FilterInputStream {
        public Input(InputStream in) {
            super(in);
        }

        public void close() throws IOException {
        }
    }

    private class Session {
        private final Thread thread;
        private final Lock usage = new ReentrantLock();
        private long lastRequest;
        private final Socket socket;

        public Session(Socket socket) {
            this.socket = socket;
            this.lastRequest = System.currentTimeMillis();
            this.thread = Thread.currentThread();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void service(Socket socket) throws ServiceException, IOException {
            KeepAliveServer.this.keepAliveTimer.addSession(this);
            int i = -1;
            try {
                BufferedInputStream in = new BufferedInputStream(socket.getInputStream());
                BufferedOutputStream out = new BufferedOutputStream(socket.getOutputStream());
                while (!KeepAliveServer.this.stop.get()) {
                    try {
                        i = ((InputStream)in).read();
                    }
                    catch (SocketException e) {
                        break;
                    }
                    if (i == -1) {
                        break;
                    }
                    KeepAliveStyle style = KeepAliveStyle.values()[i];
                    try {
                        this.usage.lock();
                        switch (style) {
                            case PING_PING: {
                                ((InputStream)in).read();
                                break;
                            }
                            case PING_PONG: {
                                ((OutputStream)out).write(style.ordinal());
                                ((OutputStream)out).flush();
                            }
                        }
                        KeepAliveServer.this.service.service((InputStream)new Input(in), (OutputStream)new Output(out));
                        ((OutputStream)out).flush();
                    }
                    finally {
                        this.lastRequest = System.currentTimeMillis();
                        this.usage.unlock();
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IOException("Unexpected byte " + i);
            }
            catch (InterruptedIOException e) {
                Thread.interrupted();
            }
            finally {
                KeepAliveServer.this.keepAliveTimer.removeSession(this);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class KeepAliveTimer
    extends TimerTask {
        private final Map<Thread, Session> sessions = new ConcurrentHashMap<Thread, Session>();
        private BlockingQueue<Runnable> queue;

        @Override
        public void run() {
            if (!KeepAliveServer.this.stop.get()) {
                this.closeInactiveSessions();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeInactiveSessions() {
            BlockingQueue<Runnable> queue = this.getQueue();
            if (queue == null) {
                return;
            }
            int backlog = queue.size();
            if (backlog <= 0) {
                return;
            }
            long now = System.currentTimeMillis();
            for (Session session : this.sessions.values()) {
                block12: {
                    if (session.usage.tryLock()) {
                        try {
                            if (now - session.lastRequest <= 3000L) break block12;
                            try {
                                --backlog;
                                session.socket.close();
                            }
                            catch (IOException e) {
                                logger.info("Error closing socket.", (Throwable)e);
                            }
                            finally {
                                this.removeSession(session);
                            }
                        }
                        finally {
                            session.usage.unlock();
                        }
                    }
                }
                if (backlog > 0) continue;
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void closeSessions() {
            for (Session session : this.sessions.values()) {
                if (session.usage.tryLock()) {
                    try {
                        session.socket.close();
                        continue;
                    }
                    catch (IOException e) {
                        logger.info("Error closing socket.", (Throwable)e);
                        continue;
                    }
                    finally {
                        this.removeSession(session);
                        session.usage.unlock();
                        continue;
                    }
                }
                logger.debug("Allowing graceful shutdown of " + session.socket.getInetAddress());
            }
        }

        private BlockingQueue<Runnable> getQueue() {
            if (this.queue == null) {
                ServicePool incoming = (ServicePool)SystemInstance.get().getComponent(ServicePool.class);
                if (incoming == null) {
                    return null;
                }
                ThreadPoolExecutor threadPool = incoming.getThreadPool();
                this.queue = threadPool.getQueue();
            }
            return this.queue;
        }

        public Session addSession(Session session) {
            return this.sessions.put(session.thread, session);
        }

        public Session removeSession(Session session) {
            return this.sessions.remove(session.thread);
        }
    }
}

