/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.kernel.PreparedStatementManagerImpl;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.sql.RowImpl;
import org.apache.openjpa.jdbc.sql.SQLExceptions;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.lib.jdbc.ReportingSQLException;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.OptimisticException;

public class BatchingPreparedStatementManagerImpl
extends PreparedStatementManagerImpl {
    private static final Localizer _loc = Localizer.forPackage(BatchingPreparedStatementManagerImpl.class);
    private String _batchedSql = null;
    private List _batchedRows = new ArrayList();
    private int _batchLimit;
    private boolean _disableBatch = false;

    public BatchingPreparedStatementManagerImpl(JDBCStore store, Connection conn, int batchLimit) {
        super(store, conn);
        this._batchLimit = batchLimit;
        if (this._log.isTraceEnabled()) {
            this._log.trace((Object)_loc.get("batch_limit", (Object)String.valueOf(this._batchLimit)));
        }
    }

    protected void flushAndUpdate(RowImpl row) throws SQLException {
        if (this.isBatchDisabled(row)) {
            this.flushBatch();
            super.flushAndUpdate(row);
        } else {
            this.batchOrExecuteRow(row);
        }
    }

    protected void batchOrExecuteRow(RowImpl row) throws SQLException {
        String sql = row.getSQL(this._dict);
        if (this._batchedSql == null) {
            this._batchedSql = sql;
        } else if (!sql.equals(this._batchedSql)) {
            switch (this._batchedRows.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    super.flushAndUpdate((RowImpl)this._batchedRows.get(0));
                    this._batchedRows.clear();
                    break;
                }
                default: {
                    this.flushBatch();
                }
            }
            this._batchedSql = sql;
        }
        this._batchedRows.add(row);
    }

    private boolean isBatchDisabled(RowImpl row) {
        boolean rtnVal = true;
        int limit = this.getBatchLimit();
        if (!(limit >= 0 && limit <= 1 || this.isBatchDisabled())) {
            OpenJPAStateManager sm = row.getPrimaryKey();
            ClassMapping cmd = null;
            if (sm != null) {
                cmd = (ClassMapping)sm.getMetaData();
            }
            Column[] autoAssign = null;
            if (row.getAction() == 1) {
                autoAssign = row.getTable().getAutoAssignedColumns();
            }
            rtnVal = this._dict.validateBatchProcess(row, autoAssign, sm, cmd);
            this.setBatchDisabled(rtnVal);
        }
        return rtnVal;
    }

    protected void flushBatch() throws SQLException {
        List batchedRows = this.getBatchedRows();
        String batchedSql = this.getBatchedSql();
        if (batchedRows == null) {
            return;
        }
        int batchSize = batchedRows.size();
        if (batchedSql != null && batchSize > 0) {
            PreparedStatement ps = null;
            try {
                RowImpl onerow2 = null;
                ps = this.prepareStatement(batchedSql);
                if (batchSize == 1) {
                    onerow2 = (RowImpl)batchedRows.get(0);
                    this.flushSingleRow(onerow2, ps);
                } else {
                    int[] rtn;
                    int count = 0;
                    int batchedRowsBaseIndex = 0;
                    for (RowImpl onerow2 : batchedRows) {
                        if (this._batchLimit == 1) {
                            this.flushSingleRow(onerow2, ps);
                            continue;
                        }
                        if (count < this._batchLimit || this._batchLimit == -1) {
                            if (ps != null) {
                                onerow2.flush(ps, this._dict, this._store);
                            }
                            this.addBatch(ps, onerow2, count);
                            ++count;
                            continue;
                        }
                        rtn = this.executeBatch(ps);
                        this.checkUpdateCount(rtn, batchedRowsBaseIndex, ps);
                        batchedRowsBaseIndex += this._batchLimit;
                        if (ps != null) {
                            onerow2.flush(ps, this._dict, this._store);
                        }
                        this.addBatch(ps, onerow2, count);
                        count = 1;
                    }
                    rtn = this.executeBatch(ps);
                    this.checkUpdateCount(rtn, batchedRowsBaseIndex, ps);
                }
            }
            catch (SQLException se) {
                SQLException sqex = se.getNextException();
                if (sqex == null) {
                    sqex = se;
                }
                if (se instanceof ReportingSQLException) {
                    int index = ((ReportingSQLException)se).getIndexOfFirstFailedObject();
                    if (batchSize == 1) {
                        index = 0;
                    }
                    if (index < 0) {
                        throw SQLExceptions.getStore(se, ps, this._dict);
                    }
                    throw SQLExceptions.getStore(se, ((RowImpl)this._batchedRows.get(index)).getFailedObject(), this._dict);
                }
                throw SQLExceptions.getStore(sqex, ps, this._dict);
            }
            finally {
                this._batchedSql = null;
                batchedRows.clear();
                if (ps != null) {
                    ps.clearParameters();
                    try {
                        ps.close();
                    }
                    catch (SQLException sqex) {
                        throw SQLExceptions.getStore(sqex, ps, this._dict);
                    }
                }
            }
        }
    }

    private void flushSingleRow(RowImpl row, PreparedStatement ps) throws SQLException {
        int count;
        if (ps != null) {
            row.flush(ps, this._dict, this._store);
        }
        if ((count = this.executeUpdate(ps, row.getSQL(this._dict), row)) != 1) {
            this.logSQLWarnings(ps);
            Object failed = row.getFailedObject();
            if (failed != null) {
                this._exceptions.add(new OptimisticException(failed));
            } else if (row.getAction() == 1) {
                throw new SQLException(_loc.get("update-failed-no-failed-obj", (Object)String.valueOf(count), (Object)row.getSQL(this._dict)).getMessage());
            }
        }
    }

    private void checkUpdateCount(int[] count, int batchedRowsBaseIndex, PreparedStatement ps) throws SQLException {
        int cnt = 0;
        int updateSuccessCnt = this._dict.getBatchUpdateCount(ps);
        Object failed = null;
        List batchedRows = this.getBatchedRows();
        block5: for (int i = 0; i < count.length; ++i) {
            cnt = count[i];
            RowImpl row = (RowImpl)batchedRows.get(batchedRowsBaseIndex + i);
            failed = row.getFailedObject();
            switch (cnt) {
                case -3: {
                    if (failed != null || row.getAction() == 0) {
                        this._exceptions.add(new OptimisticException(failed));
                        continue block5;
                    }
                    if (row.getAction() != 1) continue block5;
                    throw new SQLException(_loc.get("update-failed-no-failed-obj", (Object)String.valueOf(count[i]), (Object)row.getSQL(this._dict)).getMessage());
                }
                case -2: {
                    if (this._dict.reportsSuccessNoInfoOnBatchUpdates && updateSuccessCnt != count.length) {
                        if (failed != null) {
                            this._exceptions.add(new OptimisticException(failed));
                        } else if (row.getAction() == 1) {
                            throw new SQLException(_loc.get("update-failed-no-failed-obj", (Object)String.valueOf(count[i]), (Object)row.getSQL(this._dict)).getMessage());
                        }
                    }
                    if (!this._log.isTraceEnabled()) continue block5;
                    this._log.trace((Object)_loc.get("batch_update_info", (Object)String.valueOf(cnt), (Object)row.getSQL(this._dict)).getMessage());
                    continue block5;
                }
                case 0: {
                    this.logSQLWarnings(ps);
                    if (failed != null) {
                        this._exceptions.add(new OptimisticException(failed));
                        continue block5;
                    }
                    if (row.getAction() != 1) continue block5;
                    throw new SQLException(_loc.get("update-failed-no-failed-obj", (Object)String.valueOf(count[i]), (Object)row.getSQL(this._dict)).getMessage());
                }
            }
        }
    }

    public boolean isBatchDisabled() {
        return this._disableBatch;
    }

    public void setBatchDisabled(boolean disableBatch) {
        this._disableBatch = disableBatch;
    }

    public int getBatchLimit() {
        return this._batchLimit;
    }

    public void setBatchLimit(int batchLimit) {
        this._batchLimit = batchLimit;
    }

    public List getBatchedRows() {
        return this._batchedRows;
    }

    public String getBatchedSql() {
        return this._batchedSql;
    }

    protected void addBatch(PreparedStatement ps, RowImpl row, int count) throws SQLException {
        ps.addBatch();
    }

    protected int[] executeBatch(PreparedStatement ps) throws SQLException {
        return ps.executeBatch();
    }
}

