/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel.exps;

import java.sql.SQLException;
import java.util.Map;
import org.apache.openjpa.jdbc.kernel.exps.AbstractVal;
import org.apache.openjpa.jdbc.kernel.exps.ExpContext;
import org.apache.openjpa.jdbc.kernel.exps.ExpState;
import org.apache.openjpa.jdbc.kernel.exps.PCPath;
import org.apache.openjpa.jdbc.kernel.exps.Val;
import org.apache.openjpa.jdbc.sql.Result;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.meta.ClassMetaData;

public class MapEntry
extends AbstractVal {
    private final Val _key;
    private final Val _val;
    private ClassMetaData _meta = null;
    private Class _cast = null;
    private Class _type = null;

    public MapEntry(Val key, Val val) {
        ((PCPath)key).getKey();
        this._key = key;
        this._val = val;
    }

    public void appendTo(Select sel, ExpContext ctx, ExpState state, SQLBuffer sql, int index) {
    }

    public void calculateValue(Select sel, ExpContext ctx, ExpState state, Val other, ExpState otherState) {
        this._val.calculateValue(sel, ctx, state, other, otherState);
        this._key.calculateValue(sel, ctx, state, other, otherState);
    }

    public void groupBy(Select sel, ExpContext ctx, ExpState state) {
    }

    public ExpState initialize(Select sel, ExpContext ctx, int flags) {
        ExpState val = this._val.initialize(sel, ctx, flags);
        ExpState key = this._key.initialize(sel, ctx, flags);
        return new EntryExpState(key, val);
    }

    public int length(Select sel, ExpContext ctx, ExpState state) {
        return 1;
    }

    public Object load(ExpContext ctx, ExpState state, Result res) throws SQLException {
        EntryExpState estate = (EntryExpState)state;
        Object key = this._key.load(ctx, estate.key, res);
        Object val = this._val.load(ctx, estate.val, res);
        if (key == null || val == null) {
            return null;
        }
        return new Entry<Object, Object>(key, val);
    }

    public void orderBy(Select sel, ExpContext ctx, ExpState state, boolean asc) {
    }

    public void select(Select sel, ExpContext ctx, ExpState state, boolean pks) {
        this.selectColumns(sel, ctx, state, pks);
    }

    public void selectColumns(Select sel, ExpContext ctx, ExpState state, boolean pks) {
        EntryExpState estate = (EntryExpState)state;
        this._key.selectColumns(sel, ctx, estate.key, pks);
        this._val.selectColumns(sel, ctx, estate.val, pks);
    }

    public ClassMetaData getMetaData() {
        return this._meta;
    }

    public Class getType() {
        return Map.Entry.class;
    }

    public void setImplicitType(Class type) {
    }

    public void setMetaData(ClassMetaData meta) {
        this._meta = meta;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Entry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private final V value;

        public Entry(K k, V v) {
            this.key = k;
            this.value = v;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof Map.Entry)) {
                return false;
            }
            Map.Entry that = (Map.Entry)other;
            return (this.key == null ? that.getKey() == null : this.key.equals(that.getKey())) && (this.value == null ? that.getValue() == null : this.value.equals(that.getValue()));
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }
    }

    public static class EntryExpState
    extends ExpState {
        public ExpState key;
        public ExpState val;

        EntryExpState(ExpState key, ExpState val) {
            this.key = key;
            this.val = val;
        }
    }
}

