/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.meta;

import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.List;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.Reflection;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.FieldMappingInfo;
import org.apache.openjpa.jdbc.meta.FieldStrategy;
import org.apache.openjpa.jdbc.meta.JDBCColumnOrder;
import org.apache.openjpa.jdbc.meta.JDBCOrder;
import org.apache.openjpa.jdbc.meta.MappingRepository;
import org.apache.openjpa.jdbc.meta.ValueHandler;
import org.apache.openjpa.jdbc.meta.ValueMapping;
import org.apache.openjpa.jdbc.meta.ValueMappingImpl;
import org.apache.openjpa.jdbc.meta.ValueMappingInfo;
import org.apache.openjpa.jdbc.meta.strats.NoneFieldStrategy;
import org.apache.openjpa.jdbc.meta.strats.PrimitiveFieldStrategy;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.ColumnIO;
import org.apache.openjpa.jdbc.schema.ForeignKey;
import org.apache.openjpa.jdbc.schema.Index;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.jdbc.schema.Unique;
import org.apache.openjpa.jdbc.sql.Joins;
import org.apache.openjpa.jdbc.sql.Result;
import org.apache.openjpa.jdbc.sql.Row;
import org.apache.openjpa.jdbc.sql.RowManager;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.jdbc.sql.SelectExecutor;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.StateManagerImpl;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.util.ApplicationIds;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.MetaDataException;
import org.apache.openjpa.util.ObjectId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldMapping
extends FieldMetaData
implements ValueMapping,
FieldStrategy {
    private static final Localizer _loc = Localizer.forPackage(FieldMapping.class);
    private final ValueMapping _val;
    private final ValueMapping _key;
    private final ValueMapping _elem;
    private final FieldMappingInfo _info;
    private final JDBCColumnOrder _orderCol = new JDBCColumnOrder();
    private FieldStrategy _strategy = null;
    private ForeignKey _fk = null;
    private ColumnIO _io = null;
    private Unique _unq = null;
    private Index _idx = null;
    private boolean _outer = false;
    private int _fetchMode = Integer.MAX_VALUE;
    private Unique[] _joinTableUniques;
    private Boolean _bidirectionalJoinTableOwner = null;
    private Boolean _bidirectionalJoinTableNonOwner = null;
    private Boolean _bi_MTo1_JT = null;
    private Boolean _uni_1ToM_FK = null;
    private Boolean _uni_MTo1_JT = null;
    private Boolean _uni_1To1_JT = null;
    private Boolean _bi_1To1_JT = null;
    private FieldMapping _bi_1ToM_JT_Field = null;
    private FieldMapping _bi_MTo1_JT_Field = null;
    private ForeignKey _bi_1ToM_Join_FK = null;
    private ForeignKey _bi_1ToM_Elem_FK = null;
    private boolean _hasMapsIdCols = false;

    public FieldMapping(String name, Class<?> type, ClassMapping owner) {
        super(name, type, (ClassMetaData)owner);
        this._info = owner.getMappingRepository().newMappingInfo(this);
        this._val = (ValueMapping)this.getValue();
        this._key = (ValueMapping)this.getKey();
        this._elem = (ValueMapping)this.getElement();
        this.setUsesIntermediate(false);
        this.setUsesImplData(Boolean.FALSE);
    }

    public FieldMappingInfo getMappingInfo() {
        return this._info;
    }

    public FieldStrategy getStrategy() {
        return this._strategy;
    }

    public void setStrategy(FieldStrategy strategy, Boolean adapt) {
        FieldStrategy orig = this._strategy;
        this._strategy = strategy;
        if (strategy != null) {
            try {
                strategy.setFieldMapping(this);
                if (adapt != null) {
                    strategy.map(adapt);
                }
            }
            catch (RuntimeException re) {
                this._strategy = orig;
                throw re;
            }
            if (!this.isMapped()) {
                this.getDefiningMapping().clearDefinedFieldCache();
            }
        }
    }

    public Table getTable() {
        ClassMapping meta;
        if (this._fk != null) {
            return this._fk.getTable();
        }
        if (this._val.getForeignKey() != null) {
            return this._val.getForeignKey().getTable();
        }
        if (this._val.getDeclaredTypeCode() == 13 && (meta = this._elem.getDeclaredTypeMapping()) != null) {
            return meta.getTable();
        }
        ValueMappingImpl vm = (ValueMappingImpl)this.getDefiningMapping().getEmbeddingMetaData();
        if (vm != null && vm.getValueMappedBy() != null) {
            return vm.getFieldMapping().getElementMapping().getDeclaredTypeMapping().getTable();
        }
        return this.getDefiningMapping().getTable();
    }

    public ColumnIO getJoinColumnIO() {
        return this._io == null ? ColumnIO.UNRESTRICTED : this._io;
    }

    public void setJoinColumnIO(ColumnIO io) {
        this._io = io;
    }

    public ForeignKey getJoinForeignKey() {
        return this._fk;
    }

    public void setJoinForeignKey(ForeignKey fk) {
        this._fk = fk;
    }

    public Unique getJoinUnique() {
        return this._unq;
    }

    public void setJoinUnique(Unique unq) {
        this._unq = unq;
    }

    public Unique[] getJoinTableUniques() {
        return this._joinTableUniques;
    }

    public void setJoinTableUniques(Unique[] unqs) {
        this._joinTableUniques = unqs;
    }

    public Index getJoinIndex() {
        return this._idx;
    }

    public void setJoinIndex(Index idx) {
        this._idx = idx;
    }

    public boolean isJoinOuter() {
        return this._outer;
    }

    public void setJoinOuter(boolean outer) {
        this._outer = outer;
    }

    public Column getOrderColumn() {
        return this._orderCol.getColumn();
    }

    public void setOrderColumn(Column order) {
        this._orderCol.setColumn(order);
    }

    public ColumnIO getOrderColumnIO() {
        return this._orderCol.getColumnIO();
    }

    public void setOrderColumnIO(ColumnIO io) {
        this._orderCol.setColumnIO(io);
    }

    @Override
    public void refSchemaComponents() {
        if (this._fk != null) {
            this._fk.ref();
            this._fk.refColumns();
        }
        if (this._orderCol.getColumn() != null) {
            this._orderCol.getColumn().ref();
        }
        this._val.refSchemaComponents();
        this._key.refSchemaComponents();
        this._elem.refSchemaComponents();
        if (this._joinTableUniques != null) {
            for (Unique joinUnique : this._joinTableUniques) {
                for (Column col : joinUnique.getColumns()) {
                    col.ref();
                }
            }
        }
    }

    @Override
    public void clearMapping() {
        this._strategy = null;
        this._fk = null;
        this._unq = null;
        this._idx = null;
        this._outer = false;
        this._orderCol.setColumn(null);
        this._val.clearMapping();
        this._key.clearMapping();
        this._elem.clearMapping();
        this._info.clear();
        this.setResolve(2, false);
    }

    @Override
    public void syncMappingInfo() {
        if (!this.isVersion()) {
            if (this.getMappedByMapping() != null) {
                this._info.clear();
                this._val.getValueInfo().clear();
                this._key.getValueInfo().clear();
                this._elem.getValueInfo().clear();
                FieldMapping mapped = this.getMappedByMapping();
                this._info.syncStrategy(this);
                if (this._orderCol.getColumn() != null && mapped.getOrderColumn() == null) {
                    this._info.syncOrderColumn(this);
                }
                this._val.getValueInfo().setUseClassCriteria(this._val.getUseClassCriteria());
                this._key.getValueInfo().setUseClassCriteria(this._key.getUseClassCriteria());
                this._elem.getValueInfo().setUseClassCriteria(this._elem.getUseClassCriteria());
            } else {
                this._info.syncWith(this);
                this._val.syncMappingInfo();
                this._key.syncMappingInfo();
                this._elem.syncMappingInfo();
            }
        }
    }

    public boolean isMapped() {
        return this._strategy != NoneFieldStrategy.getInstance();
    }

    public int getEagerFetchMode() {
        if (this._fetchMode == Integer.MAX_VALUE) {
            this._fetchMode = -99;
        }
        return this._fetchMode;
    }

    public void setEagerFetchMode(int mode) {
        this._fetchMode = mode;
    }

    @Override
    public MappingRepository getMappingRepository() {
        return (MappingRepository)this.getRepository();
    }

    public ClassMapping getDefiningMapping() {
        return (ClassMapping)this.getDefiningMetaData();
    }

    public ClassMapping getDeclaringMapping() {
        return (ClassMapping)this.getDeclaringMetaData();
    }

    public ValueMapping getKeyMapping() {
        return this._key;
    }

    public ValueMapping getElementMapping() {
        return this._elem;
    }

    public ValueMapping getValueMapping() {
        return (ValueMapping)this.getValue();
    }

    public FieldMapping getMappedByMapping() {
        return (FieldMapping)this.getMappedByMetaData();
    }

    public FieldMapping[] getInverseMappings() {
        return (FieldMapping[])this.getInverseMetaDatas();
    }

    public boolean resolve(int mode) {
        int cur = this.getResolve();
        if (super.resolve(mode)) {
            return true;
        }
        if ((mode & 2) != 0 && (cur & 2) == 0) {
            this.resolveMapping();
        }
        if ((mode & 8) != 0 && (cur & 8) == 0) {
            this.initializeMapping();
        }
        return false;
    }

    private void resolveMapping() {
        Log log;
        MappingRepository repos = this.getMappingRepository();
        if (repos.getMappingDefaults().defaultMissingInfo()) {
            FieldMapping sup;
            ClassMapping cls = this.getDefiningMapping();
            if (cls.getEmbeddingMapping() != null) {
                ClassMapping orig = repos.getMapping(cls.getDescribedType(), cls.getEnvClassLoader(), true);
                FieldMapping tmplate = orig.getFieldMapping(this.getName());
                if (tmplate != null) {
                    this.copyMappingInfo(tmplate);
                }
            } else if (cls.isMapped() && cls.getPCSuperclass() != null && cls.getDescribedType() != this.getDeclaringType() && (sup = cls.getPCSuperclassMapping().getFieldMapping(this.getName())) != null) {
                this.copyMappingInfo(sup);
            }
        }
        if (this._strategy == null) {
            if (this.isVersion()) {
                this._strategy = NoneFieldStrategy.getInstance();
            } else {
                repos.getStrategyInstaller().installStrategy(this);
            }
        }
        if ((log = this.getRepository().getLog()).isTraceEnabled()) {
            log.trace((Object)_loc.get("field-strategy", (Object)this.getName(), (Object)this._strategy.getAlias()));
        }
        if (this._orderCol.getColumn() != null) {
            if (this.getOrderColumnIO().isInsertable(0, false)) {
                this._orderCol.getColumn().setFlag(8, true);
            }
            if (this.getOrderColumnIO().isUpdatable(0, false)) {
                this._orderCol.getColumn().setFlag(16, true);
            }
        }
        if (this._fk != null) {
            Column[] cols = this._fk.getColumns();
            ColumnIO io = this.getJoinColumnIO();
            for (int i = 0; i < cols.length; ++i) {
                if (io.isInsertable(i, false)) {
                    cols[i].setFlag(32, true);
                }
                if (!io.isUpdatable(i, false)) continue;
                cols[i].setFlag(64, true);
            }
        }
        this._val.resolve(2);
        this._key.resolve(2);
        this._elem.resolve(2);
    }

    public void copyMappingInfo(FieldMapping fm) {
        this.setMappedBy(fm.getMappedBy());
        this._info.copy(fm.getMappingInfo());
        this._val.copyMappingInfo(fm.getValueMapping());
        this._key.copyMappingInfo(fm.getKeyMapping());
        this._elem.copyMappingInfo(fm.getElementMapping());
    }

    private void initializeMapping() {
        this._val.resolve(8);
        this._key.resolve(8);
        this._elem.resolve(8);
        if (this._strategy != null) {
            this._strategy.initialize();
        }
    }

    public void copy(FieldMetaData fmd) {
        super.copy(fmd);
        if (this._fetchMode == Integer.MAX_VALUE) {
            this._fetchMode = ((FieldMapping)fmd).getEagerFetchMode();
        }
    }

    protected boolean validateDataStoreExtensionPrefix(String prefix) {
        return "jdbc-".equals(prefix);
    }

    @Override
    public String getAlias() {
        return this.assertStrategy().getAlias();
    }

    @Override
    public void map(boolean adapt) {
        this.assertStrategy().map(adapt);
    }

    public void mapJoin(boolean adapt, boolean joinRequired) {
        Table table = this._info.getTable(this, joinRequired, adapt);
        if (table != null && table.equals(this.getDefiningMapping().getTable())) {
            table = null;
        }
        ForeignKey join = null;
        if (table != null) {
            join = this._info.getJoin(this, table, adapt);
        }
        if (join == null && joinRequired) {
            throw new MetaDataException(_loc.get("join-required", (Object)this));
        }
        if (join == null) {
            this._info.assertNoJoin(this, true);
            this._info.assertNoForeignKey(this, !adapt);
            this._info.assertNoUnique(this, !adapt);
            this._info.assertNoIndex(this, !adapt);
        } else {
            this._fk = join;
            this._io = this._info.getColumnIO();
            this._outer = this._info.isJoinOuter();
            this._unq = this._info.getJoinUnique(this, false, adapt);
            this._joinTableUniques = this._info.getJoinTableUniques(this, false, adapt);
            this._idx = this._info.getJoinIndex(this, adapt);
            table.setAssociation();
        }
    }

    public void mapPrimaryKey(boolean adapt) {
        if (adapt && this._fk != null && this._fk.getTable().getPrimaryKey() == null) {
            this.getMappingRepository().getMappingDefaults().installPrimaryKey(this, this._fk.getTable());
        }
    }

    @Override
    public void initialize() {
        this.assertStrategy().initialize();
    }

    @Override
    public void insert(OpenJPAStateManager sm, JDBCStore store, RowManager rm) throws SQLException {
        this.setPKValueFromMappedByIdField(sm);
        this.assertStrategy().insert(sm, store, rm);
    }

    private void setPKValueFromMappedByIdField(OpenJPAStateManager sm) {
        if (sm instanceof StateManagerImpl) {
            List mappedByIdFields = ((StateManagerImpl)sm).getMappedByIdFields();
            if (mappedByIdFields == null) {
                return;
            }
            if (!mappedByIdFields.contains(this)) {
                return;
            }
            if (!this.isMappedById()) {
                return;
            }
            PersistenceCapable pc = (PersistenceCapable)sm.fetchObject(this.getIndex());
            if (pc == null) {
                return;
            }
            StateManagerImpl pkSm = (StateManagerImpl)pc.pcGetStateManager();
            Object pkVal = this.getPKValue(pkSm);
            if (pkVal == null) {
                return;
            }
            this.setPKValue((StateManagerImpl)sm, pkVal);
            sm.setObjectId(ApplicationIds.create((PersistenceCapable)sm.getPersistenceCapable(), (ClassMetaData)sm.getMetaData()));
        }
    }

    private Object getPKValue(StateManagerImpl pkSm) {
        ClassMetaData pkMeta = pkSm.getMetaData();
        FieldMetaData[] fmds = pkMeta.getPrimaryKeyFields();
        if (fmds.length == 0) {
            return null;
        }
        return ApplicationIds.getKey((Object)pkSm.getObjectId(), (ClassMetaData)pkMeta);
    }

    private void setPKValue(StateManagerImpl sm, Object pkVal) {
        ClassMetaData meta = sm.getMetaData();
        FieldMetaData[] fmds = meta.getPrimaryKeyFields();
        if (fmds.length == 0) {
            return;
        }
        FieldStrategy strat = ((FieldMapping)fmds[0]).getStrategy();
        if (strat instanceof PrimitiveFieldStrategy) {
            ((PrimitiveFieldStrategy)strat).setAutoAssignedValue((OpenJPAStateManager)sm, null, null, pkVal);
        } else {
            String mappedByIdFieldName = this.getMappedByIdValue();
            if (mappedByIdFieldName != null && mappedByIdFieldName.length() > 0) {
                Object target = ((ObjectId)sm.getObjectId()).getId();
                if (target == null) {
                    return;
                }
                this.setMappedByIdValue(target, pkVal, mappedByIdFieldName);
                pkVal = target;
            }
            sm.storeObjectField(fmds[0].getIndex(), pkVal);
        }
    }

    public void setMappedByIdValue(Object target, Object val, String mappedByIdFieldName) {
        Reflection.set((Object)target, (Field)Reflection.findField(target.getClass(), (String)mappedByIdFieldName, (boolean)true), (Object)val);
    }

    @Override
    public void update(OpenJPAStateManager sm, JDBCStore store, RowManager rm) throws SQLException {
        this.assertStrategy().update(sm, store, rm);
    }

    @Override
    public void delete(OpenJPAStateManager sm, JDBCStore store, RowManager rm) throws SQLException {
        this.assertStrategy().delete(sm, store, rm);
    }

    public void deleteRow(OpenJPAStateManager sm, JDBCStore store, RowManager rm) throws SQLException {
        if (this._fk != null) {
            Row row = rm.getRow(this.getTable(), 2, sm, true);
            row.whereForeignKey(this._fk, sm);
        }
    }

    public Row getRow(OpenJPAStateManager sm, JDBCStore store, RowManager rm, int action) throws SQLException {
        Row row = null;
        boolean newOuterRow = false;
        if (this._fk != null && this._outer && action != 2) {
            if (action == 0) {
                row = rm.getRow(this.getTable(), 0, sm, false);
                if (row == null) {
                    Row del = rm.getRow(this.getTable(), 2, sm, true);
                    del.whereForeignKey(this._fk, sm);
                }
            } else {
                row = rm.getRow(this.getTable(), 1, sm, false);
            }
            if (row == null && !this.isNullValue(sm)) {
                row = rm.getRow(this.getTable(), 1, sm, true);
                newOuterRow = true;
            }
        } else {
            row = rm.getRow(this.getTable(), action, sm, true);
        }
        if (row != null && this._fk != null) {
            if (row.getAction() == 1) {
                row.setForeignKey(this._fk, this._io, sm);
            } else {
                row.whereForeignKey(this._fk, sm);
            }
            if (newOuterRow) {
                row.setValid(false);
            }
        }
        return row;
    }

    private boolean isNullValue(OpenJPAStateManager sm) {
        switch (this.getTypeCode()) {
            case 0: {
                return !sm.fetchBoolean(this.getIndex());
            }
            case 1: {
                return sm.fetchByte(this.getIndex()) == 0;
            }
            case 2: {
                return sm.fetchChar(this.getIndex()) == '\u0000';
            }
            case 3: {
                return sm.fetchDouble(this.getIndex()) == 0.0;
            }
            case 4: {
                return sm.fetchFloat(this.getIndex()) == 0.0f;
            }
            case 5: {
                return sm.fetchInt(this.getIndex()) == 0;
            }
            case 6: {
                return sm.fetchLong(this.getIndex()) == 0L;
            }
            case 7: {
                return sm.fetchShort(this.getIndex()) == 0;
            }
            case 9: {
                return sm.fetchString(this.getIndex()) == null;
            }
        }
        return sm.fetchObject(this.getIndex()) == null;
    }

    @Override
    public Boolean isCustomInsert(OpenJPAStateManager sm, JDBCStore store) {
        return this.assertStrategy().isCustomInsert(sm, store);
    }

    @Override
    public Boolean isCustomUpdate(OpenJPAStateManager sm, JDBCStore store) {
        return this.assertStrategy().isCustomUpdate(sm, store);
    }

    @Override
    public Boolean isCustomDelete(OpenJPAStateManager sm, JDBCStore store) {
        return this.assertStrategy().isCustomDelete(sm, store);
    }

    @Override
    public void customInsert(OpenJPAStateManager sm, JDBCStore store) throws SQLException {
        this.assertStrategy().customInsert(sm, store);
    }

    @Override
    public void customUpdate(OpenJPAStateManager sm, JDBCStore store) throws SQLException {
        this.assertStrategy().customUpdate(sm, store);
    }

    @Override
    public void customDelete(OpenJPAStateManager sm, JDBCStore store) throws SQLException {
        this.assertStrategy().customDelete(sm, store);
    }

    @Override
    public void setFieldMapping(FieldMapping owner) {
        this.assertStrategy().setFieldMapping(owner);
    }

    @Override
    public int supportsSelect(Select sel, int type, OpenJPAStateManager sm, JDBCStore store, JDBCFetchConfiguration fetch) {
        return this.assertStrategy().supportsSelect(sel, type, sm, store, fetch);
    }

    @Override
    public void selectEagerParallel(SelectExecutor sel, OpenJPAStateManager sm, JDBCStore store, JDBCFetchConfiguration fetch, int eagerMode) {
        this.assertStrategy().selectEagerParallel(sel, sm, store, fetch, eagerMode);
    }

    @Override
    public void selectEagerJoin(Select sel, OpenJPAStateManager sm, JDBCStore store, JDBCFetchConfiguration fetch, int eagerMode) {
        this.assertStrategy().selectEagerJoin(sel, sm, store, fetch, eagerMode);
    }

    @Override
    public boolean isEagerSelectToMany() {
        return this.assertStrategy().isEagerSelectToMany();
    }

    @Override
    public int select(Select sel, OpenJPAStateManager sm, JDBCStore store, JDBCFetchConfiguration fetch, int eagerMode) {
        return this.assertStrategy().select(sel, sm, store, fetch, eagerMode);
    }

    public Joins join(Select sel) {
        if (this._fk == null) {
            return null;
        }
        Joins joins = sel.newJoins();
        if (this._outer) {
            return joins.outerJoin(this._fk, true, false);
        }
        return joins.join(this._fk, true, false);
    }

    public void wherePrimaryKey(Select sel, OpenJPAStateManager sm, JDBCStore store) {
        if (this._fk != null) {
            sel.whereForeignKey(this._fk, sm.getObjectId(), this.getDefiningMapping(), store);
        } else {
            sel.wherePrimaryKey(sm.getObjectId(), this.getDefiningMapping(), store);
        }
    }

    public void orderLocal(Select sel, ClassMapping elem, Joins joins) {
        this._orderCol.order(sel, elem, joins);
        JDBCOrder[] orders = (JDBCOrder[])this.getOrders();
        for (int i = 0; i < orders.length; ++i) {
            if (orders[i].isInRelation()) continue;
            orders[i].order(sel, elem, joins);
        }
    }

    public void orderRelation(Select sel, ClassMapping elem, Joins joins) {
        JDBCOrder[] orders = (JDBCOrder[])this.getOrders();
        for (int i = 0; i < orders.length; ++i) {
            if (!orders[i].isInRelation()) continue;
            orders[i].order(sel, elem, joins);
        }
    }

    @Override
    public Object loadEagerParallel(OpenJPAStateManager sm, JDBCStore store, JDBCFetchConfiguration fetch, Object res) throws SQLException {
        return this.assertStrategy().loadEagerParallel(sm, store, fetch, res);
    }

    @Override
    public void loadEagerJoin(OpenJPAStateManager sm, JDBCStore store, JDBCFetchConfiguration fetch, Result res) throws SQLException {
        this.assertStrategy().loadEagerJoin(sm, store, fetch, res);
    }

    @Override
    public void load(OpenJPAStateManager sm, JDBCStore store, JDBCFetchConfiguration fetch, Result res) throws SQLException {
        this.assertStrategy().load(sm, store, fetch, res);
    }

    @Override
    public void load(OpenJPAStateManager sm, JDBCStore store, JDBCFetchConfiguration fetch) throws SQLException {
        this.assertStrategy().load(sm, store, fetch);
    }

    @Override
    public Object toDataStoreValue(Object val, JDBCStore store) {
        return this.assertStrategy().toDataStoreValue(val, store);
    }

    @Override
    public Object toKeyDataStoreValue(Object val, JDBCStore store) {
        return this.assertStrategy().toKeyDataStoreValue(val, store);
    }

    @Override
    public void appendIsEmpty(SQLBuffer sql, Select sel, Joins joins) {
        this.assertStrategy().appendIsEmpty(sql, sel, joins);
    }

    @Override
    public void appendIsNotEmpty(SQLBuffer sql, Select sel, Joins joins) {
        this.assertStrategy().appendIsNotEmpty(sql, sel, joins);
    }

    @Override
    public void appendIsNull(SQLBuffer sql, Select sel, Joins joins) {
        this.assertStrategy().appendIsNull(sql, sel, joins);
    }

    @Override
    public void appendIsNotNull(SQLBuffer sql, Select sel, Joins joins) {
        this.assertStrategy().appendIsNotNull(sql, sel, joins);
    }

    @Override
    public void appendSize(SQLBuffer sql, Select sel, Joins joins) {
        this.assertStrategy().appendSize(sql, sel, joins);
    }

    @Override
    public void appendIndex(SQLBuffer sql, Select sel, Joins joins) {
        this.assertStrategy().appendIndex(sql, sel, joins);
    }

    @Override
    public void appendType(SQLBuffer sql, Select sel, Joins joins) {
        this.assertStrategy().appendType(sql, sel, joins);
    }

    @Override
    public Joins join(Joins joins, boolean forceOuter) {
        return this.assertStrategy().join(joins, forceOuter);
    }

    @Override
    public Joins joinKey(Joins joins, boolean forceOuter) {
        return this.assertStrategy().joinKey(joins, forceOuter);
    }

    @Override
    public Joins joinRelation(Joins joins, boolean forceOuter, boolean traverse) {
        return this.assertStrategy().joinRelation(joins, forceOuter, traverse);
    }

    @Override
    public Joins joinKeyRelation(Joins joins, boolean forceOuter, boolean traverse) {
        return this.assertStrategy().joinKeyRelation(joins, forceOuter, traverse);
    }

    public Joins join(Joins joins, boolean forceOuter, boolean toMany) {
        if (this._fk == null) {
            return joins;
        }
        if (this._outer || forceOuter) {
            return joins.outerJoin(this._fk, true, toMany);
        }
        return joins.join(this._fk, true, toMany);
    }

    @Override
    public Object loadProjection(JDBCStore store, JDBCFetchConfiguration fetch, Result res, Joins joins) throws SQLException {
        if (this.isVersion()) {
            return this.getDefiningMapping().getVersion().load(null, store, res);
        }
        return this.assertStrategy().loadProjection(store, fetch, res, joins);
    }

    @Override
    public Object loadKeyProjection(JDBCStore store, JDBCFetchConfiguration fetch, Result res, Joins joins) throws SQLException {
        return this.assertStrategy().loadKeyProjection(store, fetch, res, joins);
    }

    @Override
    public boolean isVersionable() {
        return this.assertStrategy().isVersionable();
    }

    @Override
    public void where(OpenJPAStateManager sm, JDBCStore store, RowManager rm, Object prevValue) throws SQLException {
        this.assertStrategy().where(sm, store, rm, prevValue);
    }

    private FieldStrategy assertStrategy() {
        if (this._strategy == null) {
            throw new InternalException();
        }
        return this._strategy;
    }

    @Override
    public ValueMappingInfo getValueInfo() {
        return this._val.getValueInfo();
    }

    @Override
    public ValueHandler getHandler() {
        return this._val.getHandler();
    }

    @Override
    public void setHandler(ValueHandler handler) {
        this._val.setHandler(handler);
    }

    @Override
    public FieldMapping getFieldMapping() {
        return this;
    }

    @Override
    public ClassMapping getTypeMapping() {
        return this._val.getTypeMapping();
    }

    @Override
    public ClassMapping getDeclaredTypeMapping() {
        return this._val.getDeclaredTypeMapping();
    }

    @Override
    public ClassMapping getEmbeddedMapping() {
        return this._val.getEmbeddedMapping();
    }

    @Override
    public FieldMapping getValueMappedByMapping() {
        return this._val.getValueMappedByMapping();
    }

    @Override
    public Column[] getColumns() {
        if (this.isVersion()) {
            return this.getDeclaringMapping().getVersion().getColumns();
        }
        return this._val.getColumns();
    }

    @Override
    public void setColumns(Column[] cols) {
        this._val.setColumns(cols);
    }

    @Override
    public ColumnIO getColumnIO() {
        return this._val.getColumnIO();
    }

    @Override
    public void setColumnIO(ColumnIO io) {
        this._val.setColumnIO(io);
    }

    @Override
    public ForeignKey getForeignKey() {
        return this._val.getForeignKey();
    }

    @Override
    public ForeignKey getForeignKey(ClassMapping target) {
        return this._val.getForeignKey(target);
    }

    @Override
    public void setForeignKey(ForeignKey fk) {
        this._val.setForeignKey(fk);
    }

    @Override
    public int getJoinDirection() {
        return this._val.getJoinDirection();
    }

    @Override
    public void setJoinDirection(int direction) {
        this._val.setJoinDirection(direction);
    }

    @Override
    public void setForeignKey(Row row, OpenJPAStateManager sm) throws SQLException {
        this._val.setForeignKey(row, sm);
    }

    @Override
    public void whereForeignKey(Row row, OpenJPAStateManager sm) throws SQLException {
        this._val.whereForeignKey(row, sm);
    }

    @Override
    public ClassMapping[] getIndependentTypeMappings() {
        return this._val.getIndependentTypeMappings();
    }

    @Override
    public int getSelectSubclasses() {
        return this._val.getSelectSubclasses();
    }

    @Override
    public Unique getValueUnique() {
        return this._val.getValueUnique();
    }

    @Override
    public void setValueUnique(Unique unq) {
        this._val.setValueUnique(unq);
    }

    @Override
    public Index getValueIndex() {
        return this._val.getValueIndex();
    }

    @Override
    public void setValueIndex(Index idx) {
        this._val.setValueIndex(idx);
    }

    @Override
    public boolean getUseClassCriteria() {
        return this._val.getUseClassCriteria();
    }

    @Override
    public void setUseClassCriteria(boolean criteria) {
        this._val.setUseClassCriteria(criteria);
    }

    @Override
    public int getPolymorphic() {
        return this._val.getPolymorphic();
    }

    @Override
    public void setPolymorphic(int poly) {
        this._val.setPolymorphic(poly);
    }

    @Override
    public void mapConstraints(String name, boolean adapt) {
        this._val.mapConstraints(name, adapt);
    }

    @Override
    public void mapConstraints(DBIdentifier name, boolean adapt) {
        this._val.mapConstraints(name, adapt);
    }

    @Override
    public void copyMappingInfo(ValueMapping vm) {
        this._val.copyMappingInfo(vm);
    }

    public boolean isBidirectionalJoinTableMappingOwner() {
        if (this._bidirectionalJoinTableOwner != null) {
            return this._bidirectionalJoinTableOwner;
        }
        this._bidirectionalJoinTableOwner = false;
        ForeignKey fk = this.getForeignKey();
        if (fk != null) {
            return false;
        }
        ForeignKey jfk = this.getJoinForeignKey();
        if (jfk == null) {
            return false;
        }
        FieldMapping mappedBy = this.getValueMappedByMapping();
        if (mappedBy != null) {
            return false;
        }
        ValueMapping elem = this.getElementMapping();
        if (elem == null) {
            return false;
        }
        ClassMapping relType = elem.getDeclaredTypeMapping();
        if (relType == null) {
            return false;
        }
        FieldMapping[] relFmds = relType.getFieldMappings();
        for (int i = 0; i < relFmds.length; ++i) {
            ForeignKey rjfk;
            FieldMapping rfm = relFmds[i];
            if (rfm.getDeclaredTypeMetaData() != this.getDeclaringMapping() || (rjfk = rfm.getJoinForeignKey()) == null || rjfk.getTable() != jfk.getTable() || jfk.getTable().getColumns().length != jfk.getColumns().length + rjfk.getColumns().length) continue;
            this._bidirectionalJoinTableOwner = true;
            break;
        }
        return this._bidirectionalJoinTableOwner;
    }

    public boolean isBidirectionalJoinTableMappingNonOwner() {
        if (this._bidirectionalJoinTableNonOwner != null) {
            return this._bidirectionalJoinTableNonOwner;
        }
        this._bidirectionalJoinTableNonOwner = false;
        ForeignKey fk = this.getForeignKey();
        if (fk == null) {
            return false;
        }
        ForeignKey jfk = this.getJoinForeignKey();
        if (jfk == null) {
            return false;
        }
        FieldMapping mappedBy = this.getValueMappedByMapping();
        if (mappedBy != null) {
            return false;
        }
        ValueMapping elem = this.getElementMapping();
        if (elem == null) {
            return false;
        }
        ClassMapping relType = this.getDeclaredTypeMapping();
        if (relType == null) {
            return false;
        }
        FieldMapping[] relFmds = relType.getFieldMappings();
        for (int i = 0; i < relFmds.length; ++i) {
            ForeignKey rjfk;
            FieldMapping rfm = relFmds[i];
            ValueMapping relem = rfm.getElementMapping();
            if (relem == null || relem.getDeclaredTypeMapping() != this.getDeclaringMapping() || (rjfk = rfm.getJoinForeignKey()) == null || rjfk.getTable() != jfk.getTable() || jfk.getTable().getColumns().length != jfk.getColumns().length + rjfk.getColumns().length) continue;
            this._bidirectionalJoinTableNonOwner = true;
            break;
        }
        return this._bidirectionalJoinTableNonOwner;
    }

    public boolean isBiMTo1JT() {
        if (this._bi_MTo1_JT == null) {
            this._bi_MTo1_JT = this.getMappingRepository().isBiMTo1JT(this);
        }
        return this._bi_MTo1_JT;
    }

    public boolean isUni1ToMFK() {
        if (this._uni_1ToM_FK == null) {
            this._uni_1ToM_FK = this.getMappingRepository().isUni1ToMFK(this);
        }
        return this._uni_1ToM_FK;
    }

    public boolean isUniMTo1JT() {
        if (this._uni_MTo1_JT == null) {
            this._uni_MTo1_JT = this.getMappingRepository().isUniMTo1JT(this);
        }
        return this._uni_MTo1_JT;
    }

    public boolean isUni1To1JT() {
        if (this._uni_1To1_JT == null) {
            this._uni_1To1_JT = this.getMappingRepository().isUni1To1JT(this);
        }
        return this._uni_1To1_JT;
    }

    public boolean isBi1To1JT() {
        if (this._bi_1To1_JT == null) {
            this._bi_1To1_JT = this.getMappingRepository().isBi1To1JT(this);
        }
        return this._bi_1To1_JT;
    }

    public FieldMapping getBi_1ToM_JTField() {
        if (this._bi_1ToM_JT_Field == null) {
            this._bi_1ToM_JT_Field = this.getMappingRepository().getBi_1ToM_JoinTableField(this);
        }
        return this._bi_1ToM_JT_Field;
    }

    public FieldMapping getBi_MTo1_JTField() {
        if (this._bi_MTo1_JT_Field == null) {
            this._bi_MTo1_JT_Field = this.getMappingRepository().getBi_MTo1_JoinTableField(this);
        }
        return this._bi_MTo1_JT_Field;
    }

    public ForeignKey getBi1ToMJoinFK() {
        if (this._bi_1ToM_Join_FK == null) {
            this.getBi_1ToM_JTField();
            if (this._bi_1ToM_JT_Field != null) {
                this._bi_1ToM_Join_FK = this._bi_1ToM_JT_Field.getJoinForeignKey();
            }
        }
        return this._bi_1ToM_Join_FK;
    }

    public ForeignKey getBi1ToMElemFK() {
        if (this._bi_1ToM_Elem_FK == null) {
            this.getBi_1ToM_JTField();
            if (this._bi_1ToM_JT_Field != null) {
                this._bi_1ToM_Elem_FK = this._bi_1ToM_JT_Field.getElementMapping().getForeignKey();
            }
        }
        return this._bi_1ToM_Elem_FK;
    }

    public void setBi1MJoinTableInfo() {
        FieldMapping mapped;
        if (this.getAssociationType() == 2 && (mapped = this.getBi_MTo1_JTField()) != null) {
            FieldMappingInfo info = this.getMappingInfo();
            FieldMappingInfo mappedInfo = mapped.getMappingInfo();
            info.setTableIdentifier(mappedInfo.getTableIdentifier());
            info.setColumns(mapped.getElementMapping().getValueInfo().getColumns());
            this.getElementMapping().getValueInfo().setColumns(mappedInfo.getColumns());
        }
    }

    public boolean isNonDefaultMappingUsingJoinTableStrategy() {
        return this.isBi1To1JT() || this.isUni1To1JT() || this.isUniMTo1JT() || this.isBiMTo1JT();
    }

    public void setMapsIdCols(boolean hasMapsIdCols) {
        this._hasMapsIdCols = hasMapsIdCols;
    }

    public boolean hasMapsIdCols() {
        return this._hasMapsIdCols;
    }
}

