/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.calendar;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import org.apache.openmeetings.db.entity.calendar.MeetingMember;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.red5.logging.Red5LoggerFactory;
import org.slf4j.Logger;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class MeetingMemberDao {
    private static final Logger log = Red5LoggerFactory.getLogger(MeetingMemberDao.class, (String)OpenmeetingsVariables.webAppRootKey);
    @PersistenceContext
    private EntityManager em;

    public MeetingMember get(Long meetingMemberId) {
        MeetingMember meetingMember = null;
        try {
            meetingMember = (MeetingMember)this.em.createNamedQuery("getMeetingMemberById", MeetingMember.class).setParameter("id", (Object)meetingMemberId).getSingleResult();
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
        return meetingMember;
    }

    public List<MeetingMember> getMeetingMembers() {
        return this.em.createNamedQuery("getMeetingMembers", MeetingMember.class).getResultList();
    }

    public Set<Long> getMeetingMemberIdsByAppointment(Long appointmentId) {
        log.debug("getMeetingMemberIdsByAppointment: " + appointmentId);
        return new HashSet<Long>(this.em.createNamedQuery("getMeetingMemberIdsByAppointment", Long.class).setParameter("id", (Object)appointmentId).getResultList());
    }

    public MeetingMember update(MeetingMember meetingMember) {
        if (meetingMember.getId() == null) {
            this.em.persist((Object)meetingMember);
        } else if (!this.em.contains((Object)meetingMember)) {
            meetingMember = (MeetingMember)this.em.merge((Object)meetingMember);
        }
        return meetingMember;
    }
}

