/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.record;

import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.openmeetings.db.entity.record.Recording;
import org.apache.openmeetings.db.entity.record.RecordingLog;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.util.process.ConverterProcessResult;
import org.red5.logging.Red5LoggerFactory;
import org.slf4j.Logger;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class RecordingLogDao {
    private static final Logger log = Red5LoggerFactory.getLogger(RecordingLogDao.class, (String)OpenmeetingsVariables.webAppRootKey);
    @PersistenceContext
    private EntityManager em;

    public long countErrors(Long recordingId) {
        return (Long)this.em.createNamedQuery("countErrorRecordingLogsByRecording", Long.class).setParameter("recId", (Object)recordingId).getSingleResult();
    }

    public List<RecordingLog> getByRecordingId(Long recordingId) {
        return this.em.createNamedQuery("getRecordingLogsByRecording", RecordingLog.class).setParameter("recId", (Object)recordingId).getResultList();
    }

    public void deleteByRecordingId(Long recordingId) {
        this.em.createNamedQuery("deleteErrorRecordingLogsByRecording").setParameter("recId", (Object)recordingId).executeUpdate();
    }

    public Long add(String msgType, Recording recording, ConverterProcessResult returnMap) {
        try {
            RecordingLog log = new RecordingLog();
            log.setInserted(new Date());
            log.setExitValue(returnMap.getExitValue());
            log.setRecording(recording);
            log.setFullMessage(returnMap.buildLogMessage());
            log.setMsgType(msgType);
            log = (RecordingLog)this.em.merge((Object)log);
            Long logId = log.getId();
            return logId;
        }
        catch (Exception ex2) {
            log.error("[add]: ", (Throwable)ex2);
            return -1L;
        }
    }
}

