/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dto.room;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.openmeetings.db.dao.room.RoomDao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.room.Invitation;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.util.crypt.CryptProvider;
import org.red5.logging.Red5LoggerFactory;
import org.slf4j.Logger;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class InvitationDTO
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Red5LoggerFactory.getLogger(InvitationDTO.class, (String)OpenmeetingsVariables.webAppRootKey);
    private static ThreadLocal<SimpleDateFormat> SDF = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };
    private String email;
    private String firstname;
    private String lastname;
    private String message;
    private String subject;
    private Long roomId;
    private boolean passwordProtected;
    private String password;
    private Invitation.Valid valid;
    private String validFrom;
    private String validTo;
    private long languageId;

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getFirstname() {
        return this.firstname;
    }

    public void setFirstname(String firstname) {
        this.firstname = firstname;
    }

    public String getLastname() {
        return this.lastname;
    }

    public void setLastname(String lastname) {
        this.lastname = lastname;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public Long getRoomId() {
        return this.roomId;
    }

    public void setRoomId(Long roomId) {
        this.roomId = roomId;
    }

    public boolean isPasswordProtected() {
        return this.passwordProtected;
    }

    public void setPasswordProtected(boolean passwordProtected) {
        this.passwordProtected = passwordProtected;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Invitation.Valid getValid() {
        return this.valid;
    }

    public void setValid(Invitation.Valid valid) {
        this.valid = valid;
    }

    public String getValidFrom() {
        return this.validFrom;
    }

    public void setValidFrom(String validFrom) {
        this.validFrom = validFrom;
    }

    public String getValidTo() {
        return this.validTo;
    }

    public void setValidTo(String validTo) {
        this.validTo = validTo;
    }

    public long getLanguageId() {
        return this.languageId;
    }

    public void setLanguageId(long languageId) {
        this.languageId = languageId;
    }

    public Invitation get(Long userId, UserDao userDao, RoomDao roomDao) {
        Invitation i = new Invitation();
        i.setHash(UUID.randomUUID().toString());
        i.setPasswordProtected(this.passwordProtected);
        if (this.passwordProtected) {
            i.setPassword(CryptProvider.get().hash(this.password));
        }
        i.setUsed(false);
        i.setValid(this.valid);
        try {
            switch (this.valid) {
                case Period: {
                    i.setValidFrom(new Date(SDF.get().parse(this.validFrom).getTime() - 300000L));
                    i.setValidTo(SDF.get().parse(this.validTo));
                    break;
                }
            }
        }
        catch (ParseException e) {
            log.error("Unexpected error while creating invitation", (Throwable)e);
            throw new RuntimeException(e);
        }
        i.setDeleted(false);
        i.setInvitedBy(userDao.get(userId));
        i.setInvitee(userDao.getContact(this.email, this.firstname, this.lastname, userId));
        if (User.Type.contact == i.getInvitee().getType()) {
            i.getInvitee().setLanguageId(this.languageId);
        }
        i.setRoom(roomDao.get(this.roomId));
        i.setInserted(new Date());
        i.setAppointment(null);
        return i;
    }
}

