/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dto.room;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.openmeetings.db.dto.room.RoomOptionsDTO;
import org.apache.openmeetings.db.entity.room.Room;
import org.apache.wicket.ajax.json.JSONObject;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RoomDTO
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long id;
    private String name;
    private String comment;
    private Room.Type type;
    private Long numberOfPartizipants = new Long(4L);
    private boolean appointment;
    private String confno;
    private boolean isPublic;
    private boolean demo;
    private boolean closed;
    private Integer demoTime;
    private String externalId;
    private String externalType;
    private String redirectUrl;
    private boolean moderated;
    private boolean allowUserQuestions;
    private boolean allowRecording;
    private boolean waitForRecording;
    private boolean audioOnly;
    private boolean topBarHidden;
    private boolean chatHidden;
    private boolean activitiesHidden;
    private boolean filesExplorerHidden;
    private boolean actionsMenuHidden;
    private boolean screenSharingHidden;
    private boolean whiteboardHidden;

    public RoomDTO() {
    }

    public RoomDTO(Room r) {
        this.id = r.getId();
        this.name = r.getName();
        this.comment = r.getComment();
        this.type = r.getType();
        this.numberOfPartizipants = r.getNumberOfPartizipants();
        this.appointment = r.isAppointment();
        this.confno = r.getConfno();
        this.isPublic = r.getIspublic();
        this.demo = r.isDemoRoom();
        this.closed = r.isClosed();
        this.demoTime = r.getDemoTime();
        this.externalId = r.getExternalId();
        this.externalType = r.getExternalType();
        this.redirectUrl = r.getRedirectURL();
        this.moderated = r.isModerated();
        this.allowUserQuestions = r.getAllowUserQuestions();
        this.allowRecording = r.isAllowRecording();
        this.waitForRecording = r.getWaitForRecording();
        this.audioOnly = r.isAudioOnly();
        this.topBarHidden = r.getHideTopBar();
        this.chatHidden = r.isChatHidden();
        this.activitiesHidden = r.isActivitiesHidden();
        this.filesExplorerHidden = r.getHideFilesExplorer();
        this.actionsMenuHidden = r.getHideActionsMenu();
        this.screenSharingHidden = r.getHideScreenSharing();
        this.whiteboardHidden = r.getHideWhiteboard();
    }

    public Room get() {
        Room r = new Room();
        r.setId(this.id);
        r.setName(this.name);
        r.setComment(this.comment);
        r.setType(this.type);
        r.setNumberOfPartizipants(this.numberOfPartizipants);
        r.setAppointment(this.appointment);
        r.setConfno(this.confno);
        r.setIspublic(this.isPublic);
        r.setDemoRoom(this.demo);
        r.setDemoTime(this.demoTime);
        r.setExternalId(this.externalId);
        r.setExternalType(this.externalType);
        r.setRedirectURL(this.redirectUrl);
        r.setModerated(this.moderated);
        r.setAllowUserQuestions(this.allowUserQuestions);
        r.setAllowRecording(this.allowRecording);
        r.setWaitForRecording(this.waitForRecording);
        r.setAudioOnly(this.audioOnly);
        r.setHideTopBar(this.topBarHidden);
        r.setChatHidden(this.chatHidden);
        r.setActivitiesHidden(this.activitiesHidden);
        r.setHideFilesExplorer(this.filesExplorerHidden);
        r.setHideActionsMenu(this.actionsMenuHidden);
        r.setHideScreenSharing(this.screenSharingHidden);
        r.setHideWhiteboard(this.whiteboardHidden);
        return r;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Room.Type getType() {
        return this.type;
    }

    public void setType(Room.Type type) {
        this.type = type;
    }

    public Long getNumberOfPartizipants() {
        return this.numberOfPartizipants;
    }

    public void setNumberOfPartizipants(Long numberOfPartizipants) {
        this.numberOfPartizipants = numberOfPartizipants;
    }

    public boolean isAppointment() {
        return this.appointment;
    }

    public void setAppointment(boolean appointment) {
        this.appointment = appointment;
    }

    public String getConfno() {
        return this.confno;
    }

    public void setConfno(String confno) {
        this.confno = confno;
    }

    public boolean isDemo() {
        return this.demo;
    }

    public void setDemo(boolean demo) {
        this.demo = demo;
    }

    public Integer getDemoTime() {
        return this.demoTime;
    }

    public void setDemoTime(Integer demoTime) {
        this.demoTime = demoTime;
    }

    public boolean isModerated() {
        return this.moderated;
    }

    public void setModerated(boolean moderated) {
        this.moderated = moderated;
    }

    public boolean isAllowUserQuestions() {
        return this.allowUserQuestions;
    }

    public void setAllowUserQuestions(boolean allowUserQuestions) {
        this.allowUserQuestions = allowUserQuestions;
    }

    public boolean isAllowRecording() {
        return this.allowRecording;
    }

    public void setAllowRecording(boolean allowRecording) {
        this.allowRecording = allowRecording;
    }

    public boolean isWaitForRecording() {
        return this.waitForRecording;
    }

    public void setWaitForRecording(boolean waitForRecording) {
        this.waitForRecording = waitForRecording;
    }

    public boolean isAudioOnly() {
        return this.audioOnly;
    }

    public void setAudioOnly(boolean audioOnly) {
        this.audioOnly = audioOnly;
    }

    public boolean isTopBarHidden() {
        return this.topBarHidden;
    }

    public void setTopBarHidden(boolean topBarHidden) {
        this.topBarHidden = topBarHidden;
    }

    public boolean isChatHidden() {
        return this.chatHidden;
    }

    public void setChatHidden(boolean chatHidden) {
        this.chatHidden = chatHidden;
    }

    public boolean isActivitiesHidden() {
        return this.activitiesHidden;
    }

    public void setActivitiesHidden(boolean activitiesHidden) {
        this.activitiesHidden = activitiesHidden;
    }

    public boolean isFilesExplorerHidden() {
        return this.filesExplorerHidden;
    }

    public void setFilesExplorerHidden(boolean filesExplorerHidden) {
        this.filesExplorerHidden = filesExplorerHidden;
    }

    public boolean isActionsMenuHidden() {
        return this.actionsMenuHidden;
    }

    public void setActionsMenuHidden(boolean actionsMenuHidden) {
        this.actionsMenuHidden = actionsMenuHidden;
    }

    public boolean isScreenSharingHidden() {
        return this.screenSharingHidden;
    }

    public void setScreenSharingHidden(boolean screenSharingHidden) {
        this.screenSharingHidden = screenSharingHidden;
    }

    public boolean isWhiteboardHidden() {
        return this.whiteboardHidden;
    }

    public void setWhiteboardHidden(boolean whiteboardHidden) {
        this.whiteboardHidden = whiteboardHidden;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public String getExternalType() {
        return this.externalType;
    }

    public void setExternalType(String externalType) {
        this.externalType = externalType;
    }

    public String getRedirectUrl() {
        return this.redirectUrl;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public static List<RoomDTO> list(List<Room> l) {
        ArrayList<RoomDTO> rList = new ArrayList<RoomDTO>();
        if (l != null) {
            for (Room r : l) {
                rList.add(new RoomDTO(r));
            }
        }
        return rList;
    }

    public static RoomDTO fromString(String s) {
        JSONObject o = new JSONObject(s);
        RoomDTO r = new RoomDTO();
        r.id = RoomOptionsDTO.optLong(o, "id");
        r.name = o.optString("name");
        r.comment = o.optString("comment");
        r.type = Room.Type.valueOf(o.getString("type"));
        r.numberOfPartizipants = o.optLong("numberOfPartizipants", 4L);
        r.appointment = o.optBoolean("appointment", false);
        r.confno = o.optString("confno");
        r.isPublic = o.optBoolean("isPublic", false);
        r.demo = o.optBoolean("demo", false);
        r.closed = o.optBoolean("closed", false);
        r.demoTime = RoomOptionsDTO.optInt(o, "demoTime");
        r.externalId = o.optString("externalId");
        r.externalType = o.optString("externalType");
        r.redirectUrl = o.optString("redirectUrl");
        r.moderated = o.optBoolean("moderated", false);
        r.allowUserQuestions = o.optBoolean("allowUserQuestions", false);
        r.allowRecording = o.optBoolean("allowRecording", false);
        r.waitForRecording = o.optBoolean("waitForRecording", false);
        r.audioOnly = o.optBoolean("audioOnly", false);
        r.topBarHidden = o.optBoolean("topBarHidden", false);
        r.chatHidden = o.optBoolean("chatHidden", false);
        r.activitiesHidden = o.optBoolean("activitiesHidden", false);
        r.filesExplorerHidden = o.optBoolean("filesExplorerHidden", false);
        r.actionsMenuHidden = o.optBoolean("actionsMenuHidden", false);
        r.screenSharingHidden = o.optBoolean("screenSharingHidden", false);
        r.whiteboardHidden = o.optBoolean("whiteboardHidden", false);
        return r;
    }

    public String toString() {
        return new JSONObject((Object)this).toString();
    }
}

