/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.room;

import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.openmeetings.db.entity.room.Invitation;
import org.apache.openmeetings.util.CalendarHelper;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.red5.logging.Red5LoggerFactory;
import org.slf4j.Logger;
import org.springframework.transaction.annotation.Transactional;
import org.threeten.bp.LocalDateTime;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZonedDateTime;
import org.threeten.bp.chrono.ChronoLocalDateTime;

@Transactional
public class InvitationDao {
    private static final Logger log = Red5LoggerFactory.getLogger(InvitationDao.class, (String)OpenmeetingsVariables.webAppRootKey);
    @PersistenceContext
    private EntityManager em;

    public Invitation update(Invitation invitation) {
        if (invitation.getId() == null) {
            invitation.setInserted(new Date());
            this.em.persist((Object)invitation);
        } else {
            invitation.setUpdated(new Date());
            invitation = (Invitation)this.em.merge((Object)invitation);
        }
        return invitation;
    }

    public Invitation get(Long invId) {
        try {
            TypedQuery query = this.em.createNamedQuery("getInvitationbyId", Invitation.class);
            query.setParameter("id", (Object)invId);
            try {
                return (Invitation)query.getSingleResult();
            }
            catch (NoResultException noResultException) {
            }
        }
        catch (Exception e) {
            log.error("get : ", (Throwable)e);
        }
        return null;
    }

    public Invitation getByHash(String hash, boolean hidePass, boolean markUsed) {
        Invitation i;
        List list = this.em.createNamedQuery("getInvitationByHashCode", Invitation.class).setParameter("hashCode", (Object)hash).getResultList();
        Invitation invitation = i = list != null && list.size() == 1 ? (Invitation)list.get(0) : null;
        if (i != null) {
            switch (i.getValid()) {
                case OneTime: {
                    i.setAllowEntry(!i.isUsed());
                    if (!markUsed) break;
                    i.setUsed(true);
                    this.update(i);
                    break;
                }
                case Period: {
                    LocalDateTime now = ZonedDateTime.now((ZoneId)CalendarHelper.getZoneId((String)i.getInvitee().getTimeZoneId())).toLocalDateTime();
                    LocalDateTime from = CalendarHelper.getDateTime((Date)i.getValidFrom(), (String)i.getInvitee().getTimeZoneId());
                    LocalDateTime to = CalendarHelper.getDateTime((Date)i.getValidTo(), (String)i.getInvitee().getTimeZoneId());
                    i.setAllowEntry(now.isAfter((ChronoLocalDateTime)from) && now.isBefore((ChronoLocalDateTime)to));
                    break;
                }
                default: {
                    i.setAllowEntry(true);
                }
            }
            this.em.detach((Object)i);
            if (hidePass) {
                i.setPassword(null);
            }
        }
        return i;
    }
}

