/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.room;

import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.openmeetings.db.entity.room.RoomGroup;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class RoomGroupDao {
    @PersistenceContext
    private EntityManager em;

    public List<RoomGroup> get() {
        return this.em.createNamedQuery("getAllRoomGroups", RoomGroup.class).getResultList();
    }

    public RoomGroup update(RoomGroup entity, Long userId) {
        if (entity.getId() == null) {
            entity.setInserted(new Date());
            this.em.persist((Object)entity);
        } else {
            entity.setUpdated(new Date());
            entity = (RoomGroup)this.em.merge((Object)entity);
        }
        return entity;
    }

    public RoomGroup get(long groupId, long roomId) {
        List ll = this.em.createNamedQuery("getRoomGroupByGroupIdAndRoomId", RoomGroup.class).setParameter("roomId", (Object)roomId).setParameter("groupId", (Object)groupId).getResultList();
        if (ll.size() > 0) {
            return (RoomGroup)ll.get(0);
        }
        return null;
    }
}

