/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.entity.file;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.LongId;
import org.apache.openmeetings.db.entity.file.FileItem;
import org.apache.openmeetings.util.OmFileHelper;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;

@Entity
@NamedQueries(value={@NamedQuery(name="getAllFiles", query="SELECT c FROM FileExplorerItem c ORDER BY c.id"), @NamedQuery(name="getFileById", query="SELECT c FROM FileExplorerItem c WHERE c.id = :id"), @NamedQuery(name="getFileByHash", query="SELECT c FROM FileExplorerItem c WHERE c.hash = :hash"), @NamedQuery(name="getFilesByRoomAndOwner", query="SELECT c FROM FileExplorerItem c WHERE c.deleted = false  AND c.roomId = :roomId AND c.ownerId = :ownerId ORDER BY c.type ASC, c.name "), @NamedQuery(name="getFilesByRoom", query="SELECT c FROM FileExplorerItem c WHERE c.deleted = false AND c.roomId = :roomId AND c.ownerId IS NULL AND c.parentId IS NULL ORDER BY c.type ASC, c.name "), @NamedQuery(name="getFilesByOwner", query="SELECT c FROM FileExplorerItem c WHERE c.deleted = false AND c.ownerId = :ownerId AND c.parentId IS NULL ORDER BY c.type ASC, c.name "), @NamedQuery(name="getFilesByParent", query="SELECT c FROM FileExplorerItem c WHERE c.deleted = false AND c.parentId = :parentId ORDER BY c.type ASC, c.name "), @NamedQuery(name="getFileExternal", query="SELECT c FROM FileExplorerItem c WHERE c.externalId = :externalId AND c.externalType LIKE :externalType")})
@Table(name="fileexploreritem")
@Root
public class FileExplorerItem
extends FileItem
implements PersistenceCapable {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    @Element(data=true, name="fileExplorerItemId")
    private Long id;
    @Column(name="filesize")
    @Element(data=true, required=false)
    private Long size;
    @Column(name="external_id")
    private String externalId;
    @Column(name="external_type")
    private String externalType;
    private static int pcInheritedFieldCount = FileItem.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Lorg$apache$openmeetings$db$entity$file$FileItem;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Ljava$lang$Long;
    static /* synthetic */ Class class$Lorg$apache$openmeetings$db$entity$file$FileExplorerItem;

    @Override
    public Long getId() {
        return FileExplorerItem.pcGetid(this);
    }

    @Override
    public void setId(Long id) {
        FileExplorerItem.pcSetid(this, id);
    }

    public Long getSize() {
        return FileExplorerItem.pcGetsize(this);
    }

    public void setSize(Long fileSize) {
        FileExplorerItem.pcSetsize(this, fileSize);
    }

    public String getExternalId() {
        return FileExplorerItem.pcGetexternalId(this);
    }

    public void setExternalId(String externalId) {
        FileExplorerItem.pcSetexternalId(this, externalId);
    }

    public String getExternalType() {
        return FileExplorerItem.pcGetexternalType(this);
    }

    public void setExternalType(String externalType) {
        FileExplorerItem.pcSetexternalType(this, externalType);
    }

    @Override
    protected File internalGetFile(String ext) {
        File f = null;
        switch (this.getType()) {
            case WmlFile: {
                f = new File(OmFileHelper.getUploadWmlDir(), String.format("%s.%s", this.getHash(), ext == null ? "wml" : ext));
                break;
            }
            case Image: {
                f = new File(OmFileHelper.getUploadFilesDir(), String.format("%s.%s", this.getHash(), ext == null ? "jpg" : ext));
                break;
            }
            case Video: {
                f = new File(OmFileHelper.getStreamsHibernateDir(), String.format("%s%s.%s", "UPLOADFLV_", this.getId(), ext == null ? "mp4" : ext));
                break;
            }
            case Presentation: {
                File d = new File(OmFileHelper.getUploadFilesDir(), this.getHash());
                f = new File(d, String.format("%s.%s", this.getHash(), ext == null ? "swf" : ext));
                break;
            }
        }
        return f;
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 2;
    }

    static {
        Class clazz = class$Lorg$apache$openmeetings$db$entity$file$FileItem != null ? class$Lorg$apache$openmeetings$db$entity$file$FileItem : (class$Lorg$apache$openmeetings$db$entity$file$FileItem = FileExplorerItem.class$("org.apache.openmeetings.db.entity.file.FileItem"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"externalId", "externalType", "id", "size"};
        Class[] classArray = new Class[4];
        Class clazz2 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = FileExplorerItem.class$("java.lang.String"));
        classArray[0] = clazz2;
        classArray[1] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = FileExplorerItem.class$("java.lang.String"));
        Class clazz3 = class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = FileExplorerItem.class$("java.lang.Long"));
        classArray[2] = clazz3;
        classArray[3] = class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = FileExplorerItem.class$("java.lang.Long"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 26};
        Class clazz4 = class$Lorg$apache$openmeetings$db$entity$file$FileExplorerItem != null ? class$Lorg$apache$openmeetings$db$entity$file$FileExplorerItem : (class$Lorg$apache$openmeetings$db$entity$file$FileExplorerItem = FileExplorerItem.class$("org.apache.openmeetings.db.entity.file.FileExplorerItem"));
        PCRegistry.register((Class)clazz4, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"FileExplorerItem", (PersistenceCapable)new FileExplorerItem());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.externalId = null;
        this.externalType = null;
        this.id = null;
        this.size = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        FileExplorerItem fileExplorerItem = new FileExplorerItem();
        if (bl) {
            fileExplorerItem.pcClearFields();
        }
        fileExplorerItem.pcStateManager = stateManager;
        fileExplorerItem.pcCopyKeyFieldsFromObjectId(object);
        return fileExplorerItem;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        FileExplorerItem fileExplorerItem = new FileExplorerItem();
        if (bl) {
            fileExplorerItem.pcClearFields();
        }
        fileExplorerItem.pcStateManager = stateManager;
        return fileExplorerItem;
    }

    protected static int pcGetManagedFieldCount() {
        return 4 + FileItem.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.externalId = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.externalType = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.id = (Long)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.size = (Long)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.externalId);
                return;
            }
            case 1: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.externalType);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.id);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.size);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(FileExplorerItem fileExplorerItem, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(fileExplorerItem, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.externalId = fileExplorerItem.externalId;
                return;
            }
            case 1: {
                this.externalType = fileExplorerItem.externalType;
                return;
            }
            case 2: {
                this.id = fileExplorerItem.id;
                return;
            }
            case 3: {
                this.size = fileExplorerItem.size;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        FileExplorerItem fileExplorerItem = (FileExplorerItem)object;
        if (fileExplorerItem.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(fileExplorerItem, nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    @Override
    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    @Override
    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        super.pcCopyKeyFieldsFromObjectId(fieldConsumer, object);
        LongId longId = (LongId)object;
        fieldConsumer.storeObjectField(2 + pcInheritedFieldCount, (Object)new Long(longId.getId()));
    }

    @Override
    public void pcCopyKeyFieldsFromObjectId(Object object) {
        super.pcCopyKeyFieldsFromObjectId(object);
        LongId longId = (LongId)object;
        this.id = new Long(longId.getId());
    }

    @Override
    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$openmeetings$db$entity$file$FileExplorerItem != null ? class$Lorg$apache$openmeetings$db$entity$file$FileExplorerItem : (class$Lorg$apache$openmeetings$db$entity$file$FileExplorerItem = FileExplorerItem.class$("org.apache.openmeetings.db.entity.file.FileExplorerItem"));
        return new LongId(clazz, (String)object);
    }

    @Override
    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$openmeetings$db$entity$file$FileExplorerItem != null ? class$Lorg$apache$openmeetings$db$entity$file$FileExplorerItem : (class$Lorg$apache$openmeetings$db$entity$file$FileExplorerItem = FileExplorerItem.class$("org.apache.openmeetings.db.entity.file.FileExplorerItem"));
        return new LongId(clazz, this.id);
    }

    private static final String pcGetexternalId(FileExplorerItem fileExplorerItem) {
        if (fileExplorerItem.pcStateManager == null) {
            return fileExplorerItem.externalId;
        }
        int n = pcInheritedFieldCount + 0;
        fileExplorerItem.pcStateManager.accessingField(n);
        return fileExplorerItem.externalId;
    }

    private static final void pcSetexternalId(FileExplorerItem fileExplorerItem, String string) {
        if (fileExplorerItem.pcStateManager == null) {
            fileExplorerItem.externalId = string;
            return;
        }
        fileExplorerItem.pcStateManager.settingStringField((PersistenceCapable)fileExplorerItem, pcInheritedFieldCount + 0, fileExplorerItem.externalId, string, 0);
    }

    private static final String pcGetexternalType(FileExplorerItem fileExplorerItem) {
        if (fileExplorerItem.pcStateManager == null) {
            return fileExplorerItem.externalType;
        }
        int n = pcInheritedFieldCount + 1;
        fileExplorerItem.pcStateManager.accessingField(n);
        return fileExplorerItem.externalType;
    }

    private static final void pcSetexternalType(FileExplorerItem fileExplorerItem, String string) {
        if (fileExplorerItem.pcStateManager == null) {
            fileExplorerItem.externalType = string;
            return;
        }
        fileExplorerItem.pcStateManager.settingStringField((PersistenceCapable)fileExplorerItem, pcInheritedFieldCount + 1, fileExplorerItem.externalType, string, 0);
    }

    private static final Long pcGetid(FileExplorerItem fileExplorerItem) {
        if (fileExplorerItem.pcStateManager == null) {
            return fileExplorerItem.id;
        }
        int n = pcInheritedFieldCount + 2;
        fileExplorerItem.pcStateManager.accessingField(n);
        return fileExplorerItem.id;
    }

    private static final void pcSetid(FileExplorerItem fileExplorerItem, Long l) {
        if (fileExplorerItem.pcStateManager == null) {
            fileExplorerItem.id = l;
            return;
        }
        fileExplorerItem.pcStateManager.settingObjectField((PersistenceCapable)fileExplorerItem, pcInheritedFieldCount + 2, (Object)fileExplorerItem.id, (Object)l, 0);
    }

    private static final Long pcGetsize(FileExplorerItem fileExplorerItem) {
        if (fileExplorerItem.pcStateManager == null) {
            return fileExplorerItem.size;
        }
        int n = pcInheritedFieldCount + 3;
        fileExplorerItem.pcStateManager.accessingField(n);
        return fileExplorerItem.size;
    }

    private static final void pcSetsize(FileExplorerItem fileExplorerItem, Long l) {
        if (fileExplorerItem.pcStateManager == null) {
            fileExplorerItem.size = l;
            return;
        }
        fileExplorerItem.pcStateManager.settingObjectField((PersistenceCapable)fileExplorerItem, pcInheritedFieldCount + 3, (Object)fileExplorerItem.size, (Object)l, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

