/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.file;

import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.openmeetings.db.entity.file.FileExplorerItem;
import org.apache.openmeetings.db.entity.file.FileItem;
import org.apache.openmeetings.util.OmFileHelper;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.red5.logging.Red5LoggerFactory;
import org.slf4j.Logger;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class FileExplorerItemDao {
    private static final Logger log = Red5LoggerFactory.getLogger(FileExplorerItemDao.class, (String)OpenmeetingsVariables.webAppRootKey);
    @PersistenceContext
    private EntityManager em;

    public FileExplorerItem add(String fileName, Long parentId, Long ownerId, Long roomId, Long insertedBy, FileItem.Type type, String externalId, String externalType) {
        log.debug(".add(): adding file " + fileName + " roomID: " + roomId);
        try {
            FileExplorerItem fileItem = new FileExplorerItem();
            fileItem.setName(fileName);
            fileItem.setHash(UUID.randomUUID().toString());
            fileItem.setDeleted(false);
            fileItem.setParentId(parentId);
            fileItem.setOwnerId(ownerId);
            fileItem.setRoomId(roomId);
            fileItem.setInserted(new Date());
            fileItem.setInsertedBy(insertedBy);
            fileItem.setType(type);
            fileItem.setUpdated(new Date());
            fileItem.setExternalId(externalId);
            fileItem.setExternalType(externalType);
            fileItem = (FileExplorerItem)this.em.merge((Object)fileItem);
            log.debug(".add(): file " + fileName + " added as " + fileItem.getId());
            return fileItem;
        }
        catch (Exception ex2) {
            log.error(".add(): ", (Throwable)ex2);
            return null;
        }
    }

    public List<FileExplorerItem> getFileExplorerItemsByRoomAndOwner(Long roomId, Long ownerId) {
        log.debug(".getFileExplorerItemsByRoomAndOwner() started");
        try {
            TypedQuery query = this.em.createNamedQuery("getFilesByRoomAndOwner", FileExplorerItem.class);
            query.setParameter("roomId", (Object)roomId);
            query.setParameter("ownerId", (Object)ownerId);
            List fileExplorerList = query.getResultList();
            return fileExplorerList;
        }
        catch (Exception ex2) {
            log.error("[getFileExplorerItemsByRoomAndOwner]: ", (Throwable)ex2);
            return null;
        }
    }

    public List<FileExplorerItem> getByRoom(Long roomId) {
        log.debug("getFileExplorerItemsByRoom roomId :: " + roomId);
        return this.em.createNamedQuery("getFilesByRoom", FileExplorerItem.class).setParameter("roomId", (Object)roomId).getResultList();
    }

    public List<FileExplorerItem> getByOwner(Long ownerId) {
        log.debug("getByOwner() started");
        TypedQuery query = this.em.createNamedQuery("getFilesByOwner", FileExplorerItem.class);
        query.setParameter("ownerId", (Object)ownerId);
        return query.getResultList();
    }

    public List<FileExplorerItem> getByParent(Long parentId) {
        log.debug("getByParent() started");
        TypedQuery query = this.em.createNamedQuery("getFilesByParent", FileExplorerItem.class);
        query.setParameter("parentId", (Object)parentId);
        return query.getResultList();
    }

    public FileExplorerItem getByHash(String hash) {
        log.debug("getByHash() started");
        FileExplorerItem f = null;
        TypedQuery query = this.em.createNamedQuery("getFileByHash", FileExplorerItem.class);
        query.setParameter("hash", (Object)hash);
        try {
            f = (FileExplorerItem)query.getSingleResult();
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
        return f;
    }

    public FileExplorerItem get(Long id) {
        FileExplorerItem f = null;
        if (id != null && id > 0L) {
            TypedQuery query = this.em.createNamedQuery("getFileById", FileExplorerItem.class).setParameter("id", (Object)id);
            try {
                f = (FileExplorerItem)query.getSingleResult();
            }
            catch (NoResultException noResultException) {}
        } else {
            log.info("[get] Info: No id given");
        }
        return f;
    }

    public FileExplorerItem get(String externalId, String externalType) {
        FileExplorerItem f = null;
        log.debug("get started");
        try {
            TypedQuery query = this.em.createNamedQuery("getFileExternal", FileExplorerItem.class).setParameter("externalFileId", (Object)externalId).setParameter("externalType", (Object)externalType);
            try {
                f = (FileExplorerItem)query.getSingleResult();
            }
            catch (NoResultException noResultException) {}
        }
        catch (Exception ex2) {
            log.error("[get]: ", (Throwable)ex2);
        }
        return f;
    }

    public List<FileExplorerItem> get() {
        log.debug("get started");
        return this.em.createNamedQuery("getAllFiles", FileExplorerItem.class).getResultList();
    }

    public void delete(FileExplorerItem f) {
        f.setDeleted(true);
        f.setUpdated(new Date());
        this.update(f);
    }

    public void delete(String externalId, String externalType) {
        log.debug("delete started");
        this.delete(this.get(externalId, externalType));
    }

    public FileExplorerItem rename(Long id, String name) {
        log.debug("rename started");
        FileExplorerItem f = this.get(id);
        if (f == null) {
            return null;
        }
        f.setName(name);
        return this.update(f);
    }

    public FileExplorerItem update(FileExplorerItem f) {
        if (f.getId() == null) {
            f.setInserted(new Date());
            this.em.persist((Object)f);
        } else {
            f.setUpdated(new Date());
            f = (FileExplorerItem)this.em.merge((Object)f);
        }
        return f;
    }

    private void updateChilds(FileExplorerItem f) {
        for (FileExplorerItem child : this.getByParent(f.getId())) {
            child.setOwnerId(f.getOwnerId());
            child.setRoomId(f.getRoomId());
            this.update(child);
            if (FileItem.Type.Folder != f.getType()) continue;
            this.updateChilds(child);
        }
    }

    public FileExplorerItem move(long id, long parentId, long ownerId, long roomId) {
        log.debug(".move() started");
        FileExplorerItem f = this.get(id);
        if (f == null) {
            return null;
        }
        if (parentId < 0L) {
            if (parentId == -1L) {
                f.setOwnerId(ownerId);
                f.setRoomId(null);
            } else {
                f.setOwnerId(null);
                f.setRoomId(roomId);
            }
            f.setParentId(null);
        } else {
            f.setParentId(parentId);
            f.setOwnerId(null);
        }
        if (FileItem.Type.Folder == f.getType()) {
            this.updateChilds(f);
        }
        return this.update(f);
    }

    public long getOwnSize(Long userId) {
        return this.getSize(this.getByOwner(userId));
    }

    public long getRoomSize(Long roomId) {
        return this.getSize(this.getByRoom(roomId));
    }

    public long getSize(List<FileExplorerItem> list) {
        long size = 0L;
        for (FileExplorerItem f : list) {
            log.debug("FileExplorerItem fList " + f.getName());
            size += this.getSize(f);
        }
        return size;
    }

    public long getSize(FileExplorerItem f) {
        long size = 0L;
        try {
            if (f.exists()) {
                File tFolder;
                File base = OmFileHelper.getUploadFilesDir();
                if (FileItem.Type.Image == f.getType()) {
                    size += f.getFile().length();
                    File thumbFile = new File(base, String.format("%s%s.%s", "_thumb_", f.getHash(), "jpg"));
                    if (thumbFile.exists()) {
                        size += thumbFile.length();
                    }
                }
                if (FileItem.Type.Presentation == f.getType() && (tFolder = new File(base, f.getHash())).exists()) {
                    size += OmFileHelper.getSize((File)tFolder);
                }
                if (FileItem.Type.Video == f.getType()) {
                    size += f.getFile().length();
                    File thumb = f.getFile("jpg");
                    if (thumb.exists()) {
                        size += thumb.length();
                    }
                }
            }
            if (FileItem.Type.Folder == f.getType()) {
                for (FileExplorerItem child : this.getByParent(f.getId())) {
                    size += this.getSize(child);
                }
            }
        }
        catch (Exception err) {
            log.error("[getSize] ", (Throwable)err);
        }
        return size;
    }
}

