/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.file;

import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.openmeetings.db.entity.file.FileItem;
import org.apache.openmeetings.db.entity.file.FileItemLog;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.util.process.ConverterProcessResult;
import org.red5.logging.Red5LoggerFactory;
import org.slf4j.Logger;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class FileItemLogDao {
    private static final Logger log = Red5LoggerFactory.getLogger(FileItemLogDao.class, (String)OpenmeetingsVariables.webAppRootKey);
    @PersistenceContext
    private EntityManager em;

    public long countErrors(FileItem f) {
        return (Long)this.em.createNamedQuery("countErrorFileLogsByFile", Long.class).setParameter("fileId", (Object)f.getId()).setParameter("type", (Object)f.getType()).getSingleResult();
    }

    public List<FileItemLog> get(FileItem f) {
        return this.em.createNamedQuery("getFileLogsByFile", FileItemLog.class).setParameter("fileId", (Object)f.getId()).setParameter("type", (Object)f.getType()).getResultList();
    }

    public void delete(FileItem f) {
        this.em.createNamedQuery("deleteErrorFileLogsByFile").setParameter("fileId", (Object)f.getId()).setParameter("type", (Object)f.getType()).executeUpdate();
    }

    public FileItemLog add(String name, FileItem f, ConverterProcessResult returnMap) {
        log.trace("Adding log: {}, {}, {}", new Object[]{name, f, returnMap});
        FileItemLog log = new FileItemLog();
        log.setInserted(new Date());
        log.setExitCode(returnMap.getExitCode());
        log.setFileId(f.getId());
        log.setFileType(f.getType());
        log.setMessage(returnMap.buildLogMessage());
        log.setName(name);
        this.em.persist((Object)log);
        return log;
    }
}

