/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.server;

import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.openmeetings.db.dao.IDataProviderDao;
import org.apache.openmeetings.db.dao.user.UserDao;
import org.apache.openmeetings.db.entity.server.Server;
import org.apache.openmeetings.util.DaoHelper;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.red5.logging.Red5LoggerFactory;
import org.slf4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class ServerDao
implements IDataProviderDao<Server> {
    private static final Logger log = Red5LoggerFactory.getLogger(ServerDao.class, (String)OpenmeetingsVariables.webAppRootKey);
    public static final String[] searchFields = new String[]{"name", "address", "comment"};
    @PersistenceContext
    private EntityManager em;
    @Autowired
    private UserDao userDao;

    public List<Server> getServerList() {
        log.debug("getServerList enter");
        TypedQuery q = this.em.createNamedQuery("getAllServers", Server.class);
        return q.getResultList();
    }

    @Override
    public List<Server> get(int start, int max) {
        TypedQuery q = this.em.createNamedQuery("getAllServers", Server.class);
        q.setFirstResult(start);
        q.setMaxResults(max);
        return q.getResultList();
    }

    @Override
    public List<Server> get(String search, int start, int count, String order) {
        TypedQuery q = this.em.createQuery(DaoHelper.getSearchQuery((String)"Server", (String)"s", (String)search, (boolean)true, (boolean)false, (String)order, (String[])searchFields), Server.class);
        q.setFirstResult(start);
        q.setMaxResults(count);
        return q.getResultList();
    }

    public List<Server> getActiveServers() {
        return this.em.createNamedQuery("getActiveServers", Server.class).getResultList();
    }

    @Override
    public long count() {
        log.debug("getServerCount enter");
        TypedQuery q = this.em.createNamedQuery("getServerCount", Long.class);
        return (Long)q.getSingleResult();
    }

    @Override
    public long count(String search) {
        TypedQuery q = this.em.createQuery(DaoHelper.getSearchQuery((String)"Server", (String)"s", (String)search, (boolean)true, (boolean)true, null, (String[])searchFields), Long.class);
        return (Long)q.getSingleResult();
    }

    @Override
    public Server get(long id) {
        return this.get((Long)id);
    }

    @Override
    public Server get(Long id) {
        Server result = null;
        log.debug("getServer enter, id = " + id);
        TypedQuery q = this.em.createNamedQuery("getServerById", Server.class);
        q.setParameter("id", (Object)id);
        try {
            result = (Server)q.getSingleResult();
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
        return result;
    }

    public Server getServerByAddress(String address) {
        log.debug("getServer enter, address = " + address);
        TypedQuery q = this.em.createNamedQuery("getServerByAddress", Server.class);
        q.setParameter("address", (Object)address);
        List list = q.getResultList();
        return list.size() > 0 ? (Server)list.get(0) : null;
    }

    @Override
    public Server update(Server entity, Long userId) {
        entity.setDeleted(false);
        if (entity.getId() == null) {
            entity.setInserted(new Date());
            if (userId != null) {
                entity.setInsertedby(this.userDao.get(userId));
            }
            this.em.persist((Object)entity);
        } else {
            entity.setUpdated(new Date());
            if (userId != null) {
                entity.setUpdatedby(this.userDao.get(userId));
            }
            this.em.merge((Object)entity);
        }
        return entity;
    }

    @Override
    public void delete(Server entity, Long userId) {
        if (entity.getId() != null) {
            entity.setUpdated(new Date());
            if (userId != null) {
                entity.setUpdatedby(this.userDao.get(userId));
            }
            entity.setDeleted(true);
            this.em.merge((Object)entity);
        }
    }

    public List<Server> getServersByName(String name) {
        TypedQuery q = this.em.createNamedQuery("getServerByName", Server.class);
        q.setParameter("name", (Object)name);
        return q.getResultList();
    }
}

