/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.util;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.openmeetings.IApplication;
import org.apache.openmeetings.IWebSession;
import org.apache.openmeetings.db.dao.label.LabelDao;
import org.apache.openmeetings.util.InitializationContainer;
import org.apache.openmeetings.util.OMContextListener;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.wicket.Application;
import org.apache.wicket.RuntimeConfigurationType;
import org.apache.wicket.ThreadContext;
import org.apache.wicket.mock.MockWebResponse;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.protocol.http.WebSession;
import org.apache.wicket.protocol.http.mock.MockHttpServletRequest;
import org.apache.wicket.protocol.http.mock.MockHttpSession;
import org.apache.wicket.protocol.http.mock.MockServletContext;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Response;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.cycle.RequestCycleContext;
import org.apache.wicket.util.tester.WicketTester;
import org.red5.logging.Red5LoggerFactory;
import org.slf4j.Logger;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class ApplicationHelper {
    private static final Logger log = Red5LoggerFactory.getLogger(ApplicationHelper.class, (String)OpenmeetingsVariables.webAppRootKey);

    public static WicketTester getWicketTester() {
        return ApplicationHelper.getWicketTester(-1L);
    }

    public static WicketTester getWicketTester(long langId) {
        WebApplication app = (WebApplication)ApplicationHelper.ensureApplication(langId);
        WicketTester tester = new WicketTester(app, app.getServletContext());
        InitializationContainer.initComplete = true;
        return tester;
    }

    public static void destroy(WicketTester tester) {
        if (tester != null) {
            ServletContext sc = tester.getServletContext();
            try {
                ((XmlWebApplicationContext)sc.getAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE)).close();
            }
            catch (Exception e) {
                log.error("Unexpected error while destroying XmlWebApplicationContext", (Throwable)e);
            }
            tester.destroy();
        }
    }

    public static IApplication ensureApplication() {
        return ApplicationHelper.ensureApplication(-1L);
    }

    public static IApplication ensureApplication(Long langId) {
        IApplication a = null;
        if (Application.exists()) {
            a = (IApplication)Application.get();
        } else {
            WebApplication app = (WebApplication)Application.get((String)OpenmeetingsVariables.wicketApplicationName);
            LabelDao.initLanguageMap();
            if (app == null) {
                try {
                    app = (WebApplication)LabelDao.getAppClass().newInstance();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    log.error("Failed to create Application");
                    return null;
                }
                app.setServletContext((ServletContext)new MockServletContext((Application)app, null));
                app.setName(OpenmeetingsVariables.wicketApplicationName);
                ServletContext sc = app.getServletContext();
                OMContextListener omcl = new OMContextListener();
                omcl.contextInitialized(new ServletContextEvent(sc));
                XmlWebApplicationContext xmlContext = new XmlWebApplicationContext();
                xmlContext.setConfigLocation("classpath:openmeetings-applicationContext.xml");
                xmlContext.setServletContext(sc);
                xmlContext.refresh();
                sc.setAttribute(WebApplicationContext.ROOT_WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)xmlContext);
                app.setConfigurationType(RuntimeConfigurationType.DEPLOYMENT);
                ThreadContext.setApplication((Application)app);
                app.initApplication();
            } else {
                ThreadContext.setApplication((Application)app);
            }
            a = (IApplication)Application.get((String)OpenmeetingsVariables.wicketApplicationName);
        }
        if (ThreadContext.getRequestCycle() == null) {
            ServletWebRequest req = new ServletWebRequest((HttpServletRequest)new MockHttpServletRequest((Application)a, (HttpSession)new MockHttpSession(a.getServletContext()), a.getServletContext()), "");
            RequestCycleContext rctx = new RequestCycleContext((Request)req, (Response)new MockWebResponse(), a.getRootRequestMapper(), a.getExceptionMapperProvider().get());
            ThreadContext.setRequestCycle((RequestCycle)new RequestCycle(rctx));
        }
        if (ThreadContext.getSession() == null) {
            WebSession s = WebSession.get();
            if (langId > 0L) {
                ((IWebSession)s).setLanguage(langId);
            }
        }
        return a;
    }

    public static void destroyApplication() {
        WebApplication app = (WebApplication)Application.get((String)OpenmeetingsVariables.wicketApplicationName);
        app.internalDestroy();
        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)app.getServletContext());
        ((XmlWebApplicationContext)ctx).destroy();
        ThreadContext.setApplication(null);
        ThreadContext.setRequestCycle(null);
        ThreadContext.setSession(null);
    }

    public static WebApplicationContext getApplicationContext(Long langId) {
        return WebApplicationContextUtils.getWebApplicationContext((ServletContext)((WebApplication)ApplicationHelper.ensureApplication(langId)).getServletContext());
    }
}

