/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.basic;

import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.openmeetings.db.dao.IDataProviderDao;
import org.apache.openmeetings.db.entity.basic.MailMessage;
import org.apache.wicket.util.string.Strings;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class MailMessageDao
implements IDataProviderDao<MailMessage> {
    @PersistenceContext
    private EntityManager em;

    @Override
    public MailMessage get(long id) {
        return this.get((Long)id);
    }

    @Override
    public MailMessage get(Long id) {
        return (MailMessage)this.em.createNamedQuery("getMailMessageById", MailMessage.class).setParameter("id", (Object)id).getSingleResult();
    }

    @Override
    public List<MailMessage> get(int start, int count) {
        return this.em.createNamedQuery("getMailMessages", MailMessage.class).setFirstResult(start).setMaxResults(count).getResultList();
    }

    public List<MailMessage> get(int start, int count, MailMessage.Status status) {
        return this.em.createNamedQuery("getMailMessagesByStatus", MailMessage.class).setParameter("status", (Object)status).setFirstResult(start).setMaxResults(count).getResultList();
    }

    private <T> TypedQuery<T> getQuery(boolean isCount, String search, String order, Class<T> clazz) {
        StringBuilder sb = new StringBuilder("SELECT ");
        sb.append(isCount ? "COUNT(m)" : "m").append(" FROM MailMessage m");
        if (!Strings.isEmpty((CharSequence)search)) {
            sb.append(" WHERE m.recipients LIKE :search OR m.subject LIKE :search OR m.body LIKE :search OR m.lastError LIKE :search");
        }
        if (!Strings.isEmpty((CharSequence)order)) {
            sb.append(" ORDER BY m.").append(order);
        }
        TypedQuery q = this.em.createQuery(sb.toString(), clazz);
        if (!Strings.isEmpty((CharSequence)search)) {
            q.setParameter("search", (Object)String.format("%%%s%%", search));
        }
        return q;
    }

    @Override
    public List<MailMessage> get(String search, int start, int count, String order) {
        return this.getQuery(false, search, order, MailMessage.class).setFirstResult(start).setMaxResults(count).getResultList();
    }

    @Override
    public long count() {
        return (Long)this.em.createNamedQuery("countMailMessages", Long.class).getSingleResult();
    }

    @Override
    public long count(String search) {
        return (Long)this.getQuery(true, search, null, Long.class).getSingleResult();
    }

    public void resetSendingStatus(Calendar date) {
        this.em.createNamedQuery("resetMailStatusByDate").setParameter("noneStatus", (Object)MailMessage.Status.NONE).setParameter("sendingStatus", (Object)MailMessage.Status.SENDING).setParameter("date", (Object)date).executeUpdate();
    }

    public void resetSendingStatus(Long id) {
        this.em.createNamedQuery("resetMailStatusById").setParameter("noneStatus", (Object)MailMessage.Status.NONE).setParameter("id", (Object)id).executeUpdate();
    }

    @Override
    public MailMessage update(MailMessage m, Long userId) {
        if (m.getId() == null) {
            m.setInserted(new Date());
            this.em.persist((Object)m);
        } else {
            m.setUpdated(new Date());
            m = (MailMessage)this.em.merge((Object)m);
        }
        return m;
    }

    @Override
    public void delete(MailMessage m, Long userId) {
        if (m != null) {
            this.delete(m.getId());
        }
    }

    public void delete(Long id) {
        if (id != null) {
            this.em.remove((Object)this.get(id));
        }
    }
}

