/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.file;

import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.openmeetings.db.entity.file.BaseFileItem;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.red5.logging.Red5LoggerFactory;
import org.slf4j.Logger;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class BaseFileItemDao {
    private static final Logger log = Red5LoggerFactory.getLogger(BaseFileItemDao.class, (String)OpenmeetingsVariables.getWebAppRootKey());
    @PersistenceContext
    protected EntityManager em;

    public BaseFileItem get(String hash) {
        log.debug("getByHash() started");
        List list = this.em.createNamedQuery("getFileByHash", BaseFileItem.class).setParameter("hash", (Object)hash).getResultList();
        return list.size() == 1 ? (BaseFileItem)list.get(0) : null;
    }

    public BaseFileItem get(Long id) {
        List list = this.em.createNamedQuery("getFileById", BaseFileItem.class).setParameter("id", (Object)id).getResultList();
        return list.size() == 1 ? (BaseFileItem)list.get(0) : null;
    }

    public BaseFileItem getAny(Long id) {
        List list = this.em.createNamedQuery("getAnyFileById", BaseFileItem.class).setParameter("id", (Object)id).getResultList();
        return list.size() == 1 ? (BaseFileItem)list.get(0) : null;
    }

    public void delete(BaseFileItem f) {
        if (f == null || f.getId() == null) {
            return;
        }
        f.setDeleted(true);
        f.setUpdated(new Date());
        this._update(f);
    }

    public BaseFileItem _update(BaseFileItem f) {
        if (f.getId() == null) {
            f.setInserted(new Date());
            this.em.persist((Object)f);
        } else {
            f.setUpdated(new Date());
            f = (BaseFileItem)this.em.merge((Object)f);
        }
        return f;
    }
}

