/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.file;

import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.openmeetings.db.entity.file.BaseFileItem;
import org.apache.openmeetings.db.entity.file.FileItemLog;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.util.process.ProcessResult;
import org.red5.logging.Red5LoggerFactory;
import org.slf4j.Logger;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class FileItemLogDao {
    private static final Logger log = Red5LoggerFactory.getLogger(FileItemLogDao.class, (String)OpenmeetingsVariables.getWebAppRootKey());
    @PersistenceContext
    private EntityManager em;

    public long countErrors(BaseFileItem f) {
        return (Long)this.em.createNamedQuery("countErrorFileLogsByFile", Long.class).setParameter("fileId", (Object)f.getId()).getSingleResult();
    }

    public List<FileItemLog> get(BaseFileItem f) {
        return this.em.createNamedQuery("getFileLogsByFile", FileItemLog.class).setParameter("fileId", (Object)f.getId()).getResultList();
    }

    public void delete(BaseFileItem f) {
        this.em.createNamedQuery("deleteErrorFileLogsByFile").setParameter("fileId", (Object)f.getId()).executeUpdate();
    }

    public FileItemLog add(String name, BaseFileItem f, ProcessResult r) {
        log.trace("Adding log: {}, {}, {}", new Object[]{name, f, r});
        FileItemLog l = new FileItemLog().setInserted(new Date()).setExitCode(r.getExitCode()).setFileId(f.getId()).setMessage(r.buildLogMessage()).setName(name).setOptional(r.isOptional());
        this.em.persist((Object)l);
        return l;
    }
}

