/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.room;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.openmeetings.db.entity.room.Invitation;
import org.apache.openmeetings.util.CalendarHelper;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.wicket.util.string.Strings;
import org.red5.logging.Red5LoggerFactory;
import org.slf4j.Logger;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class InvitationDao {
    private static final Logger log = Red5LoggerFactory.getLogger(InvitationDao.class, (String)OpenmeetingsVariables.getWebAppRootKey());
    @PersistenceContext
    private EntityManager em;

    public Invitation update(Invitation invitation) {
        if (invitation.getId() == null) {
            invitation.setInserted(new Date());
            this.em.persist((Object)invitation);
        } else {
            invitation.setUpdated(new Date());
            invitation = (Invitation)this.em.merge((Object)invitation);
        }
        return invitation;
    }

    public Invitation get(Long invId) {
        List list = this.em.createNamedQuery("getInvitationbyId", Invitation.class).setParameter("id", (Object)invId).getResultList();
        return list.size() == 1 ? (Invitation)list.get(0) : null;
    }

    public Invitation getByHash(String hash, boolean hidePass, boolean markUsed) {
        Invitation i;
        List list = this.em.createNamedQuery("getInvitationByHashCode", Invitation.class).setParameter("hashCode", (Object)hash).getResultList();
        Invitation invitation = i = list != null && list.size() == 1 ? (Invitation)list.get(0) : null;
        if (i != null) {
            switch (i.getValid()) {
                case OneTime: {
                    i.setAllowEntry(!i.isUsed());
                    if (!markUsed) break;
                    i.setUsed(true);
                    this.update(i);
                    this.em.flush();
                    break;
                }
                case Period: {
                    String tzId = i.getInvitee().getTimeZoneId();
                    if (Strings.isEmpty((CharSequence)tzId) && i.getAppointment() != null) {
                        log.warn("User with NO timezone found: {}", (Object)i.getInvitee().getId());
                        tzId = i.getAppointment().getOwner().getTimeZoneId();
                    }
                    if (Strings.isEmpty((CharSequence)tzId)) {
                        log.warn("Unable to obtain valid timezone, setting SYSTEM TZ");
                        tzId = TimeZone.getDefault().getID();
                    }
                    LocalDateTime now = ZonedDateTime.now(CalendarHelper.getZoneId((String)tzId)).toLocalDateTime();
                    LocalDateTime from = CalendarHelper.getDateTime((Date)i.getValidFrom(), (String)tzId);
                    LocalDateTime to = CalendarHelper.getDateTime((Date)i.getValidTo(), (String)tzId);
                    i.setAllowEntry(now.isAfter(from) && now.isBefore(to));
                    break;
                }
                default: {
                    i.setAllowEntry(true);
                }
            }
            this.em.detach((Object)i);
            if (hidePass) {
                i.setPassword(null);
            }
        }
        return i;
    }
}

