/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dto.room;

import com.github.openjson.JSONObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.openmeetings.db.dao.file.BaseFileItemDao;
import org.apache.openmeetings.db.entity.room.RoomFile;
import org.apache.openmeetings.db.util.DtoHelper;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RoomFileDTO
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Long id;
    private long fileId;
    private long wbIdx = 0L;

    public RoomFileDTO() {
    }

    public RoomFileDTO(RoomFile rf) {
        this.id = rf.getId();
        this.fileId = rf.getFile().getId();
        this.wbIdx = rf.getWbIdx();
    }

    public RoomFile get(BaseFileItemDao fileDao, Long roomId) {
        RoomFile f = new RoomFile();
        f.setId(this.id);
        f.setRoomId(roomId);
        f.setFile(fileDao.get(this.fileId));
        f.setWbIdx(this.wbIdx);
        return f;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public long getFileId() {
        return this.fileId;
    }

    public void setFileId(long fileId) {
        this.fileId = fileId;
    }

    public long getWbIdx() {
        return this.wbIdx;
    }

    public void setWbIdx(long wbIdx) {
        this.wbIdx = wbIdx;
    }

    public static List<RoomFileDTO> get(List<RoomFile> rfl) {
        ArrayList<RoomFileDTO> r = new ArrayList<RoomFileDTO>();
        if (rfl != null) {
            for (RoomFile rf : rfl) {
                r.add(new RoomFileDTO(rf));
            }
        }
        return r;
    }

    public static List<RoomFile> get(Long roomId, List<RoomFileDTO> rfl, BaseFileItemDao fileDao) {
        ArrayList<RoomFile> r = new ArrayList<RoomFile>();
        if (rfl != null) {
            for (RoomFileDTO rf : rfl) {
                RoomFile f = rf.get(fileDao, roomId);
                if (f.getFile() == null) continue;
                r.add(f);
            }
        }
        return r;
    }

    public static RoomFileDTO get(JSONObject o) {
        if (o == null) {
            return null;
        }
        RoomFileDTO rf = new RoomFileDTO();
        rf.id = DtoHelper.optLong(o, "id");
        rf.fileId = o.getLong("fileId");
        rf.wbIdx = DtoHelper.optLong(o, "wbIdx");
        return rf;
    }
}

