/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dto.room;

import com.github.openjson.JSONArray;
import com.github.openjson.JSONObject;
import com.github.openjson.JSONStringer;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.openmeetings.db.entity.file.BaseFileItem;
import org.apache.openmeetings.util.NullStringer;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.red5.logging.Red5LoggerFactory;
import org.slf4j.Logger;

public class Whiteboard
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Red5LoggerFactory.getLogger(Whiteboard.class, (String)OpenmeetingsVariables.getWebAppRootKey());
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_FILE_ID = "fileId";
    public static final String ATTR_FILE_TYPE = "fileType";
    public static final String ATTR_SLIDE = "slide";
    public static final String ITEMS_KEY = "roomItems";
    private static final int DEFAULT_WIDTH = 1920;
    private static final int DEFAULT_HEIGHT = 1080;
    private long id;
    private double zoom = 1.0;
    private ZoomMode zoomMode = ZoomMode.pageWidth;
    private int width = 1920;
    private int height = 1080;
    private Map<String, String> roomItems = Collections.synchronizedMap(new LinkedHashMap());
    private Date created = new Date();
    private int slide = 0;
    private String name;

    public Whiteboard() {
    }

    public Whiteboard(String name) {
        this.name = name;
        this.created = new Date();
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public double getZoom() {
        return this.zoom;
    }

    public void setZoom(double zoom) {
        this.zoom = zoom;
    }

    public ZoomMode getZoomMode() {
        return this.zoomMode;
    }

    public void setZoomMode(ZoomMode zoomMode) {
        this.zoomMode = zoomMode;
    }

    public void clear() {
        this.roomItems.clear();
        this.width = 1920;
        this.height = 1080;
    }

    public Whiteboard put(String uid, JSONObject obj) {
        this.roomItems.put(uid, obj.toString((JSONStringer)new NullStringer()));
        return this;
    }

    public JSONObject get(String uid) {
        String obj = this.roomItems.get(uid);
        return obj == null ? null : new JSONObject(obj);
    }

    public boolean contains(String uid) {
        return this.roomItems.containsKey(uid);
    }

    public JSONArray clearSlide(int slide) {
        JSONArray arr = new JSONArray();
        this.roomItems.entrySet().removeIf(e -> {
            boolean match;
            JSONObject o = new JSONObject((String)e.getValue());
            boolean bl = match = !BaseFileItem.Type.Presentation.name().equals(o.optString(ATTR_FILE_TYPE)) && o.optInt(ATTR_SLIDE, -1) == slide;
            if (match) {
                arr.put(e);
            }
            return match;
        });
        return arr;
    }

    public List<JSONObject> list() {
        LinkedList<JSONObject> items = new LinkedList<JSONObject>();
        for (Map.Entry<String, String> e : this.roomItems.entrySet()) {
            items.add(new JSONObject(e.getValue()));
        }
        return items;
    }

    public JSONObject remove(Object oid) {
        return new JSONObject(this.roomItems.remove(oid));
    }

    public boolean isEmpty() {
        return this.roomItems.isEmpty();
    }

    public String getName() {
        return this.name;
    }

    public Whiteboard setName(String name) {
        this.name = name;
        return this;
    }

    public int getSlide() {
        return this.slide;
    }

    public void setSlide(int slide) {
        this.slide = slide;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public JSONObject toJson() {
        JSONObject json = new JSONObject(new JSONObject((Object)this).toString((JSONStringer)new NullStringer()));
        json.remove("id");
        json.remove("empty");
        JSONObject items = new JSONObject();
        for (Map.Entry<String, String> e : this.roomItems.entrySet()) {
            JSONObject o = new JSONObject(e.getValue());
            if ("Clipart".equals(o.opt("omType"))) {
                if (o.has("_src")) {
                    o.put("src", o.get("_src"));
                }
            } else {
                o.remove("src");
            }
            o.remove("_src");
            items.put(e.getKey(), (Object)o);
        }
        json.put(ITEMS_KEY, (Object)items);
        return json;
    }

    public String save(Path path) {
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(this.toJson().toString((JSONStringer)new NullStringer(2)));
        }
        catch (IOException e) {
            log.error("Unexpected error while saving WB", (Throwable)e);
            return e.getMessage();
        }
        return null;
    }

    public static enum ZoomMode {
        fullFit,
        pageWidth,
        zoom;

    }
}

