/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dto.user;

import com.github.openjson.JSONArray;
import com.github.openjson.JSONException;
import com.github.openjson.JSONObject;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.openmeetings.db.entity.server.OAuthServer;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.red5.logging.Red5LoggerFactory;
import org.slf4j.Logger;

public class OAuthUser
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Red5LoggerFactory.getLogger(OAuthUser.class, (String)OpenmeetingsVariables.getWebAppRootKey());
    private final String uid;
    private String email;
    private String firstName;
    private String lastName;
    private String picture;
    private String locale;

    public OAuthUser(String jsonStr, OAuthServer server) {
        String login;
        String pEmail = server.getEmailParamName();
        String pFirstname = server.getFirstnameParamName();
        String pLastname = server.getLastnameParamName();
        String pLogin = server.getLoginParamName();
        JSONObject json = OAuthUser.getJSON(jsonStr, pLogin);
        this.uid = login = json.getString(pLogin);
        try {
            this.email = json.has(pEmail) ? json.getString(pEmail) : String.format("%s@%s", login, new URL(server.getIconUrl()).getHost());
        }
        catch (JSONException | MalformedURLException e) {
            this.email = null;
            log.error("Failed to get user from JSON: {}", (Object)json);
        }
        if (json.has(pFirstname)) {
            this.firstName = json.getString(pFirstname);
        }
        if (json.has(pLastname)) {
            this.lastName = json.getString(pLastname);
        }
    }

    public OAuthUser(Map<String, String> umap) {
        this.uid = umap.get("login");
        this.email = umap.get("email");
        this.firstName = umap.get("firstname");
        this.lastName = umap.get("lastname");
    }

    public String getUid() {
        return this.uid;
    }

    public String getEmail() {
        return this.email;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getPicture() {
        return this.picture;
    }

    public String getLocale() {
        return this.locale;
    }

    private static JSONObject getJSON(String str, String prop) {
        JSONObject json = new JSONObject(str);
        if (json.has(prop)) {
            return json;
        }
        for (String key : json.keySet()) {
            Object o = json.get(key);
            if (!(o instanceof JSONArray)) continue;
            JSONArray ja = (JSONArray)o;
            for (int i = 0; i < ja.length(); ++i) {
                JSONObject jao = ja.getJSONObject(i);
                if (!jao.has(prop)) continue;
                return jao;
            }
        }
        return new JSONObject();
    }
}

