/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.entity.user;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.xml.bind.annotation.XmlType;
import org.apache.openjpa.enhance.FieldConsumer;
import org.apache.openjpa.enhance.FieldSupplier;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.persistence.ElementDependent;
import org.apache.openjpa.persistence.FetchAttribute;
import org.apache.openjpa.persistence.FetchGroup;
import org.apache.openjpa.persistence.FetchGroups;
import org.apache.openjpa.persistence.LoadFetchGroup;
import org.apache.openjpa.persistence.jdbc.ForeignKey;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.LongId;
import org.apache.openmeetings.db.entity.HistoricalEntity;
import org.apache.openmeetings.db.entity.server.Sessiondata;
import org.apache.openmeetings.db.entity.user.Address;
import org.apache.openmeetings.db.entity.user.AsteriskSipUser;
import org.apache.openmeetings.db.entity.user.GroupUser;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.util.crypt.CryptProvider;
import org.apache.openmeetings.util.crypt.MD5;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;

@Entity
@FetchGroups(value={@FetchGroup(name="backupexport", attributes={@FetchAttribute(name="password")}), @FetchGroup(name="groupUsers", attributes={@FetchAttribute(name="groupUsers")})})
@NamedQueries(value={@NamedQuery(name="getUserById", query="SELECT u FROM User u WHERE u.id = :id"), @NamedQuery(name="getUsersByIds", query="select c from User c where c.id IN :ids"), @NamedQuery(name="getUserByLogin", query="SELECT u FROM User u WHERE u.deleted = false AND u.type = :type AND u.login = :login AND ((:domainId = 0 AND u.domainId IS NULL) OR (:domainId > 0 AND u.domainId = :domainId))"), @NamedQuery(name="getUserByEmail", query="SELECT u FROM User u WHERE u.deleted = false AND u.type = :type AND u.address.email = :email AND ((:domainId = 0 AND u.domainId IS NULL) OR (:domainId > 0 AND u.domainId = :domainId))"), @NamedQuery(name="getUserByHash", query="SELECT u FROM User u WHERE u.deleted = false AND u.type = :type AND u.resethash = :resethash"), @NamedQuery(name="getUserByExpiredHash", query="SELECT u FROM User u WHERE u.resetDate < :date"), @NamedQuery(name="getContactByEmailAndUser", query="SELECT u FROM User u WHERE u.deleted = false AND u.address.email = :email AND u.type = :type AND u.ownerId = :ownerId"), @NamedQuery(name="selectMaxFromUsersWithSearch", query="select count(c.id) from User c where c.deleted = false AND (lower(c.login) LIKE :search OR lower(c.firstname) LIKE :search OR lower(c.lastname) LIKE :search )"), @NamedQuery(name="getAllUsers", query="SELECT u FROM User u ORDER BY u.id"), @NamedQuery(name="getPassword", query="SELECT u.password FROM User u WHERE u.deleted = false AND u.id = :userId "), @NamedQuery(name="updatePassword", query="UPDATE User u SET u.password = :password WHERE u.id = :userId"), @NamedQuery(name="getNondeletedUsers", query="SELECT u FROM User u WHERE u.deleted = false"), @NamedQuery(name="countNondeletedUsers", query="SELECT COUNT(u) FROM User u WHERE u.deleted = false"), @NamedQuery(name="getUsersByGroupId", query="SELECT u FROM User u WHERE u.deleted = false AND u.groupUsers.group.id = :groupId"), @NamedQuery(name="getExternalUser", query="SELECT u FROM User u WHERE u.deleted = false AND u.externalId LIKE :externalId AND u.externalType LIKE :externalType"), @NamedQuery(name="getUserByLoginOrEmail", query="SELECT u from User u WHERE u.deleted = false AND u.type = :type AND (u.login = :userOrEmail OR u.address.email = :userOrEmail)")})
@Table(name="om_user")
@Root(name="user")
public class User
extends HistoricalEntity
implements PersistenceCapable {
    private static final long serialVersionUID = 1L;
    public static final int SALUTATION_MR_ID = 1;
    public static final int SALUTATION_MS_ID = 2;
    public static final int SALUTATION_MRS_ID = 3;
    public static final int SALUTATION_DR_ID = 4;
    public static final int SALUTATION_PROF_ID = 5;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    @Element(data=true, name="user_id")
    private Long id;
    @Column(name="age")
    @Element(data=true, required=false)
    private Date age;
    @Column(name="firstname")
    @Element(data=true, required=false)
    private String firstname;
    @Column(name="lastlogin")
    private Date lastlogin;
    @Column(name="lastname")
    @Element(data=true, required=false)
    private String lastname;
    @Column(name="login")
    @Element(data=true, required=false)
    private String login;
    @Basic(fetch=FetchType.LAZY)
    @Column(name="password", length=1024)
    @LoadFetchGroup(value="backupexport")
    @Element(name="pass", data=true, required=false)
    private String password;
    @Column(name="regdate")
    @Element(data=true, required=false)
    private Date regdate;
    @Column(name="salutation")
    @Enumerated(value=EnumType.STRING)
    @Element(name="title_id", data=true, required=false)
    private Salutation salutation;
    @Column(name="pictureuri")
    @Element(data=true, required=false)
    private String pictureuri;
    @Column(name="language_id")
    @Element(name="language_id", data=true, required=false)
    private long languageId;
    @Column(name="resethash")
    @Element(data=true, required=false)
    private String resethash;
    @Column(name="resetdate")
    @Element(data=true, required=false)
    private Date resetDate;
    @Column(name="activatehash")
    @Element(data=true, required=false)
    private String activatehash;
    @OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="address_id", insertable=true, updatable=true)
    @ForeignKey(enabled=true)
    @Element(name="address", required=false)
    private Address address;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="user_id", insertable=true, updatable=true, nullable=false)
    @ElementList(name="organisations", required=false)
    @ElementDependent
    private List<GroupUser> groupUsers = new ArrayList<GroupUser>();
    @OneToOne(fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true)
    @PrimaryKeyJoinColumn(name="sip_user_id", referencedColumnName="id")
    @Element(name="sipUser", required=false)
    private AsteriskSipUser sipUser;
    @Column(name="external_id")
    @Element(name="externalUserId", data=true, required=false)
    private String externalId;
    @Column(name="external_type")
    @Element(name="externalUserType", data=true, required=false)
    private String externalType;
    @Column(name="time_zone_id")
    @Element(data=true, required=false)
    private String timeZoneId;
    @Transient
    private Sessiondata sessionData;
    @Column(name="forceTimeZoneCheck", nullable=false)
    @Element(data=true, required=false)
    private boolean forceTimeZoneCheck;
    @Column(name="sendSMS", nullable=false)
    @Element(data=false, required=false)
    private boolean sendSMS;
    @Column(name="user_offers")
    @Element(data=true, required=false)
    private String userOffers;
    @Column(name="user_searchs")
    @Element(data=true, required=false)
    private String userSearchs;
    @Column(name="show_contact_data", nullable=false)
    @Element(data=true, required=false)
    private boolean showContactData;
    @Column(name="show_contact_data_to_contacts", nullable=false)
    @Element(data=true, required=false)
    private boolean showContactDataToContacts;
    @Column(name="type")
    @Element(data=true, required=false)
    @Enumerated(value=EnumType.STRING)
    private Type type = Type.user;
    @Column(name="owner_id")
    @Element(data=true, required=false)
    private Long ownerId;
    @ElementCollection(fetch=FetchType.EAGER)
    @Column(name="om_right")
    @CollectionTable(name="om_user_right", joinColumns={@JoinColumn(name="user_id")})
    @Enumerated(value=EnumType.STRING)
    @ElementList(name="rights", data=true, required=false)
    private Set<Right> rights = new HashSet<Right>();
    @Column(name="domain_id")
    @Element(data=true, required=false)
    private Long domainId;
    private static int pcInheritedFieldCount = HistoricalEntity.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Lorg$apache$openmeetings$db$entity$HistoricalEntity;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Lorg$apache$openmeetings$db$entity$user$Address;
    static /* synthetic */ Class class$Ljava$util$Date;
    static /* synthetic */ Class class$Ljava$lang$Long;
    static /* synthetic */ Class class$Ljava$util$List;
    static /* synthetic */ Class class$Ljava$util$Set;
    static /* synthetic */ Class class$Lorg$apache$openmeetings$db$entity$user$User$Salutation;
    static /* synthetic */ Class class$Lorg$apache$openmeetings$db$entity$user$AsteriskSipUser;
    static /* synthetic */ Class class$Lorg$apache$openmeetings$db$entity$user$User$Type;
    static /* synthetic */ Class class$Lorg$apache$openmeetings$db$entity$user$User;

    @Override
    public Long getId() {
        return User.pcGetid(this);
    }

    @Override
    public void setId(Long id) {
        User.pcSetid(this, id);
    }

    public Address getAddress() {
        return User.pcGetaddress(this);
    }

    public void setAddress(Address address) {
        User.pcSetaddress(this, address);
    }

    public Date getAge() {
        return User.pcGetage(this);
    }

    public void setAge(Date age) {
        User.pcSetage(this, age == null ? new Date() : age);
    }

    public String getFirstname() {
        return User.pcGetfirstname(this);
    }

    public User setFirstname(String firstname) {
        User.pcSetfirstname(this, firstname);
        return this;
    }

    public Date getLastlogin() {
        return User.pcGetlastlogin(this);
    }

    public void setLastlogin(Date lastlogin) {
        User.pcSetlastlogin(this, lastlogin);
    }

    public String getLastname() {
        return User.pcGetlastname(this);
    }

    public User setLastname(String lastname) {
        User.pcSetlastname(this, lastname);
        return this;
    }

    public String getLogin() {
        return User.pcGetlogin(this);
    }

    public void setLogin(String login) {
        User.pcSetlogin(this, login);
    }

    public void updatePassword(String pass) throws NoSuchAlgorithmException {
        if (OpenmeetingsVariables.isSipEnabled()) {
            AsteriskSipUser u = this.getSipUser();
            if (u == null) {
                u = new AsteriskSipUser();
                this.setSipUser(u);
            }
            String defaultRoomContext = OpenmeetingsVariables.getSipContext();
            u.setName(User.pcGetlogin(this));
            u.setDefaultuser(User.pcGetlogin(this));
            u.setMd5secret(MD5.checksum((String)(User.pcGetlogin(this) + ":asterisk:" + pass)));
            u.setContext(defaultRoomContext);
            u.setHost("dynamic");
        } else {
            this.setSipUser(null);
        }
        User.pcSetpassword(this, CryptProvider.get().hash(pass));
    }

    public String getPassword() {
        return User.pcGetpassword(this);
    }

    @Deprecated
    public void setPassword(String password) {
        User.pcSetpassword(this, password);
    }

    public Date getRegdate() {
        return User.pcGetregdate(this);
    }

    public void setRegdate(Date regdate) {
        User.pcSetregdate(this, regdate);
    }

    public Salutation getSalutation() {
        return User.pcGetsalutation(this);
    }

    public void setSalutation(Salutation salutation) {
        User.pcSetsalutation(this, salutation);
    }

    public String getPictureuri() {
        return User.pcGetpictureuri(this);
    }

    public void setPictureuri(String pictureuri) {
        User.pcSetpictureuri(this, pictureuri);
    }

    public long getLanguageId() {
        return User.pcGetlanguageId(this);
    }

    public void setLanguageId(long languageId) {
        User.pcSetlanguageId(this, languageId);
    }

    public List<GroupUser> getGroupUsers() {
        return User.pcGetgroupUsers(this);
    }

    public void setGroupUsers(List<GroupUser> groupUsers) {
        if (groupUsers != null) {
            User.pcSetgroupUsers(this, groupUsers);
        }
    }

    public String getResethash() {
        return User.pcGetresethash(this);
    }

    public void setResethash(String resethash) {
        User.pcSetresethash(this, resethash);
    }

    public Date getResetDate() {
        return User.pcGetresetDate(this);
    }

    public void setResetDate(Date resetDate) {
        User.pcSetresetDate(this, resetDate);
    }

    public String getActivatehash() {
        return User.pcGetactivatehash(this);
    }

    public void setActivatehash(String activatehash) {
        User.pcSetactivatehash(this, activatehash);
    }

    public String getExternalId() {
        return User.pcGetexternalId(this);
    }

    public void setExternalId(String externalId) {
        User.pcSetexternalId(this, externalId);
    }

    public String getExternalType() {
        return User.pcGetexternalType(this);
    }

    public void setExternalType(String externalType) {
        User.pcSetexternalType(this, externalType);
    }

    public Sessiondata getSessionData() {
        return this.sessionData;
    }

    public void setSessionData(Sessiondata sessionData) {
        this.sessionData = sessionData;
    }

    public AsteriskSipUser getSipUser() {
        return User.pcGetsipUser(this);
    }

    public void setSipUser(AsteriskSipUser sipUser) {
        User.pcSetsipUser(this, sipUser);
    }

    public String getTimeZoneId() {
        return User.pcGettimeZoneId(this);
    }

    public void setTimeZoneId(String timeZoneId) {
        User.pcSettimeZoneId(this, timeZoneId);
    }

    public boolean getForceTimeZoneCheck() {
        return User.pcGetforceTimeZoneCheck(this);
    }

    public void setForceTimeZoneCheck(boolean forceTimeZoneCheck) {
        User.pcSetforceTimeZoneCheck(this, forceTimeZoneCheck);
    }

    public boolean getSendSMS() {
        return User.pcGetsendSMS(this);
    }

    public void setSendSMS(boolean sendSMS) {
        User.pcSetsendSMS(this, sendSMS);
    }

    public String getUserOffers() {
        return User.pcGetuserOffers(this);
    }

    public void setUserOffers(String userOffers) {
        User.pcSetuserOffers(this, userOffers);
    }

    public String getUserSearchs() {
        return User.pcGetuserSearchs(this);
    }

    public void setUserSearchs(String userSearchs) {
        User.pcSetuserSearchs(this, userSearchs);
    }

    public boolean isShowContactData() {
        return User.pcGetshowContactData(this);
    }

    public void setShowContactData(boolean showContactData) {
        User.pcSetshowContactData(this, showContactData);
    }

    public boolean isShowContactDataToContacts() {
        return User.pcGetshowContactDataToContacts(this);
    }

    public void setShowContactDataToContacts(boolean showContactDataToContacts) {
        User.pcSetshowContactDataToContacts(this, showContactDataToContacts);
    }

    public String getPhoneForSMS() {
        return this.getSendSMS() ? this.getAddress().getPhone() : "";
    }

    public Type getType() {
        return User.pcGettype(this);
    }

    public void setType(Type type) {
        User.pcSettype(this, type);
    }

    public Long getOwnerId() {
        return User.pcGetownerId(this);
    }

    public void setOwnerId(Long ownerId) {
        User.pcSetownerId(this, ownerId);
    }

    public Set<Right> getRights() {
        return User.pcGetrights(this);
    }

    public void setRights(Set<Right> rights) {
        User.pcSetrights(this, rights);
    }

    public Long getDomainId() {
        return User.pcGetdomainId(this);
    }

    public void setDomainId(Long domainId) {
        User.pcSetdomainId(this, domainId);
    }

    public String toString() {
        return "User [id=" + User.pcGetid(this) + ", firstname=" + User.pcGetfirstname(this) + ", lastname=" + User.pcGetlastname(this) + ", login=" + User.pcGetlogin(this) + ", pictureuri=" + User.pcGetpictureuri(this) + ", deleted=" + this.isDeleted() + ", languageId=" + User.pcGetlanguageId(this) + ", address=" + User.pcGetaddress(this) + ", externalId=" + User.pcGetexternalId(this) + ", externalType=" + User.pcGetexternalType(this) + ", type=" + (Object)((Object)User.pcGettype(this)) + "]";
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 2;
    }

    static {
        Class clazz = class$Lorg$apache$openmeetings$db$entity$HistoricalEntity != null ? class$Lorg$apache$openmeetings$db$entity$HistoricalEntity : (class$Lorg$apache$openmeetings$db$entity$HistoricalEntity = User.class$("org.apache.openmeetings.db.entity.HistoricalEntity"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"activatehash", "address", "age", "domainId", "externalId", "externalType", "firstname", "forceTimeZoneCheck", "groupUsers", "id", "languageId", "lastlogin", "lastname", "login", "ownerId", "password", "pictureuri", "regdate", "resetDate", "resethash", "rights", "salutation", "sendSMS", "showContactData", "showContactDataToContacts", "sipUser", "timeZoneId", "type", "userOffers", "userSearchs"};
        Class[] classArray = new Class[30];
        Class clazz2 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = User.class$("java.lang.String"));
        classArray[0] = clazz2;
        Class clazz3 = class$Lorg$apache$openmeetings$db$entity$user$Address != null ? class$Lorg$apache$openmeetings$db$entity$user$Address : (class$Lorg$apache$openmeetings$db$entity$user$Address = User.class$("org.apache.openmeetings.db.entity.user.Address"));
        classArray[1] = clazz3;
        Class clazz4 = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = User.class$("java.util.Date"));
        classArray[2] = clazz4;
        Class clazz5 = class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = User.class$("java.lang.Long"));
        classArray[3] = clazz5;
        classArray[4] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = User.class$("java.lang.String"));
        classArray[5] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = User.class$("java.lang.String"));
        classArray[6] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = User.class$("java.lang.String"));
        classArray[7] = Boolean.TYPE;
        Class clazz6 = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = User.class$("java.util.List"));
        classArray[8] = clazz6;
        classArray[9] = class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = User.class$("java.lang.Long"));
        classArray[10] = Long.TYPE;
        classArray[11] = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = User.class$("java.util.Date"));
        classArray[12] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = User.class$("java.lang.String"));
        classArray[13] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = User.class$("java.lang.String"));
        classArray[14] = class$Ljava$lang$Long != null ? class$Ljava$lang$Long : (class$Ljava$lang$Long = User.class$("java.lang.Long"));
        classArray[15] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = User.class$("java.lang.String"));
        classArray[16] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = User.class$("java.lang.String"));
        classArray[17] = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = User.class$("java.util.Date"));
        classArray[18] = class$Ljava$util$Date != null ? class$Ljava$util$Date : (class$Ljava$util$Date = User.class$("java.util.Date"));
        classArray[19] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = User.class$("java.lang.String"));
        Class clazz7 = class$Ljava$util$Set != null ? class$Ljava$util$Set : (class$Ljava$util$Set = User.class$("java.util.Set"));
        classArray[20] = clazz7;
        Class clazz8 = class$Lorg$apache$openmeetings$db$entity$user$User$Salutation != null ? class$Lorg$apache$openmeetings$db$entity$user$User$Salutation : (class$Lorg$apache$openmeetings$db$entity$user$User$Salutation = User.class$("org.apache.openmeetings.db.entity.user.User$Salutation"));
        classArray[21] = clazz8;
        classArray[22] = Boolean.TYPE;
        classArray[23] = Boolean.TYPE;
        classArray[24] = Boolean.TYPE;
        Class clazz9 = class$Lorg$apache$openmeetings$db$entity$user$AsteriskSipUser != null ? class$Lorg$apache$openmeetings$db$entity$user$AsteriskSipUser : (class$Lorg$apache$openmeetings$db$entity$user$AsteriskSipUser = User.class$("org.apache.openmeetings.db.entity.user.AsteriskSipUser"));
        classArray[25] = clazz9;
        classArray[26] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = User.class$("java.lang.String"));
        Class clazz10 = class$Lorg$apache$openmeetings$db$entity$user$User$Type != null ? class$Lorg$apache$openmeetings$db$entity$user$User$Type : (class$Lorg$apache$openmeetings$db$entity$user$User$Type = User.class$("org.apache.openmeetings.db.entity.user.User$Type"));
        classArray[27] = clazz10;
        classArray[28] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = User.class$("java.lang.String"));
        classArray[29] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = User.class$("java.lang.String"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26, 26, 26, 26, 5, 26, 26, 26, 26, 26, 26, 21, 26, 26, 26, 26, 10, 26, 26, 26, 26, 26, 26, 26, 26, 26};
        Class clazz11 = class$Lorg$apache$openmeetings$db$entity$user$User != null ? class$Lorg$apache$openmeetings$db$entity$user$User : (class$Lorg$apache$openmeetings$db$entity$user$User = User.class$("org.apache.openmeetings.db.entity.user.User"));
        PCRegistry.register((Class)clazz11, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"User", (PersistenceCapable)new User());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.activatehash = null;
        this.address = null;
        this.age = null;
        this.domainId = null;
        this.externalId = null;
        this.externalType = null;
        this.firstname = null;
        this.forceTimeZoneCheck = false;
        this.groupUsers = null;
        this.id = null;
        this.languageId = 0L;
        this.lastlogin = null;
        this.lastname = null;
        this.login = null;
        this.ownerId = null;
        this.password = null;
        this.pictureuri = null;
        this.regdate = null;
        this.resetDate = null;
        this.resethash = null;
        this.rights = null;
        this.salutation = null;
        this.sendSMS = false;
        this.showContactData = false;
        this.showContactDataToContacts = false;
        this.sipUser = null;
        this.timeZoneId = null;
        this.type = null;
        this.userOffers = null;
        this.userSearchs = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        User user = new User();
        if (bl) {
            user.pcClearFields();
        }
        user.pcStateManager = stateManager;
        user.pcCopyKeyFieldsFromObjectId(object);
        return user;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        User user = new User();
        if (bl) {
            user.pcClearFields();
        }
        user.pcStateManager = stateManager;
        return user;
    }

    protected static int pcGetManagedFieldCount() {
        return 30 + HistoricalEntity.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.activatehash = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.address = (Address)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.age = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.domainId = (Long)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.externalId = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.externalType = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.firstname = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.forceTimeZoneCheck = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.groupUsers = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.id = (Long)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 10: {
                this.languageId = this.pcStateManager.replaceLongField((PersistenceCapable)this, n);
                return;
            }
            case 11: {
                this.lastlogin = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 12: {
                this.lastname = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 13: {
                this.login = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 14: {
                this.ownerId = (Long)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 15: {
                this.password = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 16: {
                this.pictureuri = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 17: {
                this.regdate = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 18: {
                this.resetDate = (Date)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 19: {
                this.resethash = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 20: {
                this.rights = (Set)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 21: {
                this.salutation = (Salutation)((Object)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n));
                return;
            }
            case 22: {
                this.sendSMS = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 23: {
                this.showContactData = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 24: {
                this.showContactDataToContacts = this.pcStateManager.replaceBooleanField((PersistenceCapable)this, n);
                return;
            }
            case 25: {
                this.sipUser = (AsteriskSipUser)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 26: {
                this.timeZoneId = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 27: {
                this.type = (Type)((Object)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n));
                return;
            }
            case 28: {
                this.userOffers = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 29: {
                this.userSearchs = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.activatehash);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.address);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.age);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.domainId);
                return;
            }
            case 4: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.externalId);
                return;
            }
            case 5: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.externalType);
                return;
            }
            case 6: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.firstname);
                return;
            }
            case 7: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.forceTimeZoneCheck);
                return;
            }
            case 8: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.groupUsers);
                return;
            }
            case 9: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.id);
                return;
            }
            case 10: {
                this.pcStateManager.providedLongField((PersistenceCapable)this, n, this.languageId);
                return;
            }
            case 11: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.lastlogin);
                return;
            }
            case 12: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.lastname);
                return;
            }
            case 13: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.login);
                return;
            }
            case 14: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.ownerId);
                return;
            }
            case 15: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.password);
                return;
            }
            case 16: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.pictureuri);
                return;
            }
            case 17: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.regdate);
                return;
            }
            case 18: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.resetDate);
                return;
            }
            case 19: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.resethash);
                return;
            }
            case 20: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.rights);
                return;
            }
            case 21: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.salutation);
                return;
            }
            case 22: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.sendSMS);
                return;
            }
            case 23: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.showContactData);
                return;
            }
            case 24: {
                this.pcStateManager.providedBooleanField((PersistenceCapable)this, n, this.showContactDataToContacts);
                return;
            }
            case 25: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.sipUser);
                return;
            }
            case 26: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.timeZoneId);
                return;
            }
            case 27: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.type);
                return;
            }
            case 28: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.userOffers);
                return;
            }
            case 29: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.userSearchs);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(User user, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(user, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.activatehash = user.activatehash;
                return;
            }
            case 1: {
                this.address = user.address;
                return;
            }
            case 2: {
                this.age = user.age;
                return;
            }
            case 3: {
                this.domainId = user.domainId;
                return;
            }
            case 4: {
                this.externalId = user.externalId;
                return;
            }
            case 5: {
                this.externalType = user.externalType;
                return;
            }
            case 6: {
                this.firstname = user.firstname;
                return;
            }
            case 7: {
                this.forceTimeZoneCheck = user.forceTimeZoneCheck;
                return;
            }
            case 8: {
                this.groupUsers = user.groupUsers;
                return;
            }
            case 9: {
                this.id = user.id;
                return;
            }
            case 10: {
                this.languageId = user.languageId;
                return;
            }
            case 11: {
                this.lastlogin = user.lastlogin;
                return;
            }
            case 12: {
                this.lastname = user.lastname;
                return;
            }
            case 13: {
                this.login = user.login;
                return;
            }
            case 14: {
                this.ownerId = user.ownerId;
                return;
            }
            case 15: {
                this.password = user.password;
                return;
            }
            case 16: {
                this.pictureuri = user.pictureuri;
                return;
            }
            case 17: {
                this.regdate = user.regdate;
                return;
            }
            case 18: {
                this.resetDate = user.resetDate;
                return;
            }
            case 19: {
                this.resethash = user.resethash;
                return;
            }
            case 20: {
                this.rights = user.rights;
                return;
            }
            case 21: {
                this.salutation = user.salutation;
                return;
            }
            case 22: {
                this.sendSMS = user.sendSMS;
                return;
            }
            case 23: {
                this.showContactData = user.showContactData;
                return;
            }
            case 24: {
                this.showContactDataToContacts = user.showContactDataToContacts;
                return;
            }
            case 25: {
                this.sipUser = user.sipUser;
                return;
            }
            case 26: {
                this.timeZoneId = user.timeZoneId;
                return;
            }
            case 27: {
                this.type = user.type;
                return;
            }
            case 28: {
                this.userOffers = user.userOffers;
                return;
            }
            case 29: {
                this.userSearchs = user.userSearchs;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        User user = (User)object;
        if (user.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(user, nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcCopyKeyFieldsToObjectId(FieldSupplier fieldSupplier, Object object) {
        throw new InternalException();
    }

    @Override
    public void pcCopyKeyFieldsToObjectId(Object object) {
        throw new InternalException();
    }

    @Override
    public void pcCopyKeyFieldsFromObjectId(FieldConsumer fieldConsumer, Object object) {
        super.pcCopyKeyFieldsFromObjectId(fieldConsumer, object);
        LongId longId = (LongId)object;
        fieldConsumer.storeObjectField(9 + pcInheritedFieldCount, (Object)new Long(longId.getId()));
    }

    @Override
    public void pcCopyKeyFieldsFromObjectId(Object object) {
        super.pcCopyKeyFieldsFromObjectId(object);
        LongId longId = (LongId)object;
        this.id = new Long(longId.getId());
    }

    @Override
    public Object pcNewObjectIdInstance(Object object) {
        Class clazz = class$Lorg$apache$openmeetings$db$entity$user$User != null ? class$Lorg$apache$openmeetings$db$entity$user$User : (class$Lorg$apache$openmeetings$db$entity$user$User = User.class$("org.apache.openmeetings.db.entity.user.User"));
        return new LongId(clazz, (String)object);
    }

    @Override
    public Object pcNewObjectIdInstance() {
        Class clazz = class$Lorg$apache$openmeetings$db$entity$user$User != null ? class$Lorg$apache$openmeetings$db$entity$user$User : (class$Lorg$apache$openmeetings$db$entity$user$User = User.class$("org.apache.openmeetings.db.entity.user.User"));
        return new LongId(clazz, this.id);
    }

    private static final String pcGetactivatehash(User user) {
        if (user.pcStateManager == null) {
            return user.activatehash;
        }
        int n = pcInheritedFieldCount + 0;
        user.pcStateManager.accessingField(n);
        return user.activatehash;
    }

    private static final void pcSetactivatehash(User user, String string) {
        if (user.pcStateManager == null) {
            user.activatehash = string;
            return;
        }
        user.pcStateManager.settingStringField((PersistenceCapable)user, pcInheritedFieldCount + 0, user.activatehash, string, 0);
    }

    private static final Address pcGetaddress(User user) {
        if (user.pcStateManager == null) {
            return user.address;
        }
        int n = pcInheritedFieldCount + 1;
        user.pcStateManager.accessingField(n);
        return user.address;
    }

    private static final void pcSetaddress(User user, Address address) {
        if (user.pcStateManager == null) {
            user.address = address;
            return;
        }
        user.pcStateManager.settingObjectField((PersistenceCapable)user, pcInheritedFieldCount + 1, (Object)user.address, (Object)address, 0);
    }

    private static final Date pcGetage(User user) {
        if (user.pcStateManager == null) {
            return user.age;
        }
        int n = pcInheritedFieldCount + 2;
        user.pcStateManager.accessingField(n);
        return user.age;
    }

    private static final void pcSetage(User user, Date date) {
        if (user.pcStateManager == null) {
            user.age = date;
            return;
        }
        user.pcStateManager.settingObjectField((PersistenceCapable)user, pcInheritedFieldCount + 2, (Object)user.age, (Object)date, 0);
    }

    private static final Long pcGetdomainId(User user) {
        if (user.pcStateManager == null) {
            return user.domainId;
        }
        int n = pcInheritedFieldCount + 3;
        user.pcStateManager.accessingField(n);
        return user.domainId;
    }

    private static final void pcSetdomainId(User user, Long l) {
        if (user.pcStateManager == null) {
            user.domainId = l;
            return;
        }
        user.pcStateManager.settingObjectField((PersistenceCapable)user, pcInheritedFieldCount + 3, (Object)user.domainId, (Object)l, 0);
    }

    private static final String pcGetexternalId(User user) {
        if (user.pcStateManager == null) {
            return user.externalId;
        }
        int n = pcInheritedFieldCount + 4;
        user.pcStateManager.accessingField(n);
        return user.externalId;
    }

    private static final void pcSetexternalId(User user, String string) {
        if (user.pcStateManager == null) {
            user.externalId = string;
            return;
        }
        user.pcStateManager.settingStringField((PersistenceCapable)user, pcInheritedFieldCount + 4, user.externalId, string, 0);
    }

    private static final String pcGetexternalType(User user) {
        if (user.pcStateManager == null) {
            return user.externalType;
        }
        int n = pcInheritedFieldCount + 5;
        user.pcStateManager.accessingField(n);
        return user.externalType;
    }

    private static final void pcSetexternalType(User user, String string) {
        if (user.pcStateManager == null) {
            user.externalType = string;
            return;
        }
        user.pcStateManager.settingStringField((PersistenceCapable)user, pcInheritedFieldCount + 5, user.externalType, string, 0);
    }

    private static final String pcGetfirstname(User user) {
        if (user.pcStateManager == null) {
            return user.firstname;
        }
        int n = pcInheritedFieldCount + 6;
        user.pcStateManager.accessingField(n);
        return user.firstname;
    }

    private static final void pcSetfirstname(User user, String string) {
        if (user.pcStateManager == null) {
            user.firstname = string;
            return;
        }
        user.pcStateManager.settingStringField((PersistenceCapable)user, pcInheritedFieldCount + 6, user.firstname, string, 0);
    }

    private static final boolean pcGetforceTimeZoneCheck(User user) {
        if (user.pcStateManager == null) {
            return user.forceTimeZoneCheck;
        }
        int n = pcInheritedFieldCount + 7;
        user.pcStateManager.accessingField(n);
        return user.forceTimeZoneCheck;
    }

    private static final void pcSetforceTimeZoneCheck(User user, boolean bl) {
        if (user.pcStateManager == null) {
            user.forceTimeZoneCheck = bl;
            return;
        }
        user.pcStateManager.settingBooleanField((PersistenceCapable)user, pcInheritedFieldCount + 7, user.forceTimeZoneCheck, bl, 0);
    }

    private static final List pcGetgroupUsers(User user) {
        if (user.pcStateManager == null) {
            return user.groupUsers;
        }
        int n = pcInheritedFieldCount + 8;
        user.pcStateManager.accessingField(n);
        return user.groupUsers;
    }

    private static final void pcSetgroupUsers(User user, List list) {
        if (user.pcStateManager == null) {
            user.groupUsers = list;
            return;
        }
        user.pcStateManager.settingObjectField((PersistenceCapable)user, pcInheritedFieldCount + 8, user.groupUsers, (Object)list, 0);
    }

    private static final Long pcGetid(User user) {
        if (user.pcStateManager == null) {
            return user.id;
        }
        int n = pcInheritedFieldCount + 9;
        user.pcStateManager.accessingField(n);
        return user.id;
    }

    private static final void pcSetid(User user, Long l) {
        if (user.pcStateManager == null) {
            user.id = l;
            return;
        }
        user.pcStateManager.settingObjectField((PersistenceCapable)user, pcInheritedFieldCount + 9, (Object)user.id, (Object)l, 0);
    }

    private static final long pcGetlanguageId(User user) {
        if (user.pcStateManager == null) {
            return user.languageId;
        }
        int n = pcInheritedFieldCount + 10;
        user.pcStateManager.accessingField(n);
        return user.languageId;
    }

    private static final void pcSetlanguageId(User user, long l) {
        if (user.pcStateManager == null) {
            user.languageId = l;
            return;
        }
        user.pcStateManager.settingLongField((PersistenceCapable)user, pcInheritedFieldCount + 10, user.languageId, l, 0);
    }

    private static final Date pcGetlastlogin(User user) {
        if (user.pcStateManager == null) {
            return user.lastlogin;
        }
        int n = pcInheritedFieldCount + 11;
        user.pcStateManager.accessingField(n);
        return user.lastlogin;
    }

    private static final void pcSetlastlogin(User user, Date date) {
        if (user.pcStateManager == null) {
            user.lastlogin = date;
            return;
        }
        user.pcStateManager.settingObjectField((PersistenceCapable)user, pcInheritedFieldCount + 11, (Object)user.lastlogin, (Object)date, 0);
    }

    private static final String pcGetlastname(User user) {
        if (user.pcStateManager == null) {
            return user.lastname;
        }
        int n = pcInheritedFieldCount + 12;
        user.pcStateManager.accessingField(n);
        return user.lastname;
    }

    private static final void pcSetlastname(User user, String string) {
        if (user.pcStateManager == null) {
            user.lastname = string;
            return;
        }
        user.pcStateManager.settingStringField((PersistenceCapable)user, pcInheritedFieldCount + 12, user.lastname, string, 0);
    }

    private static final String pcGetlogin(User user) {
        if (user.pcStateManager == null) {
            return user.login;
        }
        int n = pcInheritedFieldCount + 13;
        user.pcStateManager.accessingField(n);
        return user.login;
    }

    private static final void pcSetlogin(User user, String string) {
        if (user.pcStateManager == null) {
            user.login = string;
            return;
        }
        user.pcStateManager.settingStringField((PersistenceCapable)user, pcInheritedFieldCount + 13, user.login, string, 0);
    }

    private static final Long pcGetownerId(User user) {
        if (user.pcStateManager == null) {
            return user.ownerId;
        }
        int n = pcInheritedFieldCount + 14;
        user.pcStateManager.accessingField(n);
        return user.ownerId;
    }

    private static final void pcSetownerId(User user, Long l) {
        if (user.pcStateManager == null) {
            user.ownerId = l;
            return;
        }
        user.pcStateManager.settingObjectField((PersistenceCapable)user, pcInheritedFieldCount + 14, (Object)user.ownerId, (Object)l, 0);
    }

    private static final String pcGetpassword(User user) {
        if (user.pcStateManager == null) {
            return user.password;
        }
        int n = pcInheritedFieldCount + 15;
        user.pcStateManager.accessingField(n);
        return user.password;
    }

    private static final void pcSetpassword(User user, String string) {
        if (user.pcStateManager == null) {
            user.password = string;
            return;
        }
        user.pcStateManager.settingStringField((PersistenceCapable)user, pcInheritedFieldCount + 15, user.password, string, 0);
    }

    private static final String pcGetpictureuri(User user) {
        if (user.pcStateManager == null) {
            return user.pictureuri;
        }
        int n = pcInheritedFieldCount + 16;
        user.pcStateManager.accessingField(n);
        return user.pictureuri;
    }

    private static final void pcSetpictureuri(User user, String string) {
        if (user.pcStateManager == null) {
            user.pictureuri = string;
            return;
        }
        user.pcStateManager.settingStringField((PersistenceCapable)user, pcInheritedFieldCount + 16, user.pictureuri, string, 0);
    }

    private static final Date pcGetregdate(User user) {
        if (user.pcStateManager == null) {
            return user.regdate;
        }
        int n = pcInheritedFieldCount + 17;
        user.pcStateManager.accessingField(n);
        return user.regdate;
    }

    private static final void pcSetregdate(User user, Date date) {
        if (user.pcStateManager == null) {
            user.regdate = date;
            return;
        }
        user.pcStateManager.settingObjectField((PersistenceCapable)user, pcInheritedFieldCount + 17, (Object)user.regdate, (Object)date, 0);
    }

    private static final Date pcGetresetDate(User user) {
        if (user.pcStateManager == null) {
            return user.resetDate;
        }
        int n = pcInheritedFieldCount + 18;
        user.pcStateManager.accessingField(n);
        return user.resetDate;
    }

    private static final void pcSetresetDate(User user, Date date) {
        if (user.pcStateManager == null) {
            user.resetDate = date;
            return;
        }
        user.pcStateManager.settingObjectField((PersistenceCapable)user, pcInheritedFieldCount + 18, (Object)user.resetDate, (Object)date, 0);
    }

    private static final String pcGetresethash(User user) {
        if (user.pcStateManager == null) {
            return user.resethash;
        }
        int n = pcInheritedFieldCount + 19;
        user.pcStateManager.accessingField(n);
        return user.resethash;
    }

    private static final void pcSetresethash(User user, String string) {
        if (user.pcStateManager == null) {
            user.resethash = string;
            return;
        }
        user.pcStateManager.settingStringField((PersistenceCapable)user, pcInheritedFieldCount + 19, user.resethash, string, 0);
    }

    private static final Set pcGetrights(User user) {
        if (user.pcStateManager == null) {
            return user.rights;
        }
        int n = pcInheritedFieldCount + 20;
        user.pcStateManager.accessingField(n);
        return user.rights;
    }

    private static final void pcSetrights(User user, Set set) {
        if (user.pcStateManager == null) {
            user.rights = set;
            return;
        }
        user.pcStateManager.settingObjectField((PersistenceCapable)user, pcInheritedFieldCount + 20, user.rights, (Object)set, 0);
    }

    private static final Salutation pcGetsalutation(User user) {
        if (user.pcStateManager == null) {
            return user.salutation;
        }
        int n = pcInheritedFieldCount + 21;
        user.pcStateManager.accessingField(n);
        return user.salutation;
    }

    private static final void pcSetsalutation(User user, Salutation salutation) {
        if (user.pcStateManager == null) {
            user.salutation = salutation;
            return;
        }
        user.pcStateManager.settingObjectField((PersistenceCapable)user, pcInheritedFieldCount + 21, (Object)user.salutation, (Object)salutation, 0);
    }

    private static final boolean pcGetsendSMS(User user) {
        if (user.pcStateManager == null) {
            return user.sendSMS;
        }
        int n = pcInheritedFieldCount + 22;
        user.pcStateManager.accessingField(n);
        return user.sendSMS;
    }

    private static final void pcSetsendSMS(User user, boolean bl) {
        if (user.pcStateManager == null) {
            user.sendSMS = bl;
            return;
        }
        user.pcStateManager.settingBooleanField((PersistenceCapable)user, pcInheritedFieldCount + 22, user.sendSMS, bl, 0);
    }

    private static final boolean pcGetshowContactData(User user) {
        if (user.pcStateManager == null) {
            return user.showContactData;
        }
        int n = pcInheritedFieldCount + 23;
        user.pcStateManager.accessingField(n);
        return user.showContactData;
    }

    private static final void pcSetshowContactData(User user, boolean bl) {
        if (user.pcStateManager == null) {
            user.showContactData = bl;
            return;
        }
        user.pcStateManager.settingBooleanField((PersistenceCapable)user, pcInheritedFieldCount + 23, user.showContactData, bl, 0);
    }

    private static final boolean pcGetshowContactDataToContacts(User user) {
        if (user.pcStateManager == null) {
            return user.showContactDataToContacts;
        }
        int n = pcInheritedFieldCount + 24;
        user.pcStateManager.accessingField(n);
        return user.showContactDataToContacts;
    }

    private static final void pcSetshowContactDataToContacts(User user, boolean bl) {
        if (user.pcStateManager == null) {
            user.showContactDataToContacts = bl;
            return;
        }
        user.pcStateManager.settingBooleanField((PersistenceCapable)user, pcInheritedFieldCount + 24, user.showContactDataToContacts, bl, 0);
    }

    private static final AsteriskSipUser pcGetsipUser(User user) {
        if (user.pcStateManager == null) {
            return user.sipUser;
        }
        int n = pcInheritedFieldCount + 25;
        user.pcStateManager.accessingField(n);
        return user.sipUser;
    }

    private static final void pcSetsipUser(User user, AsteriskSipUser asteriskSipUser) {
        if (user.pcStateManager == null) {
            user.sipUser = asteriskSipUser;
            return;
        }
        user.pcStateManager.settingObjectField((PersistenceCapable)user, pcInheritedFieldCount + 25, (Object)user.sipUser, (Object)asteriskSipUser, 0);
    }

    private static final String pcGettimeZoneId(User user) {
        if (user.pcStateManager == null) {
            return user.timeZoneId;
        }
        int n = pcInheritedFieldCount + 26;
        user.pcStateManager.accessingField(n);
        return user.timeZoneId;
    }

    private static final void pcSettimeZoneId(User user, String string) {
        if (user.pcStateManager == null) {
            user.timeZoneId = string;
            return;
        }
        user.pcStateManager.settingStringField((PersistenceCapable)user, pcInheritedFieldCount + 26, user.timeZoneId, string, 0);
    }

    private static final Type pcGettype(User user) {
        if (user.pcStateManager == null) {
            return user.type;
        }
        int n = pcInheritedFieldCount + 27;
        user.pcStateManager.accessingField(n);
        return user.type;
    }

    private static final void pcSettype(User user, Type type) {
        if (user.pcStateManager == null) {
            user.type = type;
            return;
        }
        user.pcStateManager.settingObjectField((PersistenceCapable)user, pcInheritedFieldCount + 27, (Object)user.type, (Object)type, 0);
    }

    private static final String pcGetuserOffers(User user) {
        if (user.pcStateManager == null) {
            return user.userOffers;
        }
        int n = pcInheritedFieldCount + 28;
        user.pcStateManager.accessingField(n);
        return user.userOffers;
    }

    private static final void pcSetuserOffers(User user, String string) {
        if (user.pcStateManager == null) {
            user.userOffers = string;
            return;
        }
        user.pcStateManager.settingStringField((PersistenceCapable)user, pcInheritedFieldCount + 28, user.userOffers, string, 0);
    }

    private static final String pcGetuserSearchs(User user) {
        if (user.pcStateManager == null) {
            return user.userSearchs;
        }
        int n = pcInheritedFieldCount + 29;
        user.pcStateManager.accessingField(n);
        return user.userSearchs;
    }

    private static final void pcSetuserSearchs(User user, String string) {
        if (user.pcStateManager == null) {
            user.userSearchs = string;
            return;
        }
        user.pcStateManager.settingStringField((PersistenceCapable)user, pcInheritedFieldCount + 29, user.userSearchs, string, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }

    @XmlType(namespace="org.apache.openmeetings.user.salutation")
    public static enum Salutation {
        mr(1),
        ms(2),
        mrs(3),
        dr(4),
        prof(5);

        private int id;

        private Salutation(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static Salutation get(Long type) {
            return Salutation.get(type == null ? 1 : type.intValue());
        }

        public static Salutation get(Integer type) {
            return Salutation.get(type == null ? 1 : type);
        }

        public static Salutation get(int type) {
            Salutation rt = mr;
            switch (type) {
                case 2: {
                    rt = ms;
                    break;
                }
                case 3: {
                    rt = mrs;
                    break;
                }
                case 4: {
                    rt = dr;
                    break;
                }
                case 5: {
                    rt = prof;
                    break;
                }
            }
            return rt;
        }
    }

    @XmlType(namespace="org.apache.openmeetings.user.type")
    public static enum Type {
        user,
        ldap,
        oauth,
        external,
        contact;

    }

    @XmlType(namespace="org.apache.openmeetings.user.right")
    public static enum Right {
        Admin,
        GroupAdmin,
        Room,
        Dashboard,
        Login,
        Soap;

    }
}

