/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.calendar;

import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.openmeetings.db.dao.calendar.AppointmentDao;
import org.apache.openmeetings.db.entity.calendar.OmCalendar;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class OmCalendarDao {
    @PersistenceContext
    private EntityManager em;
    @Autowired
    private AppointmentDao appointmentDao;

    public List<OmCalendar> get() {
        return this.em.createNamedQuery("getCalendars", OmCalendar.class).getResultList();
    }

    public OmCalendar get(Long calId) {
        List list = this.em.createNamedQuery("getCalendarbyId", OmCalendar.class).setParameter("calId", (Object)calId).getResultList();
        return list.size() == 1 ? (OmCalendar)list.get(0) : null;
    }

    public List<OmCalendar> getByUser(Long userId) {
        return this.em.createNamedQuery("getCalendarbyUser", OmCalendar.class).setParameter("userId", (Object)userId).getResultList();
    }

    public List<OmCalendar> getGoogleCalendars(Long userId) {
        return this.em.createNamedQuery("getGoogleCalendars", OmCalendar.class).setParameter("userId", (Object)userId).getResultList();
    }

    public OmCalendar update(OmCalendar c) {
        if (c.getId() == null) {
            c.setInserted(new Date());
            this.em.persist((Object)c);
        } else {
            c.setUpdated(new Date());
            c = (OmCalendar)this.em.merge((Object)c);
        }
        return c;
    }

    public void delete(OmCalendar c) {
        c.setDeleted(true);
        this.appointmentDao.deletebyCalendar(c.getId());
        this.update(c);
    }
}

