/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.user;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.openmeetings.db.dao.IGroupAdminDataProviderDao;
import org.apache.openmeetings.db.entity.user.Group;
import org.apache.openmeetings.db.util.DaoHelper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class GroupDao
implements IGroupAdminDataProviderDao<Group> {
    private static final String[] searchFields = new String[]{"name"};
    @PersistenceContext
    private EntityManager em;

    @Override
    public Group get(Long id) {
        List list = this.em.createNamedQuery("getGroupById", Group.class).setParameter("id", (Object)id).getResultList();
        return list.size() == 1 ? (Group)list.get(0) : null;
    }

    public Group get(String name) {
        List groups = this.em.createNamedQuery("getGroupByName", Group.class).setParameter("name", (Object)name).getResultList();
        return groups == null || groups.isEmpty() ? null : (Group)groups.get(0);
    }

    public Group getExternal(String name) {
        Group g;
        List groups = this.em.createNamedQuery("getExtGroupByName", Group.class).setParameter("name", (Object)name).getResultList();
        Group group = g = groups == null || groups.isEmpty() ? null : (Group)groups.get(0);
        if (g == null) {
            g = this.update(new Group().setExternal(true).setName(name), (Long)null);
        }
        return g;
    }

    @Override
    public List<Group> get(long start, long count) {
        return DaoHelper.setLimits(this.em.createNamedQuery("getNondeletedGroups", Group.class), start, count).getResultList();
    }

    @Override
    public List<Group> get(String search, long start, long count, String sort) {
        return DaoHelper.setLimits(this.em.createQuery(DaoHelper.getSearchQuery("Group", "g", search, true, false, sort, searchFields), Group.class), start, count).getResultList();
    }

    @Override
    public List<Group> adminGet(String search, Long adminId, long start, long count, String order) {
        return DaoHelper.setLimits(this.em.createQuery(DaoHelper.getSearchQuery("GroupUser gu, IN(gu.group)", "g", null, search, true, true, false, "gu.user.id = :adminId AND gu.moderator = true", order, searchFields), Group.class).setParameter("adminId", (Object)adminId), start, count).getResultList();
    }

    @Override
    public long count() {
        return (Long)this.em.createNamedQuery("countGroups", Long.class).getSingleResult();
    }

    @Override
    public long count(String search) {
        return (Long)this.em.createQuery(DaoHelper.getSearchQuery("Group", "o", search, true, true, null, searchFields), Long.class).getSingleResult();
    }

    @Override
    public long adminCount(String search, Long adminId) {
        return (Long)this.em.createQuery(DaoHelper.getSearchQuery("GroupUser gu, IN(gu.group)", "g", null, search, true, true, true, "gu.user.id = :adminId AND gu.moderator = true", null, searchFields), Long.class).setParameter("adminId", (Object)adminId).getSingleResult();
    }

    public List<Group> get(Collection<Long> ids) {
        return this.em.createNamedQuery("getGroupsByIds", Group.class).setParameter("ids", ids).getResultList();
    }

    public List<Group> getLimited() {
        return this.em.createNamedQuery("getLimitedGroups", Group.class).getResultList();
    }

    @Override
    public Group update(Group entity, Long userId) {
        if (entity.getId() == null) {
            if (userId != null) {
                entity.setInsertedby(userId);
            }
            entity.setInserted(new Date());
            this.em.persist((Object)entity);
        } else {
            if (userId != null) {
                entity.setUpdatedby(userId);
            }
            entity.setUpdated(new Date());
            entity = (Group)this.em.merge((Object)entity);
        }
        return entity;
    }

    @Override
    public void delete(Group g, Long userId) {
        this.em.createNamedQuery("deleteGroupUsersByGroup").setParameter("id", (Object)g.getId()).executeUpdate();
        g.setDeleted(true);
        if (userId != null) {
            g.setUpdatedby(userId);
        }
        this.em.merge((Object)g);
    }
}

