/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.util;

import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.db.util.LocaleHelper;
import org.apache.openmeetings.db.util.TimezoneUtil;
import org.apache.wicket.util.string.Strings;

public class FormatHelper {
    private static final Pattern RtlLocalesRe = Pattern.compile("^(ar|dv|he|iw|fa|nqo|ps|sd|ug|ur|yi|.*[-_](Arab|Hebr|Thaa|Nkoo|Tfng))(?!.*[-_](Latn|Cyrl)($|-|_))($|-|_)");

    private FormatHelper() {
    }

    public static boolean isRtlLanguage(String languageString) {
        return languageString != null && RtlLocalesRe.matcher(languageString).find();
    }

    public static String formatUser(User u) {
        return FormatHelper.formatUser(u, false);
    }

    public static String formatUser(User u, boolean isHTMLEscape) {
        String user = "";
        if (u != null) {
            String email = u.getAddress() == null ? "" : u.getAddress().getEmail();
            user = Strings.isEmpty((CharSequence)u.getFirstname()) && Strings.isEmpty((CharSequence)u.getLastname()) ? email : String.format("\"%s %s\" <%s>", u.getFirstname(), u.getLastname(), email);
            user = isHTMLEscape ? StringEscapeUtils.escapeHtml4((String)user) : user;
        }
        return user;
    }

    public static FastDateFormat getDateFormat(User u) {
        return FastDateFormat.getDateInstance((int)3, (TimeZone)TimezoneUtil.getTimeZone(u), (Locale)LocaleHelper.getLocale(u));
    }

    public static FastDateFormat getTimeFormat(User u) {
        return FastDateFormat.getTimeInstance((int)3, (TimeZone)TimezoneUtil.getTimeZone(u), (Locale)LocaleHelper.getLocale(u));
    }

    public static FastDateFormat getDateTimeFormat(User u) {
        return FastDateFormat.getDateTimeInstance((int)3, (int)3, (TimeZone)TimezoneUtil.getTimeZone(u), (Locale)LocaleHelper.getLocale(u));
    }
}

