/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.util.ws;

import java.util.Date;
import java.util.UUID;
import org.apache.openmeetings.db.entity.basic.Client;
import org.apache.openmeetings.db.entity.user.User;
import org.apache.openmeetings.util.OmFileHelper;
import org.apache.wicket.protocol.ws.api.message.IWebSocketPushMessage;

public class RoomMessage
implements IWebSocketPushMessage {
    private static final long serialVersionUID = 1L;
    private final Date timestamp = new Date();
    private final String uid;
    private final Long roomId;
    private final Long userId;
    private final String name;
    private final Type type;

    public RoomMessage(Long roomId, Client c, Type type) {
        this(roomId, c.getUser(), type);
    }

    public RoomMessage(Long roomId, User u, Type type) {
        this(roomId, u.getId(), u.getDisplayName(), type);
    }

    private RoomMessage(Long roomId, Long userId, String displayName, Type type) {
        this.roomId = roomId;
        this.name = OmFileHelper.SIP_USER_ID.equals(userId) ? "SIP Transport" : displayName;
        this.userId = userId;
        this.type = type;
        this.uid = UUID.randomUUID().toString();
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public Long getRoomId() {
        return this.roomId;
    }

    public Long getUserId() {
        return this.userId;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public String getUid() {
        return this.uid;
    }

    public String toString() {
        return "RoomMessage [roomId=" + this.roomId + ", userId=" + this.userId + ", type=" + (Object)((Object)this.type) + "]";
    }

    public static enum Type {
        ROOM_ENTER,
        ROOM_EXIT,
        ROOM_CLOSED,
        POLL_CREATED,
        POLL_UPDATED,
        RECORDING_TOGGLED,
        SHARING_TOGGLED,
        RIGHT_UPDATED,
        ACTIVITY_REMOVE,
        REQUEST_RIGHT_MODERATOR,
        REQUEST_RIGHT_PRESENTER,
        REQUEST_RIGHT_WB,
        REQUEST_RIGHT_SHARE,
        REQUEST_RIGHT_REMOTE,
        REQUEST_RIGHT_A,
        REQUEST_RIGHT_AV,
        REQUEST_RIGHT_MUTE_OTHERS,
        HAVE_QUESTION,
        KICK,
        MUTE,
        MUTE_OTHERS,
        QUICK_POLL_UPDATED,
        KURENTO_STATUS,
        WB_RELOAD,
        MODERATOR_IN_ROOM;

    }
}

