/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.server;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import org.apache.openmeetings.db.dao.IDataProviderDao;
import org.apache.openmeetings.db.dao.basic.ConfigurationDao;
import org.apache.openmeetings.db.entity.server.OAuthServer;
import org.apache.openmeetings.db.util.DaoHelper;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class OAuth2Dao
implements IDataProviderDao<OAuthServer> {
    private static final String[] searchFields = new String[]{"name"};
    @PersistenceContext
    private EntityManager em;
    @Autowired
    private ConfigurationDao cfgDao;

    public List<OAuthServer> getActive() {
        if (!OpenmeetingsVariables.isAllowRegisterOauth()) {
            return new ArrayList<OAuthServer>();
        }
        TypedQuery query = this.em.createNamedQuery("getEnabledOAuthServers", OAuthServer.class);
        return query.getResultList();
    }

    @Override
    public OAuthServer get(Long id) {
        List list = this.em.createNamedQuery("getOAuthServerById", OAuthServer.class).setParameter("id", (Object)id).getResultList();
        return list.size() == 1 ? (OAuthServer)list.get(0) : null;
    }

    @Override
    public List<OAuthServer> get(long start, long count) {
        return DaoHelper.setLimits(this.em.createNamedQuery("getAllOAuthServers", OAuthServer.class), start, count).getResultList();
    }

    @Override
    public List<OAuthServer> get(String search, long start, long count, String order) {
        return DaoHelper.setLimits(this.em.createQuery(DaoHelper.getSearchQuery("OAuthServer", "s", search, true, false, null, searchFields), OAuthServer.class), start, count).getResultList();
    }

    @Override
    public long count() {
        TypedQuery q = this.em.createNamedQuery("countOAuthServers", Long.class);
        return (Long)q.getSingleResult();
    }

    @Override
    public long count(String search) {
        TypedQuery q = this.em.createQuery(DaoHelper.getSearchQuery("OAuthServer", "s", search, true, true, null, searchFields), Long.class);
        return (Long)q.getSingleResult();
    }

    @Override
    public OAuthServer update(OAuthServer server, Long userId) {
        if (server.getId() == null) {
            server.setInserted(new Date());
            this.em.persist((Object)server);
        } else {
            server.setUpdated(new Date());
            server = (OAuthServer)this.em.merge((Object)server);
        }
        this.cfgDao.updateCsp();
        return server;
    }

    @Override
    public void delete(OAuthServer server, Long userId) {
        server.setDeleted(true);
        this.update(server, userId);
    }
}

